/*     */ package org.jboss.managed.plugins;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.SimpleValue;
/*     */ 
/*     */ public class DefaultFieldsImpl
/*     */   implements Fields
/*     */ {
/*  44 */   private static String END_MARKER = "__END_OF_FIELDS__";
/*     */   private static final long serialVersionUID = 1L;
/*  50 */   private HashMap<String, Serializable> fields = new HashMap();
/*     */ 
/*     */   public DefaultFieldsImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DefaultFieldsImpl(String name)
/*     */   {
/*  66 */     setName(name);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  76 */     return (String)getField("name", String.class);
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  86 */     setField("name", name);
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/*  96 */     return (String)getField("description", String.class);
/*     */   }
/*     */ 
/*     */   public void setDescription(String description)
/*     */   {
/* 106 */     setField("description", description);
/*     */   }
/*     */ 
/*     */   public MetaType getMetaType()
/*     */   {
/* 116 */     return (MetaType)getField("metaType", MetaType.class);
/*     */   }
/*     */ 
/*     */   public void setMetaType(MetaType type)
/*     */   {
/* 126 */     setField("metaType", type);
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */   {
/* 136 */     return getField("value");
/*     */   }
/*     */ 
/*     */   public void setValue(Serializable value)
/*     */   {
/* 146 */     setField("value", value);
/*     */   }
/*     */ 
/*     */   public Set<MetaValue> getLegalValues()
/*     */   {
/* 157 */     return (Set)getField("legalValues", Set.class);
/*     */   }
/*     */ 
/*     */   public void setLegalValues(Set<MetaValue> values)
/*     */   {
/* 167 */     setField("legalValues", (Serializable)values);
/*     */   }
/*     */ 
/*     */   public Comparable getMinimumValue()
/*     */   {
/* 177 */     return (Comparable)getField("minValue", Comparable.class);
/*     */   }
/*     */ 
/*     */   public void setMinimumValue(Comparable value)
/*     */   {
/* 187 */     setField("minValue", (Serializable)value);
/*     */   }
/*     */ 
/*     */   public Comparable getMaximumValue()
/*     */   {
/* 197 */     return (Comparable)getField("maxValue", Comparable.class);
/*     */   }
/*     */ 
/*     */   public void setMaximumValue(Comparable value)
/*     */   {
/* 207 */     setField("maxValue", (Serializable)value);
/*     */   }
/*     */ 
/*     */   public boolean isMandatory()
/*     */   {
/* 217 */     Boolean result = (Boolean)getField("mandatory", Boolean.class);
/* 218 */     if (result == null)
/* 219 */       return false;
/* 220 */     return result.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setMandatory(boolean flag)
/*     */   {
/* 230 */     if (flag)
/* 231 */       setField("mandatory", Boolean.valueOf(flag));
/*     */     else
/* 233 */       setField("mandatory", null);
/*     */   }
/*     */ 
/*     */   public Serializable getField(String name)
/*     */   {
/* 243 */     return (Serializable)this.fields.get(name);
/*     */   }
/*     */ 
/*     */   public void setField(String name, Serializable value)
/*     */   {
/* 254 */     this.fields.put(name, value);
/*     */   }
/*     */ 
/*     */   public <T> T getField(String fieldName, Class<T> expected)
/*     */   {
/* 268 */     if (fieldName == null)
/* 269 */       throw new IllegalArgumentException("Null field name");
/* 270 */     if (expected == null) {
/* 271 */       throw new IllegalArgumentException("Null expected type");
/*     */     }
/* 273 */     Serializable field = getField(fieldName);
/*     */ 
/* 275 */     if (field == null) {
/* 276 */       return null;
/*     */     }
/* 278 */     if (expected.isInstance(field)) {
/* 279 */       return expected.cast(field);
/*     */     }
/* 281 */     if ((field instanceof SimpleValue))
/*     */     {
/* 283 */       SimpleValue value = (SimpleValue)field;
/* 284 */       Object result = value.getValue();
/* 285 */       if (result == null)
/* 286 */         return null;
/* 287 */       return expected.cast(result);
/*     */     }
/*     */ 
/* 290 */     throw new IllegalStateException("Field " + fieldName + " with value " + field + " is  a of the expected type: " + expected.getName());
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/* 305 */     for (Map.Entry entry : this.fields.entrySet())
/*     */     {
/* 307 */       if ((((String)entry.getKey()).equals("propertyInfo")) || 
/* 309 */         (((String)entry.getKey()).equals("attachment")))
/*     */         continue;
/* 311 */       out.writeUTF((String)entry.getKey());
/* 312 */       out.writeObject(entry.getValue());
/*     */     }
/* 314 */     out.writeUTF(END_MARKER);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
/* 319 */     this.fields = new HashMap();
/*     */     String key;
/*     */     do {
/* 323 */       key = in.readUTF();
/* 324 */       if (key.equals(END_MARKER)) {
/* 325 */         key = null;
/*     */       }
/*     */       else {
/* 328 */         Serializable value = (Serializable)in.readObject();
/* 329 */         this.fields.put(key, value);
/*     */       }
/*     */     }
/* 331 */     while (key != null);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.DefaultFieldsImpl
 * JD-Core Version:    0.6.0
 */