/*     */ package org.jboss.managed.plugins;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InvalidObjectException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.api.ManagedParameter;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.SimpleValue;
/*     */ 
/*     */ public class ManagedParameterImpl
/*     */   implements ManagedParameter
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private static final int VERSION1 = 1;
/*     */   private static final int STREAM_VERSION = 1;
/*     */   private Fields fields;
/*     */   private transient String name;
/*     */ 
/*     */   public ManagedParameterImpl(String name)
/*     */   {
/*  65 */     this(new DefaultFieldsImpl(name));
/*     */   }
/*     */ 
/*     */   public ManagedParameterImpl(Fields fields)
/*     */   {
/*  78 */     init(fields);
/*     */   }
/*     */ 
/*     */   public Fields getFields()
/*     */   {
/*  83 */     return this.fields;
/*     */   }
/*     */ 
/*     */   public <T> T getField(String fieldName, Class<T> expected)
/*     */   {
/*  90 */     if (fieldName == null)
/*  91 */       throw new IllegalArgumentException("Null field name");
/*  92 */     if (expected == null) {
/*  93 */       throw new IllegalArgumentException("Null expected type");
/*     */     }
/*  95 */     Serializable field = getFields().getField(fieldName);
/*     */ 
/*  97 */     if (field == null) {
/*  98 */       return null;
/*     */     }
/* 100 */     if (expected.isInstance(field)) {
/* 101 */       return expected.cast(field);
/*     */     }
/* 103 */     if ((field instanceof SimpleValue))
/*     */     {
/* 105 */       SimpleValue value = (SimpleValue)field;
/* 106 */       Object result = value.getValue();
/* 107 */       if (result == null)
/* 108 */         return null;
/* 109 */       return expected.cast(result);
/*     */     }
/*     */ 
/* 112 */     throw new IllegalStateException("Field " + fieldName + " with value " + field + " is not of the expected type: " + expected.getName());
/*     */   }
/*     */ 
/*     */   public void setField(String fieldName, Serializable value)
/*     */   {
/* 118 */     if (fieldName == null) {
/* 119 */       throw new IllegalArgumentException("Null field name");
/*     */     }
/* 121 */     getFields().setField(fieldName, value);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 126 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/* 131 */     return (String)getField("description", String.class);
/*     */   }
/*     */ 
/*     */   public void setDescription(String description)
/*     */   {
/* 141 */     setField("description", description);
/*     */   }
/*     */ 
/*     */   public Map<String, Annotation> getAnnotations()
/*     */   {
/* 152 */     Object set = getField("annotations", Object.class);
/* 153 */     return (Map)set;
/*     */   }
/*     */ 
/*     */   public void setAnnotations(Map<String, Annotation> annotations) {
/* 157 */     setField("annotations", (Serializable)annotations);
/*     */   }
/*     */ 
/*     */   public MetaType getMetaType()
/*     */   {
/* 162 */     return (MetaType)getField("metaType", MetaType.class);
/*     */   }
/*     */ 
/*     */   public void setMetaType(MetaType type)
/*     */   {
/* 172 */     setField("metaType", type);
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */   {
/* 177 */     return getField("value", Object.class);
/*     */   }
/*     */ 
/*     */   public void setValue(Serializable value)
/*     */   {
/* 182 */     setField("value", value);
/*     */   }
/*     */ 
/*     */   public Set<MetaValue> getLegalValues()
/*     */   {
/* 188 */     return (Set)getField("legalValues", Set.class);
/*     */   }
/*     */ 
/*     */   public void setLegalValues(Set<MetaValue> values)
/*     */   {
/* 198 */     setField("legalValues", (Serializable)values);
/*     */   }
/*     */ 
/*     */   public Comparable getMinimumValue()
/*     */   {
/* 203 */     return (Comparable)getField("minValue", Comparable.class);
/*     */   }
/*     */ 
/*     */   public void setMinimumValue(Comparable value)
/*     */   {
/* 213 */     setField("minValue", (Serializable)value);
/*     */   }
/*     */ 
/*     */   public Comparable getMaximumValue()
/*     */   {
/* 218 */     return (Comparable)getField("maxValue", Comparable.class);
/*     */   }
/*     */ 
/*     */   public void setMaximumValue(Comparable value)
/*     */   {
/* 228 */     setField("maxValue", (Serializable)value);
/*     */   }
/*     */ 
/*     */   public String checkValidValue(Serializable value)
/*     */   {
/* 234 */     return null;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 240 */     StringBuilder tmp = new StringBuilder("ManagedProperty");
/* 241 */     tmp.append('{');
/* 242 */     tmp.append(this.name);
/* 243 */     tmp.append(",metaType=");
/* 244 */     tmp.append(getMetaType());
/* 245 */     tmp.append('}');
/* 246 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 252 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 258 */     if (obj == this)
/* 259 */       return true;
/* 260 */     if ((obj == null) || (!(obj instanceof ManagedParameter))) {
/* 261 */       return false;
/*     */     }
/* 263 */     ManagedParameter other = (ManagedParameter)obj;
/* 264 */     return getName().equals(other.getName());
/*     */   }
/*     */ 
/*     */   private void init(Fields fields)
/*     */   {
/* 277 */     if (fields == null) {
/* 278 */       throw new IllegalArgumentException("Null fields");
/*     */     }
/* 280 */     this.fields = fields;
/*     */ 
/* 282 */     this.name = ((String)getField("name", String.class));
/* 283 */     if (this.name == null)
/* 284 */       throw new IllegalArgumentException("No name in fields");
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 297 */     int version = in.readInt();
/* 298 */     if (version == 1)
/* 299 */       readVersion1(in);
/*     */     else
/* 301 */       throw new InvalidObjectException("Unknown version=" + version);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/* 311 */     out.writeInt(1);
/* 312 */     out.writeObject(this.fields);
/*     */   }
/*     */ 
/*     */   private void readVersion1(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 322 */     this.fields = ((Fields)in.readObject());
/* 323 */     this.name = ((String)getField("name", String.class));
/* 324 */     if (this.name == null)
/* 325 */       throw new IOException("No name in fields");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.ManagedParameterImpl
 * JD-Core Version:    0.6.0
 */