/*     */ package org.jboss.managed.plugins;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.factory.ManagedObjectFactory;
/*     */ import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
/*     */ import org.jboss.managed.spi.factory.InstanceClassFactory;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.MetaValueFactory;
/*     */ import org.jboss.metatype.plugins.values.MetaValueFactoryBuilder;
/*     */ 
/*     */ public class WritethroughManagedPropertyImpl extends ManagedPropertyImpl
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private transient MetaValueFactory valueFactory;
/*     */   private transient ManagedObjectFactory objectFactory;
/*     */ 
/*     */   public WritethroughManagedPropertyImpl(Fields fields)
/*     */   {
/*  56 */     super(fields);
/*     */   }
/*     */ 
/*     */   public WritethroughManagedPropertyImpl(ManagedObject managedObject, Fields fields)
/*     */   {
/*  61 */     super(managedObject, fields);
/*     */   }
/*     */ 
/*     */   public WritethroughManagedPropertyImpl(Fields fields, MetaValueFactory valueFactory, ManagedObjectFactory objectFactory)
/*     */   {
/*  66 */     super(fields);
/*  67 */     this.valueFactory = valueFactory;
/*  68 */     this.objectFactory = objectFactory;
/*     */   }
/*     */ 
/*     */   protected ManagedObjectFactory getObjectFactory()
/*     */   {
/*  73 */     if (this.objectFactory == null)
/*  74 */       this.objectFactory = ManagedObjectFactoryBuilder.create();
/*  75 */     return this.objectFactory;
/*     */   }
/*     */ 
/*     */   protected MetaValueFactory getValueFactory()
/*     */   {
/*  80 */     if (this.valueFactory == null)
/*  81 */       this.valueFactory = MetaValueFactoryBuilder.create();
/*  82 */     return this.valueFactory;
/*     */   }
/*     */ 
/*     */   public void setValue(Serializable value)
/*     */   {
/*  93 */     super.setValue(value);
/*     */ 
/*  95 */     PropertyInfo propertyInfo = (PropertyInfo)getField("propertyInfo", PropertyInfo.class);
/*  96 */     if (propertyInfo != null)
/*     */     {
/*  98 */       Serializable attachment = getManagedObject().getAttachment();
/*  99 */       if (attachment != null)
/*     */       {
/*     */         MetaValue metaValue;
/*     */         MetaValue metaValue;
/* 102 */         if (!(value instanceof MetaValue))
/* 103 */           metaValue = getValueFactory().create(value, propertyInfo.getType());
/*     */         else {
/* 105 */           metaValue = (MetaValue)value;
/*     */         }
/* 107 */         if ((metaValue == null) || (!metaValue.getMetaType().isTable()))
/*     */         {
/* 109 */           InstanceClassFactory icf = getObjectFactory().getInstanceClassFactory(attachment.getClass());
/* 110 */           BeanInfo beanInfo = propertyInfo.getBeanInfo();
/* 111 */           icf.setValue(beanInfo, this, attachment, metaValue);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private Object writeReplace()
/*     */     throws ObjectStreamException
/*     */   {
/* 125 */     ManagedPropertyImpl managedProperty = new ManagedPropertyImpl(getManagedObject(), getFields());
/* 126 */     managedProperty.setTargetManagedObject(getTargetManagedObject());
/* 127 */     return managedProperty;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.WritethroughManagedPropertyImpl
 * JD-Core Version:    0.6.0
 */