/*    */ package org.jboss.managed.plugins.advice;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.Arrays;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class TraceAdvice
/*    */ {
/* 39 */   private static final Logger log = Logger.getLogger(TraceAdvice.class);
/*    */ 
/*    */   public Object invoke(Invocation invocation)
/*    */     throws Throwable
/*    */   {
/* 50 */     boolean trace = log.isTraceEnabled();
/* 51 */     if (trace) {
/* 52 */       logMethod(false, invocation, null, null);
/*    */     }
/* 54 */     Throwable e = null;
/* 55 */     Object result = null;
/*    */     try
/*    */     {
/* 58 */       result = invocation.invokeNext();
/* 59 */       Object localObject1 = result;
/*    */       return localObject1;
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 63 */       e = t;
/* 64 */       throw t;
/*    */     }
/*    */     finally
/*    */     {
/* 68 */       logMethod(true, invocation, result, e); } throw localObject2;
/*    */   }
/*    */ 
/*    */   private void logMethod(boolean beforeAfter, Invocation invocation, Object result, Throwable t)
/*    */   {
/* 74 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 75 */     StringBuilder builder = new StringBuilder();
/* 76 */     Object target = mi.getTargetObject();
/* 77 */     builder.append(target.getClass().getSimpleName());
/* 78 */     builder.append('@');
/* 79 */     builder.append(System.identityHashCode(target));
/* 80 */     if (!beforeAfter)
/* 81 */       builder.append(" before ");
/*    */     else
/* 83 */       builder.append(" after  ");
/* 84 */     builder.append(mi.getActualMethod().getName());
/* 85 */     if (!beforeAfter)
/*    */     {
/* 87 */       builder.append(" params=");
/* 88 */       builder.append(Arrays.asList(mi.getArguments()));
/*    */     }
/* 90 */     else if (t == null)
/*    */     {
/* 92 */       builder.append(" result=");
/* 93 */       builder.append(result);
/*    */     }
/* 95 */     if (t != null)
/* 96 */       builder.append(" ended in error:");
/* 97 */     log.trace(builder.toString(), t);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.advice.TraceAdvice
 * JD-Core Version:    0.6.0
 */