/*    */ package org.jboss.managed.plugins.advice;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.util.AbstractSet;
/*    */ import java.util.Iterator;
/*    */ import java.util.Set;
/*    */ 
/*    */ class WrapperSet<T> extends AbstractSet<T>
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -5588975054846538928L;
/*    */   private Set<T> delegate;
/*    */   private Class<T> interfaceClass;
/*    */ 
/*    */   public WrapperSet(Set<T> delegate, Class<T> interfaceClass)
/*    */   {
/* 55 */     if (delegate == null)
/* 56 */       throw new IllegalArgumentException("Null delegate");
/* 57 */     if (interfaceClass == null) {
/* 58 */       throw new IllegalArgumentException("Null interface class");
/*    */     }
/* 60 */     this.delegate = delegate;
/* 61 */     this.interfaceClass = interfaceClass;
/*    */   }
/*    */ 
/*    */   public Iterator<T> iterator()
/*    */   {
/* 66 */     return new WrapperIterator(this.delegate.iterator(), this.interfaceClass);
/*    */   }
/*    */ 
/*    */   public int size()
/*    */   {
/* 71 */     return this.delegate.size();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.advice.WrapperSet
 * JD-Core Version:    0.6.0
 */