/*     */ package org.jboss.messaging.core.impl;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.ClusterNotification;
/*     */ import org.jboss.messaging.core.contract.ClusterNotificationListener;
/*     */ import org.jboss.messaging.core.impl.tx.TransactionRepository;
/*     */ 
/*     */ public class FailoverWaiter
/*     */   implements ClusterNotificationListener
/*     */ {
/*  39 */   private static final Logger log = Logger.getLogger(FailoverWaiter.class);
/*     */ 
/*  41 */   private int failingOverFor = -1;
/*     */ 
/*  43 */   private int failedOverFor = -1;
/*     */   private Object failoverStatusLock;
/*     */   private long failoverStartTimeout;
/*     */   private long failoverCompleteTimeout;
/*     */   private int nodeID;
/*     */   private TransactionRepository txRepository;
/*     */ 
/*     */   public FailoverWaiter(int nodeID, long failoverStartTimeout, long failoverCompleteTimeout, TransactionRepository txRepository)
/*     */   {
/*  58 */     this.failoverStatusLock = new Object();
/*     */ 
/*  60 */     this.nodeID = nodeID;
/*     */ 
/*  62 */     this.failoverStartTimeout = failoverStartTimeout;
/*     */ 
/*  64 */     this.failoverCompleteTimeout = failoverCompleteTimeout;
/*     */ 
/*  66 */     this.txRepository = txRepository;
/*     */   }
/*     */ 
/*     */   public int waitForFailover(int failedNodeID)
/*     */     throws Exception
/*     */   {
/*  74 */     log.trace("Waiting for failover for " + failedNodeID + " failingOverFor: " + this.failingOverFor + " failedOverFor: " + this.failedOverFor);
/*     */ 
/*  83 */     synchronized (this.failoverStatusLock)
/*     */     {
/*  85 */       long startToWait = this.failoverStartTimeout;
/*     */ 
/*  87 */       while ((startToWait > 0L) && (this.failingOverFor != failedNodeID) && (this.failedOverFor != failedNodeID))
/*     */       {
/*  89 */         long start = System.currentTimeMillis();
/*     */         try
/*     */         {
/*  92 */           log.debug(this + " blocking on the failover lock, waiting for failover to start");
/*  93 */           this.failoverStatusLock.wait(startToWait);
/*  94 */           log.debug(this + " releasing the failover lock, checking again whether failover started ...");
/*     */         }
/*     */         catch (InterruptedException ignore)
/*     */         {
/*     */         }
/*  99 */         startToWait -= System.currentTimeMillis() - start;
/*     */       }
/*     */ 
/* 102 */       if ((this.failingOverFor != failedNodeID) && (this.failedOverFor != failedNodeID))
/*     */       {
/* 105 */         log.debug("Timed out waiting for failover to start");
/*     */ 
/* 107 */         return -1;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 112 */     synchronized (this.failoverStatusLock)
/*     */     {
/* 114 */       long completeToWait = this.failoverCompleteTimeout;
/*     */ 
/* 116 */       while ((completeToWait > 0L) && (this.failedOverFor != failedNodeID))
/*     */       {
/* 118 */         long start = System.currentTimeMillis();
/*     */         try
/*     */         {
/* 121 */           log.debug(this + " blocking on the failover lock, waiting for failover to complete");
/* 122 */           this.failoverStatusLock.wait(completeToWait);
/* 123 */           log.debug(this + " releasing the failover lock, checking again whether failover completed ...");
/*     */         }
/*     */         catch (InterruptedException ignore)
/*     */         {
/*     */         }
/* 128 */         completeToWait -= System.currentTimeMillis() - start;
/*     */       }
/*     */ 
/* 131 */       if (this.failedOverFor != failedNodeID)
/*     */       {
/* 134 */         log.debug("Timed out waiting for failover to complete");
/*     */ 
/* 136 */         return -1;
/*     */       }
/*     */     }
/*     */ 
/* 140 */     return this.nodeID;
/*     */   }
/*     */ 
/*     */   public void notify(ClusterNotification notification)
/*     */   {
/* 145 */     if (notification.type == 2)
/*     */     {
/* 147 */       synchronized (this.failoverStatusLock)
/*     */       {
/* 149 */         this.failingOverFor = notification.nodeID;
/*     */ 
/* 151 */         this.failoverStatusLock.notifyAll();
/*     */       }
/*     */     }
/* 154 */     else if (notification.type == 3)
/*     */     {
/*     */       try
/*     */       {
/* 160 */         this.txRepository.loadPreparedTransactions();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 164 */         log.error("Failed to load prepared transactions", e);
/*     */       }
/*     */ 
/* 167 */       synchronized (this.failoverStatusLock)
/*     */       {
/* 169 */         this.failedOverFor = this.failingOverFor;
/*     */ 
/* 171 */         this.failingOverFor = -1;
/*     */ 
/* 173 */         this.failoverStatusLock.notifyAll();
/*     */       }
/*     */     }
/* 176 */     else if (notification.type == 4)
/*     */     {
/* 178 */       synchronized (this.failoverStatusLock)
/*     */       {
/* 183 */         if (notification.nodeID == this.failedOverFor)
/*     */         {
/* 185 */           this.failedOverFor = -1;
/*     */ 
/* 187 */           this.failoverStatusLock.notifyAll();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.FailoverWaiter
 * JD-Core Version:    0.6.0
 */