/*     */ package org.jboss.messaging.core.impl;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.sql.DataSource;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.MessagingComponent;
/*     */ 
/*     */ public class JDBCSupport
/*     */   implements MessagingComponent
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(JDBCSupport.class);
/*     */ 
/*  55 */   private static boolean trace = log.isTraceEnabled();
/*     */   protected DataSource ds;
/*     */   private TransactionManager tm;
/*     */   protected Properties sqlProperties;
/*     */   private Map defaultDMLStatements;
/*     */   private Map defaultDDLStatements;
/*  67 */   private boolean createTablesOnStartup = true;
/*     */ 
/*     */   public JDBCSupport()
/*     */   {
/*  71 */     this.defaultDMLStatements = new LinkedHashMap();
/*     */ 
/*  73 */     this.defaultDDLStatements = new LinkedHashMap();
/*     */ 
/*  75 */     this.sqlProperties = new Properties();
/*     */   }
/*     */ 
/*     */   public JDBCSupport(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup)
/*     */   {
/*  81 */     this();
/*     */ 
/*  83 */     this.ds = ds;
/*     */ 
/*  85 */     this.tm = tm;
/*     */ 
/*  87 */     if (sqlProperties != null)
/*     */     {
/*  89 */       this.sqlProperties = sqlProperties;
/*     */     }
/*     */ 
/*  92 */     this.createTablesOnStartup = createTablesOnStartup;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*  99 */     this.defaultDMLStatements.putAll(getDefaultDMLStatements());
/*     */ 
/* 101 */     this.defaultDDLStatements.putAll(getDefaultDDLStatements());
/*     */ 
/* 104 */     Properties sqlPropertiesCopy = new Properties();
/*     */ 
/* 106 */     for (Iterator iterSQL = this.sqlProperties.entrySet().iterator(); iterSQL.hasNext(); )
/*     */     {
/* 108 */       Map.Entry entry = (Map.Entry)iterSQL.next();
/* 109 */       if (!ignoreVerificationOnStartup((String)entry.getKey()))
/*     */       {
/* 111 */         sqlPropertiesCopy.put(entry.getKey(), entry.getValue());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 116 */     Iterator iter = sqlPropertiesCopy.keySet().iterator();
/*     */ 
/* 118 */     while (iter.hasNext())
/*     */     {
/* 120 */       String statementName = (String)iter.next();
/*     */ 
/* 124 */       getSQLStatement(statementName);
/*     */     }
/*     */ 
/* 130 */     if (!sqlPropertiesCopy.isEmpty())
/*     */     {
/* 132 */       iter = this.defaultDMLStatements.keySet().iterator();
/*     */ 
/* 134 */       while (iter.hasNext())
/*     */       {
/* 136 */         String statementName = (String)iter.next();
/*     */ 
/* 138 */         if (this.sqlProperties.get(statementName) == null)
/*     */         {
/* 140 */           throw new IllegalStateException("SQL statement " + statementName + " is not specified in the SQL properties");
/*     */         }
/*     */       }
/*     */ 
/* 144 */       iter = this.defaultDDLStatements.keySet().iterator();
/*     */ 
/* 146 */       while (iter.hasNext())
/*     */       {
/* 148 */         String statementName = (String)iter.next();
/*     */ 
/* 150 */         if (sqlPropertiesCopy.get(statementName) == null)
/*     */         {
/* 152 */           throw new IllegalStateException("SQL statement " + statementName + " is not specified in the SQL properties");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 157 */     if (this.createTablesOnStartup)
/*     */     {
/* 159 */       createSchema();
/*     */     }
/*     */     else
/*     */     {
/* 163 */       log.debug("Schema is not being created as createTablesOnStartup=" + this.createTablesOnStartup);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected String getSQLStatement(String statementName)
/*     */   {
/* 175 */     String defaultStatement = (String)this.defaultDMLStatements.get(statementName);
/*     */ 
/* 177 */     if (defaultStatement == null)
/*     */     {
/* 179 */       defaultStatement = (String)this.defaultDDLStatements.get(statementName);
/*     */     }
/*     */ 
/* 182 */     if (defaultStatement == null)
/*     */     {
/* 184 */       throw new IllegalArgumentException("No such SQL statement: " + statementName);
/*     */     }
/*     */ 
/* 187 */     return this.sqlProperties.getProperty(statementName, defaultStatement);
/*     */   }
/*     */ 
/*     */   protected Map getDefaultDMLStatements()
/*     */   {
/* 192 */     return Collections.EMPTY_MAP;
/*     */   }
/*     */ 
/*     */   protected Map getDefaultDDLStatements()
/*     */   {
/* 197 */     return Collections.EMPTY_MAP;
/*     */   }
/*     */ 
/*     */   protected boolean ignoreVerificationOnStartup(String statementName)
/*     */   {
/* 204 */     return false;
/*     */   }
/*     */ 
/*     */   protected void closeResultSet(ResultSet rs)
/*     */   {
/* 209 */     if (rs != null)
/*     */     {
/*     */       try
/*     */       {
/* 213 */         rs.close();
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 217 */         if (trace)
/*     */         {
/* 219 */           log.trace("Failed to close result set", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void closeStatement(Statement st)
/*     */   {
/* 227 */     if (st != null)
/*     */     {
/*     */       try
/*     */       {
/* 231 */         st.close();
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 235 */         if (trace)
/*     */         {
/* 237 */           log.trace("Failed to close statement", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void closeConnection(Connection conn)
/*     */   {
/* 245 */     if (conn != null)
/*     */     {
/*     */       try
/*     */       {
/* 249 */         conn.close();
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 253 */         if (trace)
/*     */         {
/* 255 */           log.trace("Failed to close statement", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void createSchema()
/*     */     throws Exception
/*     */   {
/* 269 */     for (Iterator i = this.defaultDDLStatements.keySet().iterator(); i.hasNext(); )
/*     */     {
/* 271 */       Connection conn = null;
/*     */ 
/* 273 */       Statement st = null;
/*     */ 
/* 275 */       TransactionWrapper tx = new TransactionWrapper();
/*     */       try
/*     */       {
/* 279 */         conn = this.ds.getConnection();
/*     */ 
/* 281 */         String statementName = (String)i.next();
/*     */ 
/* 283 */         String statement = getSQLStatement(statementName);
/*     */ 
/* 285 */         if (!"IGNORE".equals(statement))
/*     */         {
/*     */           try
/*     */           {
/* 289 */             if (log.isTraceEnabled()) log.trace("Executing: " + statement);
/*     */ 
/* 291 */             st = conn.createStatement();
/*     */ 
/* 293 */             st.executeUpdate(statement);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 297 */             log.debug("Failed to execute: " + statement, e);
/*     */ 
/* 299 */             tx.exceptionOccurred();
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 304 */           log.debug("createSchema ignoring statement for " + statementName);
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 309 */         closeStatement(st);
/*     */ 
/* 311 */         closeConnection(conn);
/*     */ 
/* 313 */         tx.end();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract class JDBCTxRunner2<T>
/*     */   {
/*     */     private static final int MAX_TRIES = 25;
/*     */     protected Connection conn;
/*     */ 
/*     */     protected JDBCTxRunner2()
/*     */     {
/*     */     }
/*     */ 
/*     */     public T execute()
/*     */       throws Exception
/*     */     {
/* 445 */       Transaction tx = JDBCSupport.this.tm.suspend();
/*     */       try
/*     */       {
/* 449 */         this.conn = JDBCSupport.this.ds.getConnection();
/*     */ 
/* 451 */         this.conn.setAutoCommit(false);
/*     */ 
/* 453 */         Object res = doTransaction();
/*     */ 
/* 455 */         this.conn.commit();
/*     */ 
/* 457 */         Object localObject1 = res;
/*     */         return localObject1;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */         try
/*     */         {
/* 463 */           this.conn.rollback();
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 467 */           JDBCSupport.log.trace("Failed to rollback", t);
/*     */         }
/*     */ 
/* 470 */         throw e;
/*     */       }
/*     */       finally
/*     */       {
/* 474 */         JDBCSupport.this.closeConnection(this.conn);
/*     */ 
/* 476 */         if (tx != null)
/*     */         {
/* 478 */           JDBCSupport.this.tm.resume(tx);
/*     */         }
/*     */       }
/* 480 */       throw localObject2;
/*     */     }
/*     */ 
/*     */     public T executeWithRetry() throws Exception
/*     */     {
/* 485 */       int tries = 0;
/*     */       while (true)
/*     */       {
/*     */         try
/*     */         {
/* 491 */           Object res = execute();
/*     */ 
/* 493 */           if (tries <= 0)
/*     */             continue;
/* 495 */           JDBCSupport.log.warn("Update worked after retry");
/*     */ 
/* 497 */           return res;
/*     */         }
/*     */         catch (SQLException e)
/*     */         {
/* 501 */           JDBCSupport.log.warn("SQLException caught, SQLState " + e.getSQLState() + " code:" + e.getErrorCode() + "- assuming deadlock detected, try:" + (tries + 1), e);
/*     */ 
/* 503 */           tries++;
/* 504 */           if (tries != 25)
/*     */             continue;
/* 506 */           JDBCSupport.log.error("Retried " + tries + " times, now giving up");
/* 507 */           throw new IllegalStateException("Failed to excecute transaction");
/*     */ 
/* 509 */           JDBCSupport.log.warn("Trying again after a pause");
/*     */ 
/* 511 */           Thread.sleep(()(Math.random() * 500.0D));
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public abstract T doTransaction()
/*     */       throws Exception;
/*     */   }
/*     */ 
/*     */   protected abstract class JDBCTxRunner<T>
/*     */   {
/*     */     private static final int MAX_TRIES = 25;
/*     */     protected Connection conn;
/*     */     private JDBCSupport.TransactionWrapper wrap;
/*     */ 
/*     */     protected JDBCTxRunner()
/*     */     {
/*     */     }
/*     */ 
/*     */     public T execute()
/*     */       throws Exception
/*     */     {
/* 380 */       this.wrap = new JDBCSupport.TransactionWrapper(JDBCSupport.this);
/*     */       try
/*     */       {
/* 384 */         this.conn = JDBCSupport.this.ds.getConnection();
/*     */ 
/* 386 */         Object localObject1 = doTransaction();
/*     */         return localObject1;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 390 */         this.wrap.exceptionOccurred();
/* 391 */         throw e;
/*     */       }
/*     */       finally
/*     */       {
/* 395 */         this.wrap.end();
/* 396 */         JDBCSupport.this.closeConnection(this.conn);
/* 397 */       }throw localObject2;
/*     */     }
/*     */ 
/*     */     public T executeWithRetry() throws Exception
/*     */     {
/* 402 */       int tries = 0;
/*     */       while (true)
/*     */       {
/*     */         try
/*     */         {
/* 408 */           Object res = execute();
/*     */ 
/* 410 */           if (tries <= 0)
/*     */             continue;
/* 412 */           JDBCSupport.log.warn("Update worked after retry");
/*     */ 
/* 414 */           return res;
/*     */         }
/*     */         catch (SQLException e)
/*     */         {
/* 418 */           JDBCSupport.log.warn("SQLException caught, SQLState " + e.getSQLState() + " code:" + e.getErrorCode() + "- assuming deadlock detected, try:" + (tries + 1), e);
/*     */ 
/* 420 */           tries++;
/* 421 */           if (tries != 25)
/*     */             continue;
/* 423 */           JDBCSupport.log.error("Retried " + tries + " times, now giving up");
/* 424 */           throw new IllegalStateException("Failed to excecute transaction");
/*     */ 
/* 426 */           JDBCSupport.log.warn("Trying again after a pause");
/*     */ 
/* 428 */           Thread.sleep(()(Math.random() * 500.0D));
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public abstract T doTransaction()
/*     */       throws Exception;
/*     */   }
/*     */ 
/*     */   protected class TransactionWrapper
/*     */   {
/*     */     private Transaction oldTx;
/*     */     private boolean failed;
/*     */ 
/*     */     public TransactionWrapper()
/*     */       throws Exception
/*     */     {
/* 328 */       this.oldTx = JDBCSupport.this.tm.suspend();
/*     */ 
/* 330 */       JDBCSupport.this.tm.begin();
/*     */     }
/*     */ 
/*     */     public void end() throws Exception
/*     */     {
/*     */       try
/*     */       {
/* 337 */         if (1 == JDBCSupport.this.tm.getStatus())
/*     */         {
/* 339 */           this.failed = true;
/* 340 */           if (JDBCSupport.trace) JDBCSupport.log.trace("Rolling back tx");
/* 341 */           JDBCSupport.this.tm.rollback();
/*     */         }
/*     */         else
/*     */         {
/* 345 */           if (JDBCSupport.trace) JDBCSupport.log.trace("Committing tx");
/* 346 */           JDBCSupport.this.tm.commit();
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 351 */         if ((this.oldTx != null) && (JDBCSupport.this.tm != null))
/*     */         {
/* 353 */           if (JDBCSupport.trace) JDBCSupport.log.trace("Resuming tx");
/* 354 */           JDBCSupport.this.tm.resume(this.oldTx);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void exceptionOccurred() throws Exception
/*     */     {
/* 361 */       JDBCSupport.this.tm.setRollbackOnly();
/*     */     }
/*     */ 
/*     */     public boolean isFailed()
/*     */     {
/* 366 */       return this.failed;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.JDBCSupport
 * JD-Core Version:    0.6.0
 */