/*     */ package org.jboss.messaging.core.impl.jchannelfactory;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.messaging.core.contract.ChannelFactory;
/*     */ import org.jgroups.Channel;
/*     */ 
/*     */ public class MultiplexerChannelFactory
/*     */   implements ChannelFactory
/*     */ {
/*  43 */   private static final String[] MUX_SIGNATURE = { "java.lang.String", "java.lang.String", "boolean", "java.lang.String" };
/*     */   MBeanServer server;
/*     */   ObjectName channelFactory;
/*     */   String dataStack;
/*     */   String controlStack;
/*     */   String uniqueID;
/*     */   private static final String MUX_OPERATION = "createMultiplexerChannel";
/*     */ 
/*     */   public MultiplexerChannelFactory(MBeanServer server, ObjectName channelFactory, String uniqueID, String controlStack, String dataStack)
/*     */   {
/*  64 */     this.server = server;
/*  65 */     this.channelFactory = channelFactory;
/*  66 */     this.uniqueID = uniqueID;
/*  67 */     this.dataStack = dataStack;
/*  68 */     this.controlStack = controlStack;
/*     */   }
/*     */ 
/*     */   public MBeanServer getServer()
/*     */   {
/*  75 */     return this.server;
/*     */   }
/*     */ 
/*     */   public void setServer(MBeanServer server)
/*     */   {
/*  80 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public ObjectName getChannelFactory()
/*     */   {
/*  85 */     return this.channelFactory;
/*     */   }
/*     */ 
/*     */   public void setChannelFactory(ObjectName channelFactory)
/*     */   {
/*  90 */     this.channelFactory = channelFactory;
/*     */   }
/*     */ 
/*     */   public String getDataStack()
/*     */   {
/*  95 */     return this.dataStack;
/*     */   }
/*     */ 
/*     */   public void setDataStack(String dataStack)
/*     */   {
/* 100 */     this.dataStack = dataStack;
/*     */   }
/*     */ 
/*     */   public String getControlStack()
/*     */   {
/* 105 */     return this.controlStack;
/*     */   }
/*     */ 
/*     */   public void setControlStack(String controlStack)
/*     */   {
/* 110 */     this.controlStack = controlStack;
/*     */   }
/*     */ 
/*     */   public String getUniqueID()
/*     */   {
/* 115 */     return this.uniqueID;
/*     */   }
/*     */ 
/*     */   public void setUniqueID(String uniqueID)
/*     */   {
/* 120 */     this.uniqueID = uniqueID;
/*     */   }
/*     */ 
/*     */   public Channel createControlChannel() throws Exception
/*     */   {
/* 125 */     return (Channel)this.server.invoke(this.channelFactory, "createMultiplexerChannel", new Object[] { this.controlStack, this.uniqueID + "-CTRL", Boolean.TRUE, this.uniqueID }, MUX_SIGNATURE);
/*     */   }
/*     */ 
/*     */   public Channel createDataChannel()
/*     */     throws Exception
/*     */   {
/* 133 */     return (Channel)this.server.invoke(this.channelFactory, "createMultiplexerChannel", new Object[] { this.dataStack, this.uniqueID + "-DATA", Boolean.FALSE, this.uniqueID }, MUX_SIGNATURE);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.jchannelfactory.MultiplexerChannelFactory
 * JD-Core Version:    0.6.0
 */