/*     */ package org.jboss.messaging.core.impl.postoffice;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.messaging.core.impl.message.MessageFactory;
/*     */ 
/*     */ class MessageRequest extends ClusterRequest
/*     */ {
/*     */   private String routingConditionText;
/*     */   private Message message;
/*     */   private Set queueNames;
/*     */ 
/*     */   MessageRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   MessageRequest(String routingConditionText, Message message, Set queueNames)
/*     */   {
/*  58 */     this.routingConditionText = routingConditionText;
/*     */ 
/*  60 */     this.message = message;
/*     */ 
/*  62 */     this.queueNames = queueNames;
/*     */   }
/*     */ 
/*     */   Object execute(RequestTarget office) throws Exception
/*     */   {
/*  67 */     office.routeFromCluster(this.message, this.routingConditionText, this.queueNames);
/*     */ 
/*  69 */     return null;
/*     */   }
/*     */ 
/*     */   byte getType()
/*     */   {
/*  74 */     return 5;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in) throws Exception
/*     */   {
/*  79 */     this.routingConditionText = in.readUTF();
/*     */ 
/*  81 */     byte type = in.readByte();
/*     */ 
/*  83 */     this.message = MessageFactory.createMessage(type);
/*     */ 
/*  85 */     this.message.read(in);
/*     */ 
/*  87 */     byte b = in.readByte();
/*     */ 
/*  89 */     if (b != 0)
/*     */     {
/*  91 */       int size = in.readInt();
/*     */ 
/*  93 */       this.queueNames = new HashSet(size);
/*     */ 
/*  95 */       for (int i = 0; i < size; i++)
/*     */       {
/*  97 */         String queueName = in.readUTF();
/*     */ 
/*  99 */         this.queueNames.add(queueName);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 106 */     out.writeUTF(this.routingConditionText);
/*     */ 
/* 108 */     out.writeByte(this.message.getType());
/*     */ 
/* 110 */     this.message.write(out);
/*     */ 
/* 112 */     if (this.queueNames == null)
/*     */     {
/* 114 */       out.writeByte(0);
/*     */     }
/*     */     else
/*     */     {
/* 118 */       out.writeByte(1);
/*     */ 
/* 120 */       out.writeInt(this.queueNames.size());
/*     */ 
/* 122 */       Iterator iter = this.queueNames.iterator();
/*     */ 
/* 124 */       while (iter.hasNext())
/*     */       {
/* 126 */         String queueName = (String)iter.next();
/*     */ 
/* 128 */         out.writeUTF(queueName);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.MessageRequest
 * JD-Core Version:    0.6.0
 */