/*     */ package org.jboss.messaging.core.impl.postoffice;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Serializable;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ import org.jgroups.Address;
/*     */ import org.jgroups.stack.IpAddress;
/*     */ 
/*     */ class PostOfficeAddressInfo
/*     */   implements Streamable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 8462102430717730566L;
/*     */   private Address controlChannelAddress;
/*     */   private Address dataChannelAddress;
/*     */ 
/*     */   PostOfficeAddressInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   PostOfficeAddressInfo(Address controlChannelAddress, Address dataChannelAddress)
/*     */   {
/*  65 */     this.controlChannelAddress = controlChannelAddress;
/*  66 */     this.dataChannelAddress = dataChannelAddress;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/*  73 */     this.controlChannelAddress = new IpAddress();
/*     */ 
/*  75 */     this.controlChannelAddress.readFrom(in);
/*     */ 
/*  77 */     this.dataChannelAddress = new IpAddress();
/*     */ 
/*  79 */     this.dataChannelAddress.readFrom(in);
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/*  84 */     if (!(this.controlChannelAddress instanceof IpAddress))
/*     */     {
/*  86 */       throw new IllegalStateException("Address must be IpAddress");
/*     */     }
/*     */ 
/*  89 */     if (!(this.dataChannelAddress instanceof IpAddress))
/*     */     {
/*  91 */       throw new IllegalStateException("Address must be IpAddress");
/*     */     }
/*     */ 
/*  94 */     this.controlChannelAddress.writeTo(out);
/*     */ 
/*  96 */     this.dataChannelAddress.writeTo(out);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 103 */     StringBuffer sb = new StringBuffer("[");
/* 104 */     sb.append("synch addr ").append(this.controlChannelAddress);
/* 105 */     sb.append(", asynch addr ").append(this.dataChannelAddress);
/* 106 */     sb.append("]");
/*     */ 
/* 108 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   Address getControlChannelAddress()
/*     */   {
/* 116 */     return this.controlChannelAddress;
/*     */   }
/*     */ 
/*     */   Address getDataChannelAddress()
/*     */   {
/* 121 */     return this.dataChannelAddress;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.PostOfficeAddressInfo
 * JD-Core Version:    0.6.0
 */