/*     */ package org.jboss.messaging.core.impl.postoffice;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Serializable;
/*     */ import org.jboss.messaging.util.StreamUtils;
/*     */ 
/*     */ class PutReplicantRequest extends ClusterRequest
/*     */ {
/*     */   private int nodeId;
/*     */   private Serializable key;
/*     */   private Serializable replicant;
/*     */ 
/*     */   PutReplicantRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   PutReplicantRequest(int nodeId, Serializable key, Serializable replicant)
/*     */   {
/*  63 */     this.nodeId = nodeId;
/*     */ 
/*  65 */     this.key = key;
/*     */ 
/*  67 */     this.replicant = replicant;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/*  74 */     this.nodeId = in.readInt();
/*     */ 
/*  76 */     this.key = ((Serializable)StreamUtils.readObject(in, true));
/*     */ 
/*  78 */     this.replicant = ((Serializable)StreamUtils.readObject(in, true));
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/*  83 */     out.writeInt(this.nodeId);
/*     */ 
/*  85 */     StreamUtils.writeObject(out, this.key, true, true);
/*     */ 
/*  87 */     StreamUtils.writeObject(out, this.replicant, true, true);
/*     */   }
/*     */ 
/*     */   Object execute(RequestTarget office)
/*     */     throws Exception
/*     */   {
/*  94 */     office.putReplicantLocally(this.nodeId, this.key, this.replicant);
/*  95 */     return null;
/*     */   }
/*     */ 
/*     */   byte getType()
/*     */   {
/* 100 */     return 6;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 107 */     return "PutRequest[" + this.key + "][" + this.replicant + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.PutReplicantRequest
 * JD-Core Version:    0.6.0
 */