/*    */ package org.jboss.messaging.core.impl.postoffice;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ 
/*    */ public class ReplicateAckMessage extends ClusterRequest
/*    */ {
/*    */   private int nodeID;
/*    */   private String queueName;
/*    */   private long messageID;
/*    */ 
/*    */   public ReplicateAckMessage()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ReplicateAckMessage(int nodeID, String queueName, long messageID)
/*    */   {
/* 49 */     this.nodeID = nodeID;
/*    */ 
/* 51 */     this.queueName = queueName;
/*    */ 
/* 53 */     this.messageID = messageID;
/*    */   }
/*    */ 
/*    */   Object execute(RequestTarget office) throws Throwable
/*    */   {
/* 58 */     office.handleReplicateAck(this.nodeID, this.queueName, this.messageID);
/*    */ 
/* 60 */     return null;
/*    */   }
/*    */ 
/*    */   byte getType()
/*    */   {
/* 65 */     return 10;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream in) throws Exception
/*    */   {
/* 70 */     this.nodeID = in.readInt();
/*    */ 
/* 72 */     this.queueName = in.readUTF();
/*    */ 
/* 74 */     this.messageID = in.readLong();
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream out) throws Exception
/*    */   {
/* 79 */     out.writeInt(this.nodeID);
/*    */ 
/* 81 */     out.writeUTF(this.queueName);
/*    */ 
/* 83 */     out.writeLong(this.messageID);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.ReplicateAckMessage
 * JD-Core Version:    0.6.0
 */