/*     */ package org.jboss.messaging.core.impl.postoffice;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.messaging.util.StreamUtils;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ 
/*     */ class SharedState
/*     */   implements Streamable
/*     */ {
/*     */   private List mappings;
/*     */   private Map replicatedData;
/*     */   private Map nodeIDAddressMap;
/*     */ 
/*     */   SharedState()
/*     */   {
/*     */   }
/*     */ 
/*     */   SharedState(List mappings, Map replicatedData, Map nodeIDAddressMap)
/*     */   {
/*  62 */     this.mappings = mappings;
/*     */ 
/*  64 */     this.replicatedData = replicatedData;
/*     */ 
/*  66 */     this.nodeIDAddressMap = nodeIDAddressMap;
/*     */   }
/*     */ 
/*     */   List getMappings()
/*     */   {
/*  71 */     return this.mappings;
/*     */   }
/*     */ 
/*     */   Map getReplicatedData()
/*     */   {
/*  76 */     return this.replicatedData;
/*     */   }
/*     */ 
/*     */   Map getNodeIDAddressMap()
/*     */   {
/*  81 */     return this.nodeIDAddressMap;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in) throws Exception
/*     */   {
/*  86 */     int size = in.readInt();
/*     */ 
/*  88 */     this.mappings = new ArrayList(size);
/*     */ 
/*  90 */     for (int i = 0; i < size; i++)
/*     */     {
/*  92 */       MappingInfo mapping = new MappingInfo();
/*     */ 
/*  94 */       mapping.read(in);
/*     */ 
/*  96 */       this.mappings.add(mapping);
/*     */     }
/*     */ 
/*  99 */     size = in.readInt();
/*     */ 
/* 101 */     this.replicatedData = new HashMap(size);
/*     */ 
/* 103 */     for (int i = 0; i < size; i++)
/*     */     {
/* 105 */       Serializable key = (Serializable)StreamUtils.readObject(in, true);
/*     */ 
/* 107 */       HashMap replicants = StreamUtils.readMap(in, false);
/*     */ 
/* 109 */       this.replicatedData.put(key, replicants);
/*     */     }
/*     */ 
/* 112 */     size = in.readInt();
/*     */ 
/* 114 */     this.nodeIDAddressMap = new HashMap(size);
/*     */ 
/* 116 */     for (int i = 0; i < size; i++)
/*     */     {
/* 118 */       int nodeID = in.readInt();
/*     */ 
/* 120 */       PostOfficeAddressInfo info = new PostOfficeAddressInfo();
/*     */ 
/* 122 */       info.read(in);
/*     */ 
/* 124 */       this.nodeIDAddressMap.put(new Integer(nodeID), info);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 130 */     out.writeInt(this.mappings.size());
/*     */ 
/* 132 */     Iterator iter = this.mappings.iterator();
/*     */ 
/* 134 */     while (iter.hasNext())
/*     */     {
/* 136 */       MappingInfo mapping = (MappingInfo)iter.next();
/*     */ 
/* 138 */       mapping.write(out);
/*     */     }
/*     */ 
/* 141 */     out.writeInt(this.replicatedData.size());
/*     */ 
/* 143 */     iter = this.replicatedData.entrySet().iterator();
/*     */ 
/* 145 */     while (iter.hasNext())
/*     */     {
/* 147 */       Map.Entry entry = (Map.Entry)iter.next();
/*     */ 
/* 149 */       Serializable key = (Serializable)entry.getKey();
/*     */ 
/* 151 */       StreamUtils.writeObject(out, key, true, true);
/*     */ 
/* 153 */       Map replicants = (Map)entry.getValue();
/*     */ 
/* 155 */       StreamUtils.writeMap(out, replicants, false);
/*     */     }
/*     */ 
/* 158 */     out.writeInt(this.nodeIDAddressMap.size());
/*     */ 
/* 160 */     iter = this.nodeIDAddressMap.entrySet().iterator();
/*     */ 
/* 162 */     while (iter.hasNext())
/*     */     {
/* 164 */       Map.Entry entry = (Map.Entry)iter.next();
/*     */ 
/* 166 */       Integer nodeID = (Integer)entry.getKey();
/*     */ 
/* 168 */       PostOfficeAddressInfo info = (PostOfficeAddressInfo)entry.getValue();
/*     */ 
/* 170 */       out.writeInt(nodeID.intValue());
/*     */ 
/* 172 */       info.write(out);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.SharedState
 * JD-Core Version:    0.6.0
 */