/*     */ package org.jboss.messaging.util;
/*     */ 
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.jms.exception.MessagingJMSException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ExceptionUtil
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(ExceptionUtil.class);
/*     */ 
/*     */   public static JMSException handleJMSInvocation(Throwable t, String msg)
/*     */   {
/*  61 */     String id = GUIDGenerator.generateGUID();
/*     */ 
/*  64 */     log.error(msg + " [" + id + "]", t);
/*     */ 
/*  66 */     if ((t instanceof JMSException))
/*     */     {
/*  68 */       return (JMSException)t;
/*     */     }
/*     */ 
/*  72 */     JMSException e = new MessagingJMSException("A failure has occurred during processing of the request. Please consult the server logs for more details. " + msg + " [" + id + "]");
/*     */ 
/*  74 */     return e;
/*     */   }
/*     */ 
/*     */   public static Exception handleJMXInvocation(Throwable t, String msg)
/*     */   {
/*  85 */     log.error(msg, t);
/*     */ 
/*  87 */     if ((t instanceof RuntimeException))
/*     */     {
/*  89 */       throw ((RuntimeException)t);
/*     */     }
/*  91 */     if ((t instanceof Error))
/*     */     {
/*  93 */       throw ((Error)t);
/*     */     }
/*  95 */     if ((t instanceof Exception))
/*     */     {
/*  98 */       return (Exception)t;
/*     */     }
/*     */ 
/* 103 */     throw new RuntimeException(msg);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.ExceptionUtil
 * JD-Core Version:    0.6.0
 */