/*     */ package org.jboss.messaging.util;
/*     */ 
/*     */ public class MessageQueueNameHelper
/*     */ {
/*     */   private String clientId;
/*     */   private String subName;
/*  47 */   private static char ESCAPE = '\\';
/*  48 */   private static char SEPARATOR_CHAR = '.';
/*  49 */   private static String SEPARATOR = ".";
/*     */ 
/*     */   private MessageQueueNameHelper(String messageQueueName)
/*     */   {
/*  53 */     if (messageQueueName == null)
/*     */     {
/*  55 */       throw new IllegalArgumentException("Message queue name is null");
/*     */     }
/*     */ 
/*  58 */     StringBuffer[] parts = new StringBuffer[2];
/*  59 */     int currentPart = 0;
/*     */ 
/*  61 */     parts[0] = new StringBuffer();
/*  62 */     parts[1] = new StringBuffer();
/*     */ 
/*  64 */     int pos = 0;
/*  65 */     while (pos < messageQueueName.length())
/*     */     {
/*  67 */       char ch = messageQueueName.charAt(pos);
/*  68 */       pos++;
/*     */ 
/*  70 */       if (ch == SEPARATOR_CHAR)
/*     */       {
/*  72 */         currentPart++;
/*  73 */         if (currentPart < parts.length)
/*     */           continue;
/*  75 */         throw new IllegalArgumentException("Invalid message queue name: " + messageQueueName);
/*     */       }
/*     */ 
/*  81 */       if (ch == ESCAPE)
/*     */       {
/*  83 */         if (pos >= messageQueueName.length())
/*     */         {
/*  85 */           throw new IllegalArgumentException("Invalid message queue name: " + messageQueueName);
/*     */         }
/*  87 */         ch = messageQueueName.charAt(pos);
/*  88 */         pos++;
/*     */       }
/*     */ 
/*  91 */       parts[currentPart].append(ch);
/*     */     }
/*     */ 
/*  94 */     if (currentPart != 1)
/*     */     {
/*  96 */       throw new IllegalArgumentException("Invalid message queue name: " + messageQueueName);
/*     */     }
/*     */ 
/*  99 */     this.clientId = parts[0].toString();
/* 100 */     this.subName = parts[1].toString();
/*     */   }
/*     */ 
/*     */   private static String escape(String input)
/*     */   {
/* 105 */     return input.replace("\\", "\\\\").replace(".", "\\.");
/*     */   }
/*     */ 
/*     */   public String getClientId()
/*     */   {
/* 110 */     return this.clientId;
/*     */   }
/*     */ 
/*     */   public String getSubName()
/*     */   {
/* 115 */     return this.subName;
/*     */   }
/*     */ 
/*     */   public static MessageQueueNameHelper createHelper(String messageQueueName)
/*     */   {
/* 120 */     return new MessageQueueNameHelper(messageQueueName);
/*     */   }
/*     */ 
/*     */   public static String createSubscriptionName(String clientID, String subName)
/*     */   {
/* 125 */     if (clientID == null)
/*     */     {
/* 127 */       throw new IllegalArgumentException("clientID name is null");
/*     */     }
/* 129 */     if (subName == null)
/*     */     {
/* 131 */       throw new IllegalArgumentException("Subscription name is null");
/*     */     }
/*     */ 
/* 134 */     return escape(clientID) + SEPARATOR + escape(subName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.MessageQueueNameHelper
 * JD-Core Version:    0.6.0
 */