/*     */ package org.jboss.messaging.util;
/*     */ 
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.Reader;
/*     */ import java.io.StringReader;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public class XMLUtil
/*     */ {
/*  37 */   private static final Logger log = Logger.getLogger(XMLUtil.class);
/*     */ 
/* 150 */   private static final Object[] EMPTY_ARRAY = new Object[0];
/*     */ 
/*     */   public static Element stringToElement(String s)
/*     */     throws Exception
/*     */   {
/*  43 */     return readerToElement(new StringReader(s));
/*     */   }
/*     */ 
/*     */   public static Element urlToElement(URL url) throws Exception
/*     */   {
/*  48 */     return readerToElement(new InputStreamReader(url.openStream()));
/*     */   }
/*     */ 
/*     */   public static Element readerToElement(Reader r)
/*     */     throws Exception
/*     */   {
/*  54 */     StringBuffer buff = new StringBuffer();
/*     */     int c;
/*  56 */     while ((c = r.read()) != -1)
/*     */     {
/*  58 */       buff.append((char)c);
/*     */     }
/*     */ 
/*  62 */     String s = buff.toString();
/*  63 */     s = doReplace(s, "jboss.messaging.groupname", "MessagingPostOffice");
/*  64 */     s = doReplace(s, "jboss.messaging.datachanneludpaddress", "228.6.6.6");
/*  65 */     s = doReplace(s, "jboss.messaging.controlchanneludpaddress", "228.7.7.7");
/*  66 */     s = doReplace(s, "jboss.messaging.datachanneludpport", "45567");
/*  67 */     s = doReplace(s, "jboss.messaging.controlchanneludpport", "45568");
/*     */ 
/*  69 */     StringReader sreader = new StringReader(s);
/*     */ 
/*  71 */     DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/*  72 */     DocumentBuilder parser = factory.newDocumentBuilder();
/*  73 */     Document doc = parser.parse(new InputSource(sreader));
/*  74 */     return doc.getDocumentElement();
/*     */   }
/*     */ 
/*     */   public static String elementToString(Node n)
/*     */   {
/*  80 */     String name = n.getNodeName();
/*     */ 
/*  82 */     short type = n.getNodeType();
/*     */ 
/*  84 */     if (4 == type)
/*     */     {
/*  86 */       return "<![CDATA[" + n.getNodeValue() + "]]>";
/*     */     }
/*     */ 
/*  89 */     if (name.startsWith("#"))
/*     */     {
/*  91 */       return "";
/*     */     }
/*     */ 
/*  94 */     StringBuffer sb = new StringBuffer();
/*  95 */     sb.append('<').append(name);
/*     */ 
/*  97 */     NamedNodeMap attrs = n.getAttributes();
/*  98 */     if (attrs != null)
/*     */     {
/* 100 */       for (int i = 0; i < attrs.getLength(); i++)
/*     */       {
/* 102 */         Node attr = attrs.item(i);
/* 103 */         sb.append(' ').append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 111 */     String textContent = null;
/* 112 */     NodeList children = n.getChildNodes();
/*     */ 
/* 114 */     if (children.getLength() == 0)
/*     */     {
/* 116 */       if (((textContent = getTextContent(n)) != null) && (!"".equals(textContent)))
/*     */       {
/* 118 */         sb.append(textContent).append("</").append(name).append('>');
/*     */       }
/*     */       else
/*     */       {
/* 122 */         sb.append("/>").append('\n');
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 127 */       sb.append('>').append('\n');
/* 128 */       boolean hasValidChildren = false;
/* 129 */       for (int i = 0; i < children.getLength(); i++)
/*     */       {
/* 131 */         String childToString = elementToString(children.item(i));
/* 132 */         if ("".equals(childToString))
/*     */           continue;
/* 134 */         sb.append(childToString);
/* 135 */         hasValidChildren = true;
/*     */       }
/*     */ 
/* 139 */       if ((!hasValidChildren) && ((textContent = getTextContent(n)) != null))
/*     */       {
/* 141 */         sb.append(textContent);
/*     */       }
/*     */ 
/* 144 */       sb.append("</").append(name).append('>');
/*     */     }
/*     */ 
/* 147 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public static String getTextContent(Node n)
/*     */   {
/* 163 */     if (n.hasChildNodes())
/*     */     {
/* 165 */       StringBuffer sb = new StringBuffer();
/* 166 */       NodeList nl = n.getChildNodes();
/* 167 */       for (int i = 0; i < nl.getLength(); i++)
/*     */       {
/* 169 */         sb.append(elementToString(nl.item(i)));
/* 170 */         if (i >= nl.getLength() - 1)
/*     */           continue;
/* 172 */         sb.append('\n');
/*     */       }
/*     */ 
/* 176 */       String s = sb.toString();
/* 177 */       if (s.length() != 0)
/*     */       {
/* 179 */         return s;
/*     */       }
/*     */     }
/*     */ 
/* 183 */     Method[] methods = Node.class.getMethods();
/*     */ 
/* 185 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 187 */       if (!"getTextContent".equals(methods[i].getName()))
/*     */         continue;
/* 189 */       Method getTextContext = methods[i];
/*     */       try
/*     */       {
/* 192 */         return (String)getTextContext.invoke(n, EMPTY_ARRAY);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 196 */         log.error("Failed to invoke getTextContent() on node " + n, e);
/* 197 */         return null;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 202 */     String textContent = null;
/*     */ 
/* 204 */     if (n.hasChildNodes())
/*     */     {
/* 206 */       NodeList nl = n.getChildNodes();
/* 207 */       for (int i = 0; i < nl.getLength(); i++)
/*     */       {
/* 209 */         Node c = nl.item(i);
/* 210 */         if (c.getNodeType() != 3)
/*     */           continue;
/* 212 */         textContent = n.getNodeValue();
/* 213 */         if (textContent == null)
/*     */         {
/* 216 */           String s = c.toString();
/* 217 */           int idx = s.indexOf("#text:");
/* 218 */           if (idx != -1)
/*     */           {
/* 220 */             textContent = s.substring(idx + 6).trim();
/* 221 */             if (textContent.endsWith("]"))
/*     */             {
/* 223 */               textContent = textContent.substring(0, textContent.length() - 1);
/*     */             }
/*     */           }
/*     */         }
/* 227 */         if (textContent == null)
/*     */         {
/*     */           break;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 235 */       String s = n.toString();
/* 236 */       int i = s.indexOf('>');
/* 237 */       int i2 = s.indexOf("</");
/* 238 */       if ((i != -1) && (i2 != -1))
/*     */       {
/* 240 */         textContent = s.substring(i + 1, i2);
/*     */       }
/*     */     }
/*     */ 
/* 244 */     return textContent;
/*     */   }
/*     */ 
/*     */   public static void assertEquivalent(Node node, Node node2)
/*     */   {
/* 249 */     if (node == null)
/*     */     {
/* 251 */       throw new IllegalArgumentException("the first node to be compared is null");
/*     */     }
/*     */ 
/* 254 */     if (node2 == null)
/*     */     {
/* 256 */       throw new IllegalArgumentException("the second node to be compared is null");
/*     */     }
/*     */ 
/* 259 */     if (!node.getNodeName().equals(node2.getNodeName()))
/*     */     {
/* 261 */       throw new IllegalArgumentException("nodes have different node names");
/*     */     }
/*     */ 
/* 264 */     int attrCount = 0;
/* 265 */     NamedNodeMap attrs = node.getAttributes();
/* 266 */     if (attrs != null)
/*     */     {
/* 268 */       attrCount = attrs.getLength();
/*     */     }
/*     */ 
/* 271 */     int attrCount2 = 0;
/* 272 */     NamedNodeMap attrs2 = node2.getAttributes();
/* 273 */     if (attrs2 != null)
/*     */     {
/* 275 */       attrCount2 = attrs2.getLength();
/*     */     }
/*     */ 
/* 278 */     if (attrCount != attrCount2)
/*     */     {
/* 280 */       throw new IllegalArgumentException("nodes hava a different number of attributes");
/*     */     }
/*     */ 
/* 283 */     for (int i = 0; i < attrCount; i++)
/*     */     {
/* 285 */       Node n = attrs.item(i);
/* 286 */       String name = n.getNodeName();
/* 287 */       String value = n.getNodeValue();
/*     */ 
/* 289 */       int j = 0;
/*     */       while (true) if (j < attrCount)
/*     */         {
/* 291 */           Node n2 = attrs2.item(j);
/* 292 */           String name2 = n2.getNodeName();
/* 293 */           String value2 = n2.getNodeValue();
/*     */ 
/* 295 */           if ((name.equals(name2)) && (value.equals(value2)))
/*     */             break;
/* 289 */           j++; continue;
/*     */         }
/*     */         else
/*     */         {
/* 300 */           throw new IllegalArgumentException("attribute " + name + "=" + value + " doesn't match");
/*     */         }
/*     */     }
/* 303 */     boolean hasChildren = node.hasChildNodes();
/*     */ 
/* 305 */     if (hasChildren != node2.hasChildNodes())
/*     */     {
/* 307 */       throw new IllegalArgumentException("one node has children and the other doesn't");
/*     */     }
/*     */ 
/* 310 */     if (hasChildren)
/*     */     {
/* 312 */       NodeList nl = node.getChildNodes();
/* 313 */       NodeList nl2 = node2.getChildNodes();
/*     */ 
/* 315 */       short[] toFilter = { 3, 2, 8 };
/* 316 */       List nodes = filter(nl, toFilter);
/* 317 */       List nodes2 = filter(nl2, toFilter);
/*     */ 
/* 319 */       int length = nodes.size();
/*     */ 
/* 321 */       if (length != nodes2.size())
/*     */       {
/* 323 */         throw new IllegalArgumentException("nodes hava a different number of children");
/*     */       }
/*     */ 
/* 326 */       for (int i = 0; i < length; i++)
/*     */       {
/* 328 */         Node n = (Node)nodes.get(i);
/* 329 */         Node n2 = (Node)nodes2.get(i);
/* 330 */         assertEquivalent(n, n2);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String stripCDATA(String s)
/*     */   {
/* 337 */     s = s.trim();
/* 338 */     if (s.startsWith("<![CDATA["))
/*     */     {
/* 340 */       s = s.substring(9);
/* 341 */       int i = s.indexOf("]]>");
/* 342 */       if (i == -1)
/*     */       {
/* 344 */         throw new IllegalStateException("argument starts with <![CDATA[ but cannot find pairing ]]>");
/*     */       }
/*     */ 
/* 347 */       s = s.substring(0, i);
/*     */     }
/* 349 */     return s;
/*     */   }
/*     */ 
/*     */   private static List filter(NodeList nl, short[] typesToFilter)
/*     */   {
/* 366 */     List nodes = new ArrayList();
/*     */ 
/* 368 */     for (int i = 0; i < nl.getLength(); i++)
/*     */     {
/* 370 */       Node n = nl.item(i);
/* 371 */       short type = n.getNodeType();
/* 372 */       int j = 0;
/*     */       while (true) if (j < typesToFilter.length)
/*     */         {
/* 374 */           if (typesToFilter[j] == type)
/*     */             break;
/* 372 */           j++; continue;
/*     */         }
/*     */         else
/*     */         {
/* 379 */           nodes.add(n);
/*     */         } 
/*     */     }
/* 381 */     return nodes;
/*     */   }
/*     */ 
/*     */   private static String doReplace(String s, String propertyName, String defaultValue)
/*     */   {
/* 387 */     String sysProp = System.getProperty(propertyName);
/*     */ 
/* 389 */     s = s.replace("${" + propertyName + ":" + defaultValue + "}", sysProp == null ? defaultValue : sysProp);
/*     */ 
/* 391 */     return s;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.XMLUtil
 * JD-Core Version:    0.6.0
 */