/*     */ package org.jboss.metadata;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public abstract class MetaData
/*     */   implements Cloneable, XmlLoadable
/*     */ {
/*  43 */   protected static Logger log = Logger.getLogger(MetaData.class);
/*     */   public static final byte TX_NOT_SUPPORTED = 0;
/*     */   public static final byte TX_REQUIRED = 1;
/*     */   public static final byte TX_SUPPORTS = 2;
/*     */   public static final byte TX_REQUIRES_NEW = 3;
/*     */   public static final byte TX_MANDATORY = 4;
/*     */   public static final byte TX_NEVER = 5;
/*     */   public static final byte TX_UNKNOWN = 6;
/*     */ 
/*     */   public static Iterator getChildrenByTagName(Element element, String tagName)
/*     */   {
/*  69 */     if (element == null) {
/*  70 */       return null;
/*     */     }
/*     */ 
/*  74 */     NodeList children = element.getChildNodes();
/*  75 */     ArrayList goodChildren = new ArrayList();
/*  76 */     for (int i = 0; i < children.getLength(); i++)
/*     */     {
/*  78 */       Node currentChild = children.item(i);
/*  79 */       if ((currentChild.getNodeType() != 1) || (!((Element)currentChild).getTagName().equals(tagName)))
/*     */         continue;
/*  81 */       goodChildren.add(currentChild);
/*     */     }
/*     */ 
/*  84 */     return goodChildren.iterator();
/*     */   }
/*     */ 
/*     */   public static Element getUniqueChild(Element element, String tagName)
/*     */   {
/* 100 */     Iterator goodChildren = getChildrenByTagName(element, tagName);
/*     */ 
/* 102 */     if ((goodChildren != null) && (goodChildren.hasNext()))
/*     */     {
/* 104 */       Element child = (Element)goodChildren.next();
/* 105 */       if (goodChildren.hasNext())
/*     */       {
/* 107 */         throw new IllegalStateException("expected only one " + tagName + " tag");
/*     */       }
/* 109 */       return child;
/*     */     }
/*     */ 
/* 113 */     throw new IllegalStateException("expected one " + tagName + " tag");
/*     */   }
/*     */ 
/*     */   public static Element getOptionalChild(Element element, String tagName)
/*     */   {
/* 128 */     return getOptionalChild(element, tagName, null);
/*     */   }
/*     */ 
/*     */   public static Element getOptionalChild(Element element, String tagName, Element defaultElement)
/*     */   {
/* 144 */     Iterator goodChildren = getChildrenByTagName(element, tagName);
/*     */ 
/* 146 */     if ((goodChildren != null) && (goodChildren.hasNext()))
/*     */     {
/* 148 */       Element child = (Element)goodChildren.next();
/* 149 */       if (goodChildren.hasNext())
/*     */       {
/* 151 */         throw new IllegalStateException("expected only one " + tagName + " tag");
/*     */       }
/* 153 */       return child;
/*     */     }
/*     */ 
/* 157 */     return defaultElement;
/*     */   }
/*     */ 
/*     */   public static String getElementAttribute(Element element, String attrName)
/*     */   {
/* 170 */     return getElementAttribute(element, attrName, true);
/*     */   }
/*     */ 
/*     */   public static String getElementAttribute(Element element, String attrName, boolean replace)
/*     */   {
/* 183 */     if (element == null) {
/* 184 */       return null;
/*     */     }
/* 186 */     if ((attrName == null) || (!element.hasAttribute(attrName))) {
/* 187 */       return null;
/*     */     }
/* 189 */     String result = element.getAttribute(attrName);
/* 190 */     if (replace)
/* 191 */       return StringPropertyReplacer.replaceProperties(result.trim());
/* 192 */     return result.trim();
/*     */   }
/*     */ 
/*     */   public static String getElementContent(Element element)
/*     */   {
/* 203 */     return getElementContent(element, null);
/*     */   }
/*     */ 
/*     */   public static String getElementContent(Element element, String defaultStr)
/*     */   {
/* 215 */     return getElementContent(element, defaultStr, true);
/*     */   }
/*     */ 
/*     */   public static String getElementContent(Element element, String defaultStr, boolean replace)
/*     */   {
/* 228 */     if (element == null) {
/* 229 */       return defaultStr;
/*     */     }
/* 231 */     NodeList children = element.getChildNodes();
/* 232 */     String result = "";
/* 233 */     for (int i = 0; i < children.getLength(); i++)
/*     */     {
/* 235 */       if ((children.item(i).getNodeType() == 3) || (children.item(i).getNodeType() == 4))
/*     */       {
/* 237 */         result = result + children.item(i).getNodeValue();
/*     */       } else {
/* 239 */         if (children.item(i).getNodeType() == 8)
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 245 */         result = result + children.item(i).getFirstChild();
/*     */       }
/*     */     }
/* 248 */     if (replace)
/* 249 */       return StringPropertyReplacer.replaceProperties(result.trim());
/* 250 */     return result.trim();
/*     */   }
/*     */ 
/*     */   public static String getFirstElementContent(Element element, String defaultStr)
/*     */   {
/* 255 */     return getFirstElementContent(element, defaultStr, true);
/*     */   }
/*     */ 
/*     */   public static String getFirstElementContent(Element element, String defaultStr, boolean replace)
/*     */   {
/* 260 */     if (element == null) {
/* 261 */       return defaultStr;
/*     */     }
/* 263 */     NodeList children = element.getChildNodes();
/* 264 */     String result = "";
/* 265 */     for (int i = 0; i < children.getLength(); i++)
/*     */     {
/* 267 */       if ((children.item(i).getNodeType() == 3) || (children.item(i).getNodeType() == 4))
/*     */       {
/* 269 */         String val = children.item(i).getNodeValue();
/* 270 */         result = result + val;
/*     */       } else {
/* 272 */         if (children.item(i).getNodeType() != 8)
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 283 */     if (replace)
/* 284 */       return StringPropertyReplacer.replaceProperties(result.trim());
/* 285 */     return result.trim();
/*     */   }
/*     */ 
/*     */   public static String getUniqueChildContent(Element element, String tagName)
/*     */   {
/* 297 */     return getElementContent(getUniqueChild(element, tagName));
/*     */   }
/*     */ 
/*     */   public static String getOptionalChildContent(Element element, String tagName)
/*     */   {
/* 309 */     return getElementContent(getOptionalChild(element, tagName));
/*     */   }
/*     */ 
/*     */   public static String getOptionalChildContent(Element element, String tagName, String defaultValue)
/*     */   {
/* 321 */     return getElementContent(getOptionalChild(element, tagName), defaultValue);
/*     */   }
/*     */ 
/*     */   public static boolean getOptionalChildBooleanContent(Element element, String name)
/*     */   {
/* 326 */     Element child = getOptionalChild(element, name);
/* 327 */     if (child != null)
/*     */     {
/* 329 */       String value = getElementContent(child).toLowerCase();
/* 330 */       return (value.equalsIgnoreCase("true")) || (value.equalsIgnoreCase("yes"));
/*     */     }
/*     */ 
/* 333 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean getOptionalChildBooleanContent(Element element, String name, boolean defaultValue)
/*     */   {
/* 338 */     Element child = getOptionalChild(element, name);
/* 339 */     boolean flag = defaultValue;
/* 340 */     if (child != null)
/*     */     {
/* 342 */       String value = getElementContent(child).toLowerCase();
/* 343 */       flag = (value.equalsIgnoreCase("true")) || (value.equalsIgnoreCase("yes"));
/*     */     }
/*     */ 
/* 346 */     return flag;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 357 */     Object clone = null;
/*     */     try
/*     */     {
/* 360 */       clone = super.clone();
/*     */     }
/*     */     catch (CloneNotSupportedException ignore)
/*     */     {
/*     */     }
/* 365 */     return clone;
/*     */   }
/*     */ 
/*     */   public void importXml(Element element)
/*     */     throws Exception
/*     */   {
/* 374 */     String rootTag = element.getOwnerDocument().getDocumentElement().getTagName();
/*     */ 
/* 376 */     if (rootTag.equals("jboss"))
/*     */     {
/* 379 */       importJbossXml(element);
/*     */     }
/* 381 */     else if (rootTag.equals("ejb-jar"))
/*     */     {
/* 384 */       importEjbJarXml(element);
/*     */     }
/*     */     else
/*     */     {
/* 388 */       throw new IllegalStateException("Unrecognized root tag : " + rootTag);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void importEjbJarXml(Element element)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void importJbossXml(Element element)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected boolean jdk13Enabled()
/*     */   {
/* 420 */     String javaVersion = System.getProperty("java.vm.version");
/* 421 */     return javaVersion.compareTo("1.3") >= 0;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.MetaData
 * JD-Core Version:    0.6.0
 */