/*    */ package org.jboss.metadata.annotation.creator;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.annotation.PreDestroy;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
/*    */ import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
/*    */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*    */ 
/*    */ public class PreDestroyMethodProcessor extends AbstractLifeCycleMethodProcessor
/*    */   implements Processor<EnvironmentRefsGroupMetaData, Method>
/*    */ {
/*    */   public PreDestroyMethodProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 50 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(EnvironmentRefsGroupMetaData metaData, Method element)
/*    */   {
/* 55 */     PreDestroy annotation = (PreDestroy)this.finder.getAnnotation(element, PreDestroy.class);
/* 56 */     if (annotation == null) {
/* 57 */       return;
/*    */     }
/* 59 */     LifecycleCallbackMetaData callback = super.create(element);
/* 60 */     LifecycleCallbacksMetaData preDestroys = metaData.getPreDestroys();
/* 61 */     if (preDestroys == null)
/*    */     {
/* 63 */       preDestroys = new LifecycleCallbacksMetaData();
/* 64 */       metaData.setPreDestroys(preDestroys);
/*    */     }
/* 66 */     preDestroys.add(callback);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.PreDestroyMethodProcessor
 * JD-Core Version:    0.6.0
 */