/*     */ package org.jboss.metadata.annotation.creator.ejb;
/*     */ 
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import org.jboss.metadata.annotation.creator.AbstractComponentProcessor;
/*     */ import org.jboss.metadata.annotation.creator.DeclareRolesProcessor;
/*     */ import org.jboss.metadata.annotation.creator.Processor;
/*     */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*     */ import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
/*     */ import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
/*     */ import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*     */ 
/*     */ public abstract class AbstractEnterpriseBeanProcessor<MD extends EnterpriseBeanMetaData> extends AbstractComponentProcessor<MD>
/*     */   implements Processor<EjbJar3xMetaData, Class<?>>
/*     */ {
/*     */   protected abstract MD create(Class<?> paramClass);
/*     */ 
/*     */   protected AbstractEnterpriseBeanProcessor(AnnotationFinder<AnnotatedElement> finder)
/*     */   {
/*  58 */     super(finder);
/*     */ 
/*  60 */     addTypeProcessor(new TransactionAttributeClassProcessor(finder));
/*  61 */     addMethodProcessor(new TransactionAttributeMethodProcessor(finder));
/*     */ 
/*  63 */     addTypeProcessor(new RunAsProcessor(finder));
/*     */ 
/*  65 */     addTypeProcessor(new DeclareRolesProcessor(finder));
/*     */ 
/*  67 */     addMethodProcessor(new DenyAllProcessor(finder));
/*     */ 
/*  69 */     addTypeProcessor(new RolesAllowedProcessor(finder));
/*  70 */     addMethodProcessor(new RolesAllowedProcessor(finder));
/*     */ 
/*  72 */     addTypeProcessor(new PermitAllProcessor(finder));
/*  73 */     addMethodProcessor(new PermitAllProcessor(finder));
/*     */ 
/*  75 */     addTypeProcessor(new InterceptorsProcessor(finder));
/*  76 */     addMethodProcessor(new InterceptorsProcessor(finder));
/*     */   }
/*     */ 
/*     */   public void process(EjbJar3xMetaData ejbJarMetaData, Class<?> beanClass)
/*     */   {
/*  84 */     EnterpriseBeanMetaData beanMetaData = create(beanClass);
/*  85 */     if (beanMetaData == null) {
/*  86 */       return;
/*     */     }
/*  88 */     EjbNameThreadLocal.ejbName.set(beanMetaData.getEjbName());
/*     */ 
/*  90 */     EnvironmentRefsGroupMetaData env = new EnvironmentRefsGroupMetaData();
/*  91 */     super.process(env, beanClass);
/*  92 */     beanMetaData.setJndiEnvironmentRefsGroup(env);
/*     */ 
/*  94 */     if (ejbJarMetaData.getEnterpriseBeans() == null) {
/*  95 */       ejbJarMetaData.setEnterpriseBeans(new EnterpriseBeansMetaData());
/*     */     }
/*  97 */     ejbJarMetaData.getEnterpriseBeans().add(beanMetaData);
/*  98 */     processClass(beanMetaData, beanClass);
/*     */ 
/* 100 */     AssemblyDescriptorMetaData assembly = ejbJarMetaData.getAssemblyDescriptor();
/* 101 */     if (assembly == null)
/*     */     {
/* 103 */       assembly = new AssemblyDescriptorMetaData();
/* 104 */       ejbJarMetaData.setAssemblyDescriptor(assembly);
/*     */     }
/*     */ 
/* 107 */     SecurityRolesMetaData securityRoles = assembly.getSecurityRoles();
/* 108 */     if (securityRoles == null)
/*     */     {
/* 110 */       securityRoles = new SecurityRolesMetaData();
/* 111 */       assembly.setSecurityRoles(securityRoles);
/*     */     }
/* 113 */     super.processClass(securityRoles, beanClass);
/*     */ 
/* 115 */     ExcludeListMetaData excludes = assembly.getExcludeList();
/* 116 */     if (excludes == null)
/*     */     {
/* 118 */       excludes = new ExcludeListMetaData();
/* 119 */       assembly.setExcludeList(excludes);
/*     */     }
/* 121 */     super.processClass(excludes, beanClass);
/*     */ 
/* 124 */     MethodPermissionsMetaData permissions = assembly.getMethodPermissions();
/* 125 */     if (permissions == null)
/*     */     {
/* 127 */       permissions = new MethodPermissionsMetaData();
/* 128 */       assembly.setMethodPermissions(permissions);
/*     */     }
/* 130 */     super.processClass(permissions, beanClass);
/*     */ 
/* 133 */     InterceptorBindingsMetaData interceptors = assembly.getInterceptorBindings();
/* 134 */     if (interceptors == null)
/*     */     {
/* 136 */       interceptors = new InterceptorBindingsMetaData();
/* 137 */       assembly.setInterceptorBindings(interceptors);
/*     */     }
/* 139 */     super.processClass(interceptors, beanClass);
/*     */ 
/* 141 */     EjbNameThreadLocal.ejbName.set(null);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.AbstractEnterpriseBeanProcessor
 * JD-Core Version:    0.6.0
 */