/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.ejb.TransactionAttribute;
/*    */ import javax.ejb.TransactionAttributeType;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.ProcessorUtils;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.common.ejb.IAssemblyDescriptorMetaData;
/*    */ import org.jboss.metadata.common.ejb.IEjbJarMetaData;
/*    */ import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
/*    */ import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
/*    */ import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
/*    */ import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MethodsMetaData;
/*    */ 
/*    */ public abstract class AbstractTransactionAttributeProcessor<E extends AnnotatedElement, T extends EnterpriseBeanMetaData> extends AbstractFinderUser
/*    */ {
/*    */   protected AbstractTransactionAttributeProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 50 */     super(finder);
/*    */   }
/*    */ 
/*    */   protected abstract ContainerTransactionMetaData createContainerTransaction(String paramString, TransactionAttribute paramTransactionAttribute, E paramE);
/*    */ 
/*    */   protected MethodsMetaData createMethods(String ejbName, Method method) {
/* 57 */     MethodsMetaData methods = new MethodsMetaData();
/* 58 */     methods.add(ProcessorUtils.createMethod(ejbName, method));
/* 59 */     return methods;
/*    */   }
/*    */ 
/*    */   protected TransactionAttributeType createTransAttributeType(TransactionAttribute annotation)
/*    */   {
/* 64 */     return annotation.value();
/*    */   }
/*    */ 
/*    */   public void process(T bean, E element)
/*    */   {
/* 69 */     TransactionAttribute annotation = (TransactionAttribute)this.finder.getAnnotation(element, TransactionAttribute.class);
/* 70 */     if (annotation == null) {
/* 71 */       return;
/*    */     }
/* 73 */     IEjbJarMetaData ejbJarMetaData = bean.getEjbJarMetaData();
/*    */ 
/* 75 */     if (ejbJarMetaData.getAssemblyDescriptor() == null)
/* 76 */       ejbJarMetaData.setAssemblyDescriptor(new AssemblyDescriptorMetaData());
/* 77 */     if (ejbJarMetaData.getAssemblyDescriptor().getContainerTransactions() == null) {
/* 78 */       ejbJarMetaData.getAssemblyDescriptor().setContainerTransactions(new ContainerTransactionsMetaData());
/*    */     }
/* 80 */     ContainerTransactionMetaData transaction = createContainerTransaction(bean.getEjbName(), annotation, element);
/* 81 */     ejbJarMetaData.getAssemblyDescriptor().getContainerTransactions().add(transaction);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.AbstractTransactionAttributeProcessor
 * JD-Core Version:    0.6.0
 */