/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.persistence.Entity;
/*    */ import org.jboss.metadata.annotation.creator.Creator;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
/*    */ import org.jboss.metadata.ejb.spec.EntityBeanMetaData;
/*    */ 
/*    */ public class EntityProcessor extends AbstractEnterpriseBeanProcessor<EntityBeanMetaData>
/*    */   implements Creator<Class<?>, EntityBeanMetaData>, Processor<EjbJar3xMetaData, Class<?>>
/*    */ {
/*    */   public EntityProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 49 */     super(finder);
/*    */   }
/*    */ 
/*    */   public EntityBeanMetaData create(Class<?> beanClass)
/*    */   {
/* 55 */     Entity annotation = (Entity)this.finder.getAnnotation(beanClass, Entity.class);
/* 56 */     if (annotation == null) {
/* 57 */       return null;
/*    */     }
/* 59 */     EntityBeanMetaData metaData = new EntityBeanMetaData();
/* 60 */     if (annotation.name().length() > 0)
/* 61 */       metaData.setEjbName(annotation.name());
/*    */     else
/* 63 */       metaData.setEjbName(beanClass.getSimpleName());
/* 64 */     metaData.setEjbClass(beanClass.getName());
/* 65 */     return metaData;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.EntityProcessor
 * JD-Core Version:    0.6.0
 */