/*     */ package org.jboss.metadata.annotation.creator.ejb;
/*     */ 
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.ejb.Init;
/*     */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*     */ import org.jboss.metadata.annotation.creator.Creator;
/*     */ import org.jboss.metadata.annotation.creator.Processor;
/*     */ import org.jboss.metadata.annotation.creator.ProcessorUtils;
/*     */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*     */ import org.jboss.metadata.ejb.spec.InitMethodMetaData;
/*     */ import org.jboss.metadata.ejb.spec.InitMethodsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
/*     */ import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SessionType;
/*     */ 
/*     */ public class InitProcessor extends AbstractFinderUser
/*     */   implements Creator<Method, InitMethodMetaData>, Processor<SessionBeanMetaData, Method>
/*     */ {
/*     */   public InitProcessor(AnnotationFinder<AnnotatedElement> finder)
/*     */   {
/*  52 */     super(finder);
/*     */   }
/*     */ 
/*     */   public InitMethodMetaData create(Method method)
/*     */   {
/*  57 */     Init init = (Init)this.finder.getAnnotation(method, Init.class);
/*  58 */     if (init == null) {
/*  59 */       return null;
/*     */     }
/*  61 */     InitMethodMetaData metaData = new InitMethodMetaData();
/*  62 */     NamedMethodMetaData beanMethod = new NamedMethodMetaData();
/*  63 */     metaData.setBeanMethod(beanMethod);
/*  64 */     NamedMethodMetaData createMethod = new NamedMethodMetaData();
/*  65 */     metaData.setCreateMethod(createMethod);
/*     */ 
/*  67 */     String alternativeName = init.value().length() > 0 ? init.value() : method.getName();
/*     */ 
/*  70 */     if (method.getDeclaringClass().isInterface())
/*     */     {
/*  72 */       beanMethod.setMethodName(alternativeName);
/*  73 */       createMethod.setMethodName(method.getName());
/*     */     }
/*     */     else
/*     */     {
/*  77 */       beanMethod.setMethodName(method.getName());
/*  78 */       createMethod.setMethodName(alternativeName);
/*     */     }
/*     */ 
/*  81 */     MethodParametersMetaData methodParams = ProcessorUtils.getMethodParameters(method);
/*  82 */     beanMethod.setMethodParams(methodParams);
/*  83 */     createMethod.setMethodParams(methodParams);
/*     */ 
/*  85 */     return metaData;
/*     */   }
/*     */ 
/*     */   public void process(SessionBeanMetaData bean, Method method)
/*     */   {
/*  90 */     InitMethodMetaData initMethod = create(method);
/*  91 */     if (initMethod == null) {
/*  92 */       return;
/*     */     }
/*  94 */     if (bean.getSessionType() != SessionType.Stateful) {
/*  95 */       throw new IllegalArgumentException("Init annotation is only valid on a stateful bean");
/*     */     }
/*  97 */     if (bean.getInitMethods() == null) {
/*  98 */       bean.setInitMethods(new InitMethodsMetaData());
/*     */     }
/* 100 */     bean.getInitMethods().add(initMethod);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.InitProcessor
 * JD-Core Version:    0.6.0
 */