/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.ejb.ActivationConfigProperty;
/*    */ import javax.ejb.MessageDriven;
/*    */ import org.jboss.metadata.annotation.creator.ProcessorUtils;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
/*    */ import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
/*    */ import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
/*    */ import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
/*    */ import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
/*    */ 
/*    */ public class MessageDrivenProcessor extends AbstractEnterpriseBeanProcessor<MessageDrivenBeanMetaData>
/*    */ {
/*    */   public MessageDrivenProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 47 */     super(finder);
/* 48 */     addMethodProcessor(new TimeoutProcessor(finder));
/*    */   }
/*    */ 
/*    */   protected MessageDrivenBeanMetaData create(Class<?> beanClass)
/*    */   {
/* 54 */     MessageDriven annotation = (MessageDriven)this.finder.getAnnotation(beanClass, MessageDriven.class);
/* 55 */     if (annotation == null) {
/* 56 */       return null;
/*    */     }
/* 58 */     MessageDrivenBeanMetaData metaData = new MessageDrivenBeanMetaData();
/* 59 */     metaData.setEjbClass(beanClass.getName());
/* 60 */     if (annotation.name().length() > 0)
/* 61 */       metaData.setEjbName(annotation.name());
/*    */     else
/* 63 */       metaData.setEjbName(beanClass.getSimpleName());
/* 64 */     if (annotation.description().length() > 0)
/*    */     {
/* 66 */       DescriptionGroupMetaData dg = ProcessorUtils.getDescriptionGroup(annotation.description());
/* 67 */       metaData.setDescriptionGroup(dg);
/*    */     }
/* 69 */     if (annotation.mappedName().length() > 0)
/* 70 */       metaData.setMappedName(annotation.mappedName());
/* 71 */     if (annotation.messageListenerInterface() != Object.class)
/* 72 */       metaData.setMessagingType(annotation.messageListenerInterface().getName());
/* 73 */     ActivationConfigProperty[] props = annotation.activationConfig();
/* 74 */     ActivationConfigMetaData config = new ActivationConfigMetaData();
/* 75 */     ActivationConfigPropertiesMetaData configProps = new ActivationConfigPropertiesMetaData();
/* 76 */     config.setActivationConfigProperties(configProps);
/* 77 */     for (ActivationConfigProperty prop : props)
/*    */     {
/* 79 */       ActivationConfigPropertyMetaData acp = new ActivationConfigPropertyMetaData();
/* 80 */       acp.setActivationConfigPropertyName(prop.propertyName());
/* 81 */       acp.setValue(prop.propertyValue());
/* 82 */       configProps.add(acp);
/*    */     }
/* 84 */     metaData.setActivationConfig(config);
/* 85 */     return metaData;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.MessageDrivenProcessor
 * JD-Core Version:    0.6.0
 */