/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.annotation.security.RunAs;
/*    */ import org.jboss.metadata.annotation.creator.AbstractRunAsProcessor;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
/*    */ import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
/*    */ import org.jboss.metadata.javaee.spec.RunAsMetaData;
/*    */ 
/*    */ public class RunAsProcessor extends AbstractRunAsProcessor
/*    */   implements Processor<EnterpriseBeanMetaData, Class>
/*    */ {
/*    */   public RunAsProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 48 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(EnterpriseBeanMetaData metaData, Class type)
/*    */   {
/* 53 */     RunAs annotation = (RunAs)this.finder.getAnnotation(type, RunAs.class);
/* 54 */     if (annotation == null) {
/* 55 */       return;
/*    */     }
/* 57 */     RunAsMetaData runAs = super.create(type);
/* 58 */     SecurityIdentityMetaData identity = metaData.getSecurityIdentity();
/* 59 */     if (identity == null)
/*    */     {
/* 61 */       identity = new SecurityIdentityMetaData();
/* 62 */       metaData.setSecurityIdentity(identity);
/*    */     }
/* 64 */     identity.setRunAs(runAs);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.RunAsProcessor
 * JD-Core Version:    0.6.0
 */