/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.ejb.Stateful;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*    */ import org.jboss.metadata.ejb.spec.SessionType;
/*    */ 
/*    */ public class StatefulProcessor extends AbstractSessionBeanProcessor
/*    */ {
/*    */   public StatefulProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 43 */     super(finder);
/* 44 */     addMethodProcessor(new RemoveProcessor(finder));
/* 45 */     addMethodProcessor(new PostActivateMethodProcessor(finder));
/* 46 */     addMethodProcessor(new PrePassivateMethodProcessor(finder));
/*    */   }
/*    */ 
/*    */   public SessionBeanMetaData create(Class<?> beanClass)
/*    */   {
/* 51 */     Stateful annotation = (Stateful)this.finder.getAnnotation(beanClass, Stateful.class);
/* 52 */     if (annotation == null) {
/* 53 */       return null;
/*    */     }
/* 55 */     SessionBeanMetaData beanMetaData = create(beanClass, annotation);
/* 56 */     beanMetaData.setSessionType(SessionType.Stateful);
/* 57 */     return beanMetaData;
/*    */   }
/*    */ 
/*    */   protected SessionBeanMetaData create(Class<?> beanClass, Stateful annotation)
/*    */   {
/* 62 */     return create(beanClass, annotation.name(), annotation.mappedName(), annotation.description());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.StatefulProcessor
 * JD-Core Version:    0.6.0
 */