/*    */ package org.jboss.metadata.annotation.creator.web;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.annotation.security.RunAs;
/*    */ import org.jboss.metadata.annotation.creator.AbstractRunAsProcessor;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.javaee.spec.RunAsMetaData;
/*    */ import org.jboss.metadata.web.spec.ServletMetaData;
/*    */ import org.jboss.metadata.web.spec.ServletsMetaData;
/*    */ 
/*    */ public class RunAsProcessor extends AbstractRunAsProcessor
/*    */   implements Processor<ServletsMetaData, Class>
/*    */ {
/*    */   public RunAsProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 48 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(ServletsMetaData metaData, Class type)
/*    */   {
/* 53 */     RunAs annotation = (RunAs)this.finder.getAnnotation(type, RunAs.class);
/* 54 */     if (annotation == null) {
/* 55 */       return;
/*    */     }
/* 57 */     RunAsMetaData runAs = super.create(type);
/* 58 */     ServletMetaData servlet = new ServletMetaData();
/* 59 */     servlet.setServletName(type.getSimpleName());
/* 60 */     servlet.setServletClass(type.getName());
/* 61 */     servlet.setRunAs(runAs);
/* 62 */     metaData.add(servlet);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.web.RunAsProcessor
 * JD-Core Version:    0.6.0
 */