/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.bind.annotation.XmlAttribute;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.common.ejb.IEjbJarMetaData;
/*     */ import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EjbJarMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
/*     */ import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.RelationsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
/*     */ import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RunAsMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;
/*     */ 
/*     */ public class JBossMetaData extends IdMetaDataImplWithDescriptionGroup
/*     */   implements IEjbJarMetaData<JBossAssemblyDescriptorMetaData, JBossEnterpriseBeansMetaData, JBossEnterpriseBeanMetaData, JBossMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = 598759931857080298L;
/*  59 */   private static final Logger log = Logger.getLogger(JBossMetaData.class);
/*     */   private String dtdPublicId;
/*     */   private String dtdSystemId;
/*     */   private String version;
/*     */   private String ejbVersion;
/*     */   private String ejbClientJar;
/*     */   private RelationsMetaData relationships;
/*     */   private LoaderRepositoryMetaData loaderRepository;
/*     */   private String jmxName;
/*     */   private String securityDomain;
/*     */   private String jaccContextID;
/*  88 */   private boolean excludeMissingMethods = true;
/*     */   private String unauthenticatedPrincipal;
/*     */   private boolean exceptionOnRollback;
/*     */   private WebservicesMetaData webservices;
/*     */   private JBossEnterpriseBeansMetaData enterpriseBeans;
/*     */   private JBossAssemblyDescriptorMetaData assemblyDescriptor;
/*     */   private ResourceManagersMetaData resourceManagers;
/*     */   private InvokerProxyBindingsMetaData invokerProxyBindings;
/*     */   private ContainerConfigurationsMetaData containerConfigurations;
/*     */   private InterceptorsMetaData interceptors;
/* 117 */   private Map<String, RunAsIdentityMetaData> runAsIdentity = new HashMap();
/*     */   private boolean metadataComplete;
/*     */ 
/*     */   @XmlTransient
/*     */   public void setDTD(String root, String publicId, String systemId)
/*     */   {
/* 138 */     this.dtdPublicId = publicId;
/* 139 */     this.dtdSystemId = systemId;
/*     */ 
/* 141 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("3.0")))
/* 142 */       setVersion("3.0");
/* 143 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("3.2")))
/* 144 */       setVersion("3.2");
/* 145 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("4.0")))
/* 146 */       setVersion("4.0");
/* 147 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("4.2")))
/* 148 */       setVersion("4.2");
/* 149 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("5.0")))
/* 150 */       setVersion("5.0");
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdPublicId()
/*     */   {
/* 159 */     return this.dtdPublicId;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdSystemId()
/*     */   {
/* 168 */     return this.dtdSystemId;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public InterceptorsMetaData getInterceptors() {
/* 174 */     return this.interceptors;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 184 */     return this.version;
/*     */   }
/*     */ 
/*     */   @XmlAttribute
/*     */   public void setVersion(String version)
/*     */   {
/* 196 */     if (version == null)
/* 197 */       throw new IllegalArgumentException("Null version");
/* 198 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public JBossAssemblyDescriptorMetaData getAssemblyDescriptor()
/*     */   {
/* 203 */     return this.assemblyDescriptor;
/*     */   }
/*     */ 
/*     */   public String getEjbClientJar()
/*     */   {
/* 208 */     return this.ejbClientJar;
/*     */   }
/*     */ 
/*     */   public void setEjbClientJar(String ejbClientJar) {
/* 212 */     this.ejbClientJar = ejbClientJar;
/*     */   }
/*     */ 
/*     */   public RelationsMetaData getRelationships()
/*     */   {
/* 217 */     return this.relationships;
/*     */   }
/*     */ 
/*     */   public void setRelationships(RelationsMetaData relationships) {
/* 221 */     this.relationships = relationships;
/*     */   }
/*     */ 
/*     */   public boolean isEJB1x()
/*     */   {
/* 226 */     return (this.ejbVersion != null) && (this.ejbVersion.contains("1."));
/*     */   }
/*     */ 
/*     */   public boolean isEJB21()
/*     */   {
/* 231 */     return (this.ejbVersion != null) && (this.ejbVersion.contains("2.1"));
/*     */   }
/*     */ 
/*     */   public boolean isEJB2x()
/*     */   {
/* 236 */     return (this.ejbVersion != null) && (this.ejbVersion.contains("2."));
/*     */   }
/*     */ 
/*     */   public boolean isEJB3x()
/*     */   {
/* 241 */     return (this.ejbVersion != null) && (this.ejbVersion.contains("3."));
/*     */   }
/*     */ 
/*     */   public LoaderRepositoryMetaData getLoaderRepository()
/*     */   {
/* 251 */     return this.loaderRepository;
/*     */   }
/*     */ 
/*     */   public void setLoaderRepository(LoaderRepositoryMetaData loaderRepository)
/*     */   {
/* 262 */     if (loaderRepository == null)
/* 263 */       throw new IllegalArgumentException("Null loaderRepository");
/* 264 */     this.loaderRepository = loaderRepository;
/*     */   }
/*     */ 
/*     */   public String getJmxName()
/*     */   {
/* 274 */     return this.jmxName;
/*     */   }
/*     */ 
/*     */   public String getJaccContextID()
/*     */   {
/* 279 */     return this.jaccContextID;
/*     */   }
/*     */ 
/*     */   public void setJmxName(String jmxName)
/*     */   {
/* 290 */     if (jmxName == null)
/* 291 */       throw new IllegalArgumentException("Null jmxName");
/* 292 */     this.jmxName = jmxName;
/*     */   }
/*     */ 
/*     */   public void setJaccContextID(String jaccContextID)
/*     */   {
/* 301 */     this.jaccContextID = jaccContextID;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 311 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String securityDomain)
/*     */   {
/* 322 */     if (securityDomain == null)
/* 323 */       throw new IllegalArgumentException("Null securityDomain");
/* 324 */     this.securityDomain = securityDomain.trim();
/*     */   }
/*     */ 
/*     */   public boolean isExcludeMissingMethods()
/*     */   {
/* 334 */     return this.excludeMissingMethods;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="missing-method-permissions-excluded-mode")
/*     */   public void setExcludeMissingMethods(boolean excludeMissingMethods)
/*     */   {
/* 345 */     this.excludeMissingMethods = excludeMissingMethods;
/*     */   }
/*     */ 
/*     */   public String getUnauthenticatedPrincipal()
/*     */   {
/* 355 */     return this.unauthenticatedPrincipal;
/*     */   }
/*     */ 
/*     */   public void setUnauthenticatedPrincipal(String unauthenticatedPrincipal)
/*     */   {
/* 366 */     if (unauthenticatedPrincipal == null)
/* 367 */       throw new IllegalArgumentException("Null unauthenticatedPrincipal");
/* 368 */     this.unauthenticatedPrincipal = unauthenticatedPrincipal;
/*     */   }
/*     */ 
/*     */   public boolean isExceptionOnRollback()
/*     */   {
/* 378 */     return this.exceptionOnRollback;
/*     */   }
/*     */ 
/*     */   public void setExceptionOnRollback(boolean exceptionOnRollback)
/*     */   {
/* 388 */     this.exceptionOnRollback = exceptionOnRollback;
/*     */   }
/*     */ 
/*     */   public boolean isMetadataComplete()
/*     */   {
/* 393 */     return this.metadataComplete;
/*     */   }
/*     */ 
/*     */   public void setMetadataComplete(boolean metadataComplete)
/*     */   {
/* 398 */     this.metadataComplete = metadataComplete;
/*     */   }
/*     */ 
/*     */   public JBossEnterpriseBeansMetaData getEnterpriseBeans()
/*     */   {
/* 408 */     return this.enterpriseBeans;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="enterprise-beans")
/*     */   public void setEnterpriseBeans(JBossEnterpriseBeansMetaData enterpriseBeans)
/*     */   {
/* 420 */     if (enterpriseBeans == null)
/* 421 */       throw new IllegalArgumentException("Null enterpriseBeans");
/* 422 */     this.enterpriseBeans = enterpriseBeans;
/* 423 */     this.enterpriseBeans.setJBossMetaData(this);
/*     */   }
/*     */ 
/*     */   public JBossEnterpriseBeanMetaData getEnterpriseBean(String name)
/*     */   {
/* 434 */     if (this.enterpriseBeans == null)
/* 435 */       return null;
/* 436 */     return (JBossEnterpriseBeanMetaData)this.enterpriseBeans.get(name);
/*     */   }
/*     */ 
/*     */   public void setEnforceEjbRestrictions(String enforceEjbRestrictions)
/*     */   {
/* 447 */     log.warn("<enforce-ejb-restrictions/> in jboss.xml is no longer used and will be removed in a future version.");
/*     */   }
/*     */ 
/*     */   public WebservicesMetaData getWebservices()
/*     */   {
/* 457 */     return this.webservices;
/*     */   }
/*     */ 
/*     */   public void setWebservices(WebservicesMetaData webservices)
/*     */   {
/* 468 */     if (webservices == null)
/* 469 */       throw new IllegalArgumentException("Null webservices");
/* 470 */     this.webservices = webservices;
/*     */   }
/*     */ 
/*     */   public ContainerConfigurationsMetaData getContainerConfigurations()
/*     */   {
/* 480 */     return this.containerConfigurations;
/*     */   }
/*     */ 
/*     */   public void setContainerConfigurations(ContainerConfigurationsMetaData containerConfigurations)
/*     */   {
/* 491 */     if (containerConfigurations == null)
/* 492 */       throw new IllegalArgumentException("Null containerConfigurations");
/* 493 */     this.containerConfigurations = containerConfigurations;
/*     */   }
/*     */ 
/*     */   public ContainerConfigurationMetaData getContainerConfiguration(String name)
/*     */   {
/* 504 */     if (this.containerConfigurations == null)
/* 505 */       return null;
/* 506 */     return (ContainerConfigurationMetaData)this.containerConfigurations.get(name);
/*     */   }
/*     */ 
/*     */   public InvokerProxyBindingsMetaData getInvokerProxyBindings()
/*     */   {
/* 516 */     return this.invokerProxyBindings;
/*     */   }
/*     */ 
/*     */   public void setInvokerProxyBindings(InvokerProxyBindingsMetaData invokerProxyBindings)
/*     */   {
/* 527 */     if (invokerProxyBindings == null)
/* 528 */       throw new IllegalArgumentException("Null invokerProxyBindings");
/* 529 */     this.invokerProxyBindings = invokerProxyBindings;
/*     */   }
/*     */ 
/*     */   public InvokerProxyBindingMetaData getInvokerProxyBinding(String name)
/*     */   {
/* 540 */     if (this.invokerProxyBindings == null)
/* 541 */       return null;
/* 542 */     return (InvokerProxyBindingMetaData)this.invokerProxyBindings.get(name);
/*     */   }
/*     */ 
/*     */   public ResourceManagersMetaData getResourceManagers()
/*     */   {
/* 552 */     return this.resourceManagers;
/*     */   }
/*     */ 
/*     */   public void setResourceManagers(ResourceManagersMetaData resourceManagers)
/*     */   {
/* 563 */     if (resourceManagers == null)
/* 564 */       throw new IllegalArgumentException("Null resourceManagers");
/* 565 */     this.resourceManagers = resourceManagers;
/*     */   }
/*     */ 
/*     */   public ResourceManagerMetaData getResourceManager(String name)
/*     */   {
/* 576 */     if (this.resourceManagers == null)
/* 577 */       return null;
/* 578 */     return (ResourceManagerMetaData)this.resourceManagers.get(name);
/*     */   }
/*     */ 
/*     */   public void setAssemblyDescriptor(JBossAssemblyDescriptorMetaData assemblyDescriptor)
/*     */   {
/* 589 */     if (assemblyDescriptor == null)
/* 590 */       throw new IllegalArgumentException("Null assemblyDescriptor");
/* 591 */     this.assemblyDescriptor = assemblyDescriptor;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public RunAsIdentityMetaData getRunAsIdentity(String ejbName)
/*     */   {
/* 602 */     RunAsIdentityMetaData identity = (RunAsIdentityMetaData)this.runAsIdentity.get(ejbName);
/* 603 */     if (identity == null)
/*     */     {
/* 605 */       JBossEnterpriseBeanMetaData ejb = getEnterpriseBean(ejbName);
/* 606 */       if (ejb != null)
/*     */       {
/* 609 */         synchronized (this.runAsIdentity)
/*     */         {
/* 611 */           SecurityIdentityMetaData si = ejb.getSecurityIdentity();
/* 612 */           if (si != null)
/*     */           {
/* 614 */             RunAsMetaData runAs = si.getRunAs();
/* 615 */             if (runAs != null)
/*     */             {
/* 617 */               String roleName = runAs.getRoleName();
/* 618 */               identity = new RunAsIdentityMetaData(roleName, null);
/* 619 */               this.runAsIdentity.put(ejbName, identity);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 625 */     return identity;
/*     */   }
/*     */ 
/*     */   public void merge(JBossMetaData override, EjbJarMetaData original)
/*     */   {
/* 636 */     super.merge(override, original);
/* 637 */     if (this.assemblyDescriptor == null)
/* 638 */       this.assemblyDescriptor = new JBossAssemblyDescriptorMetaData();
/* 639 */     if (this.resourceManagers == null)
/* 640 */       this.resourceManagers = new ResourceManagersMetaData();
/* 641 */     if (this.containerConfigurations == null)
/* 642 */       this.containerConfigurations = new ContainerConfigurationsMetaData();
/* 643 */     if ((override != null) && (override.containerConfigurations != null))
/* 644 */       this.containerConfigurations.merge(override.containerConfigurations);
/* 645 */     if (this.invokerProxyBindings == null)
/* 646 */       this.invokerProxyBindings = new InvokerProxyBindingsMetaData();
/* 647 */     if ((override != null) && (override.invokerProxyBindings != null))
/* 648 */       this.invokerProxyBindings.merge(override.invokerProxyBindings);
/* 649 */     if (this.interceptors == null)
/* 650 */       this.interceptors = new InterceptorsMetaData();
/* 651 */     if ((override != null) && (override.webservices != null)) {
/* 652 */       this.webservices = new WebservicesMetaData();
/*     */     }
/* 654 */     if (original != null)
/*     */     {
/* 656 */       this.ejbVersion = original.getVersion();
/* 657 */       this.relationships = original.getRelationships();
/* 658 */       if ((original instanceof EjbJar3xMetaData))
/*     */       {
/* 660 */         EjbJar3xMetaData original3x = (EjbJar3xMetaData)original;
/* 661 */         this.metadataComplete = original3x.isMetadataComplete();
/*     */       }
/*     */     }
/*     */ 
/* 665 */     if ((override != null) && (override.assemblyDescriptor != null))
/*     */     {
/* 667 */       this.assemblyDescriptor.merge(override.assemblyDescriptor, original.getAssemblyDescriptor());
/*     */     }
/* 669 */     else if ((original != null) && (original.getAssemblyDescriptor() != null))
/*     */     {
/* 671 */       this.assemblyDescriptor.merge(null, original.getAssemblyDescriptor());
/*     */     }
/*     */ 
/* 674 */     if ((override != null) && (override.resourceManagers != null)) {
/* 675 */       this.resourceManagers.merge(override.resourceManagers);
/*     */     }
/* 677 */     if ((override != null) && (override.interceptors != null))
/* 678 */       this.interceptors.merge(override.interceptors);
/* 679 */     else if ((original != null) && (original.getInterceptors() != null)) {
/* 680 */       this.interceptors.merge(original.getInterceptors());
/*     */     }
/* 682 */     if (override != null)
/*     */     {
/* 684 */       if (override.jaccContextID != null)
/* 685 */         this.jaccContextID = override.jaccContextID;
/* 686 */       if (override.jmxName != null)
/* 687 */         this.jmxName = override.jmxName;
/* 688 */       if (override.loaderRepository != null)
/* 689 */         this.loaderRepository = override.loaderRepository;
/* 690 */       if (override.securityDomain != null)
/* 691 */         this.securityDomain = override.securityDomain;
/* 692 */       if (override.unauthenticatedPrincipal != null)
/* 693 */         this.unauthenticatedPrincipal = override.unauthenticatedPrincipal;
/* 694 */       if (override.metadataComplete) {
/* 695 */         this.metadataComplete = true;
/*     */       }
/*     */     }
/* 698 */     if ((this.webservices != null) && (override != null)) {
/* 699 */       this.webservices.merge(override.webservices);
/*     */     }
/* 701 */     if (this.enterpriseBeans == null)
/*     */     {
/* 703 */       this.enterpriseBeans = new JBossEnterpriseBeansMetaData();
/* 704 */       this.enterpriseBeans.setJBossMetaData(this);
/*     */     }
/*     */ 
/* 707 */     JBossEnterpriseBeansMetaData jbeans = null;
/* 708 */     if (override != null)
/*     */     {
/* 710 */       jbeans = override.enterpriseBeans;
/*     */ 
/* 713 */       if (!override.excludeMissingMethods) {
/* 714 */         this.excludeMissingMethods = false;
/*     */       }
/*     */     }
/* 717 */     EnterpriseBeansMetaData beans = null;
/* 718 */     if (original != null) {
/* 719 */       beans = original.getEnterpriseBeans();
/*     */     }
/* 721 */     boolean isEJB3x = (original == null) || (original.isEJB3x());
/* 722 */     this.enterpriseBeans.merge(jbeans, beans, "ejb-jar.xml", "jboss.xml", !isEJB3x);
/*     */ 
/* 725 */     if (this.enterpriseBeans != null)
/*     */     {
/* 727 */       for (JBossEnterpriseBeanMetaData ejb : this.enterpriseBeans)
/*     */       {
/* 729 */         String ejbName = ejb.getEjbName();
/* 730 */         SecurityIdentityMetaData si = ejb.getSecurityIdentity();
/* 731 */         String principalName = si != null ? si.getRunAsPrincipal() : null;
/*     */ 
/* 733 */         String ejbXmlRunAs = null;
/* 734 */         if ((si != null) && (si.getRunAs() != null))
/* 735 */           ejbXmlRunAs = si.getRunAs().getRoleName();
/* 736 */         if (principalName != null)
/*     */         {
/* 739 */           if (ejbXmlRunAs == null)
/*     */           {
/* 743 */             ejbXmlRunAs = "anonymous";
/*     */           }
/*     */ 
/* 746 */           Set extraRoles = null;
/* 747 */           if (getAssemblyDescriptor() != null)
/*     */           {
/* 749 */             extraRoles = getAssemblyDescriptor().getSecurityRoleNamesByPrincipal(principalName);
/*     */           }
/* 751 */           RunAsIdentityMetaData runAsId = new RunAsIdentityMetaData(ejbXmlRunAs, principalName, extraRoles);
/* 752 */           this.runAsIdentity.put(ejbName, runAsId);
/*     */         }
/* 754 */         else if (ejbXmlRunAs != null)
/*     */         {
/* 756 */           RunAsIdentityMetaData runAsId = new RunAsIdentityMetaData(ejbXmlRunAs, null);
/* 757 */           this.runAsIdentity.put(ejbName, runAsId);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected JBossEnterpriseBeanMetaData newBean()
/*     */   {
/* 769 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.JBossMetaData
 * JD-Core Version:    0.6.0
 */