/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.common.ejb.IAssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImpl;
/*     */ 
/*     */ @XmlType(name="assembly-descriptorType")
/*     */ public class AssemblyDescriptorMetaData extends IdMetaDataImpl
/*     */   implements IAssemblyDescriptorMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 7634431073492003512L;
/*     */   private SecurityRolesMetaData securityRoles;
/*     */   private MethodPermissionsMetaData methodPermissions;
/*     */   private ContainerTransactionsMetaData containerTransactions;
/*     */   private InterceptorBindingsMetaData interceptorBindings;
/*     */   private MessageDestinationsMetaData messageDestinations;
/*     */   private ExcludeListMetaData excludeList;
/*     */   private ApplicationExceptionsMetaData applicationExceptions;
/*     */ 
/*     */   public SecurityRoleMetaData getSecurityRole(String roleName)
/*     */   {
/*  77 */     return (SecurityRoleMetaData)this.securityRoles.get(roleName);
/*     */   }
/*     */ 
/*     */   public SecurityRolesMetaData getSecurityRoles()
/*     */   {
/*  86 */     return this.securityRoles;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="security-role")
/*     */   public void setSecurityRoles(SecurityRolesMetaData securityRoles)
/*     */   {
/*  98 */     if (securityRoles == null)
/*  99 */       throw new IllegalArgumentException("Null securityRoles");
/* 100 */     this.securityRoles = securityRoles;
/*     */   }
/*     */ 
/*     */   public MethodPermissionsMetaData getMethodPermissions()
/*     */   {
/* 110 */     return this.methodPermissions;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="method-permission")
/*     */   public void setMethodPermissions(MethodPermissionsMetaData methodPermissions)
/*     */   {
/* 122 */     if (methodPermissions == null)
/* 123 */       throw new IllegalArgumentException("Null methodPermissions");
/* 124 */     this.methodPermissions = methodPermissions;
/*     */   }
/*     */ 
/*     */   public MethodPermissionsMetaData getMethodPermissionsByEjbName(String ejbName)
/*     */   {
/* 136 */     if (ejbName == null) {
/* 137 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 139 */     if (this.methodPermissions == null)
/* 140 */       return null;
/* 141 */     return this.methodPermissions.getMethodPermissionsByEjbName(ejbName);
/*     */   }
/*     */ 
/*     */   public ContainerTransactionsMetaData getContainerTransactions()
/*     */   {
/* 151 */     return this.containerTransactions;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="container-transaction")
/*     */   public void setContainerTransactions(ContainerTransactionsMetaData containerTransactions)
/*     */   {
/* 163 */     if (containerTransactions == null)
/* 164 */       throw new IllegalArgumentException("Null containerTransactions");
/* 165 */     this.containerTransactions = containerTransactions;
/*     */   }
/*     */ 
/*     */   public ContainerTransactionsMetaData getContainerTransactionsByEjbName(String ejbName)
/*     */   {
/* 177 */     if (ejbName == null) {
/* 178 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 180 */     if (this.containerTransactions == null)
/* 181 */       return null;
/* 182 */     return this.containerTransactions.getContainerTransactionsByEjbName(ejbName);
/*     */   }
/*     */ 
/*     */   public InterceptorBindingsMetaData getInterceptorBindings()
/*     */   {
/* 192 */     return this.interceptorBindings;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="interceptor-binding", required=false)
/*     */   public void setInterceptorBindings(InterceptorBindingsMetaData interceptorBindings)
/*     */   {
/* 204 */     if (interceptorBindings == null)
/* 205 */       throw new IllegalArgumentException("Null interceptorBindings");
/* 206 */     this.interceptorBindings = interceptorBindings;
/*     */   }
/*     */ 
/*     */   public MessageDestinationsMetaData getMessageDestinations()
/*     */   {
/* 216 */     return this.messageDestinations;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="message-destination")
/*     */   public void setMessageDestinations(MessageDestinationsMetaData messageDestinations)
/*     */   {
/* 228 */     if (messageDestinations == null)
/* 229 */       throw new IllegalArgumentException("Null messageDestinations");
/* 230 */     this.messageDestinations = messageDestinations;
/*     */   }
/*     */ 
/*     */   public MessageDestinationMetaData getMessageDestination(String name)
/*     */   {
/* 241 */     if (this.messageDestinations == null)
/* 242 */       return null;
/* 243 */     return (MessageDestinationMetaData)this.messageDestinations.get(name);
/*     */   }
/*     */ 
/*     */   public ExcludeListMetaData getExcludeList()
/*     */   {
/* 253 */     return this.excludeList;
/*     */   }
/*     */ 
/*     */   public void setExcludeList(ExcludeListMetaData excludeList)
/*     */   {
/* 264 */     if (excludeList == null)
/* 265 */       throw new IllegalArgumentException("Null excludeList");
/* 266 */     this.excludeList = excludeList;
/*     */   }
/*     */ 
/*     */   public ExcludeListMetaData getExcludeListByEjbName(String ejbName)
/*     */   {
/* 278 */     if (ejbName == null) {
/* 279 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 281 */     if (this.excludeList == null)
/* 282 */       return null;
/* 283 */     return this.excludeList.getExcludeListByEjbName(ejbName);
/*     */   }
/*     */ 
/*     */   public ApplicationExceptionsMetaData getApplicationExceptions()
/*     */   {
/* 293 */     return this.applicationExceptions;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="application-exception", required=false)
/*     */   public void setApplicationExceptions(ApplicationExceptionsMetaData applicationExceptions)
/*     */   {
/* 305 */     if (applicationExceptions == null)
/* 306 */       throw new IllegalArgumentException("Null applicationExceptions");
/* 307 */     this.applicationExceptions = applicationExceptions;
/*     */   }
/*     */ 
/*     */   public void merge(AssemblyDescriptorMetaData override, AssemblyDescriptorMetaData original)
/*     */   {
/* 312 */     super.merge(override, original);
/*     */ 
/* 314 */     if (((override != null) && (override.applicationExceptions != null)) || ((original != null) && (original.applicationExceptions != null)))
/*     */     {
/* 316 */       this.applicationExceptions = new ApplicationExceptionsMetaData();
/* 317 */       this.applicationExceptions.merge(override != null ? override.applicationExceptions : null, original != null ? original.applicationExceptions : null);
/*     */     }
/*     */ 
/* 320 */     if (((override != null) && (override.containerTransactions != null)) || ((original != null) && (original.containerTransactions != null)))
/*     */     {
/* 322 */       this.containerTransactions = new ContainerTransactionsMetaData();
/* 323 */       this.containerTransactions.merge(override != null ? override.containerTransactions : null, original != null ? original.containerTransactions : null);
/*     */     }
/*     */ 
/* 326 */     if (((override != null) && (override.excludeList != null)) || ((original != null) && (original.excludeList != null)))
/*     */     {
/* 328 */       this.excludeList = new ExcludeListMetaData();
/* 329 */       this.excludeList.merge(override != null ? override.excludeList : null, original != null ? original.excludeList : null);
/*     */     }
/*     */ 
/* 332 */     if (((override != null) && (override.interceptorBindings != null)) || ((original != null) && (original.interceptorBindings != null)))
/*     */     {
/* 334 */       this.interceptorBindings = new InterceptorBindingsMetaData();
/* 335 */       this.interceptorBindings.merge(override != null ? override.interceptorBindings : null, original != null ? original.interceptorBindings : null);
/*     */     }
/*     */ 
/* 338 */     if (((override != null) && (override.messageDestinations != null)) || ((original != null) && (original.messageDestinations != null)))
/*     */     {
/* 340 */       this.messageDestinations = new MessageDestinationsMetaData();
/* 341 */       this.messageDestinations.merge(override != null ? override.messageDestinations : null, original != null ? original.messageDestinations : null);
/*     */     }
/*     */ 
/* 344 */     if (((override != null) && (override.methodPermissions != null)) || ((original != null) && (original.methodPermissions != null)))
/*     */     {
/* 346 */       this.methodPermissions = new MethodPermissionsMetaData();
/* 347 */       this.methodPermissions.merge(override != null ? override.methodPermissions : null, original != null ? original.methodPermissions : null);
/*     */     }
/*     */ 
/* 350 */     if (((override != null) && (override.securityRoles != null)) || ((original != null) && (original.securityRoles != null)))
/*     */     {
/* 352 */       this.securityRoles = new SecurityRolesMetaData();
/* 353 */       this.securityRoles.merge(override != null ? override.securityRoles : null, original != null ? original.securityRoles : null);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData
 * JD-Core Version:    0.6.0
 */