/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import java.util.AbstractList;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptions;
/*     */ import org.jboss.xb.annotations.JBossXmlModelGroup;
/*     */ 
/*     */ @JBossXmlModelGroup(kind="choice", particles={@org.jboss.xb.annotations.JBossXmlModelGroup.Particle(element=@XmlElement(name="ejb-relation"), type=RelationMetaData.class)})
/*     */ public class RelationMetaData extends NamedMetaDataWithDescriptions
/*     */ {
/*     */   private static final long serialVersionUID = -3955264328575239287L;
/*     */   private RelationRoleMetaData leftRole;
/*     */   private RelationRoleMetaData rightRole;
/*     */ 
/*     */   public String getEjbRelationName()
/*     */   {
/*  70 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setEjbRelationName(String ejbRelationName)
/*     */   {
/*  81 */     setName(ejbRelationName);
/*     */   }
/*     */ 
/*     */   public RelationRoleMetaData getLeftRole()
/*     */   {
/*  91 */     return this.leftRole;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public void setLeftRole(RelationRoleMetaData leftRole)
/*     */   {
/* 103 */     if (leftRole == null)
/* 104 */       throw new IllegalArgumentException("Null leftRole");
/* 105 */     this.leftRole = leftRole;
/* 106 */     leftRole.setRelation(this);
/*     */   }
/*     */ 
/*     */   public RelationRoleMetaData getRightRole()
/*     */   {
/* 116 */     return this.rightRole;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public void setRightRole(RelationRoleMetaData rightRole)
/*     */   {
/* 128 */     if (rightRole == null)
/* 129 */       throw new IllegalArgumentException("Null rightRole");
/* 130 */     this.rightRole = rightRole;
/* 131 */     rightRole.setRelation(this);
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public RelationRoleMetaData getRelatedRole(RelationRoleMetaData role)
/*     */   {
/* 144 */     if (role == this.leftRole)
/* 145 */       return this.rightRole;
/* 146 */     if (role == this.rightRole)
/* 147 */       return this.leftRole;
/* 148 */     throw new IllegalArgumentException(role + " is not a role in this relationship: " + this);
/*     */   }
/*     */ 
/*     */   public List<RelationRoleMetaData> getEjbRelationshipRoles()
/*     */   {
/* 159 */     return new AbstractList()
/*     */     {
/*     */       public RelationRoleMetaData get(int index)
/*     */       {
/* 164 */         if (index > size())
/*     */         {
/* 166 */           throw new IllegalArgumentException("Index must be less then " + size() + ": " + index);
/*     */         }
/* 168 */         return index == 0 ? RelationMetaData.this.leftRole : RelationMetaData.this.rightRole;
/*     */       }
/*     */ 
/*     */       public int size()
/*     */       {
/* 174 */         return RelationMetaData.this.leftRole == null ? 1 : RelationMetaData.this.rightRole == null ? 0 : 2;
/*     */       }
/*     */ 
/*     */       public boolean add(RelationRoleMetaData o)
/*     */       {
/* 180 */         if (RelationMetaData.this.leftRole == null)
/*     */         {
/* 182 */           RelationMetaData.this.setLeftRole(o);
/*     */         }
/* 184 */         else if (RelationMetaData.this.rightRole == null)
/*     */         {
/* 186 */           RelationMetaData.this.setRightRole(o);
/*     */         }
/*     */         else
/*     */         {
/* 190 */           throw new IllegalStateException("Too many roles: " + o);
/*     */         }
/* 192 */         return true;
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   @XmlElement(name="ejb-relationship-role")
/*     */   public void setEjbRelationshipRoles(List<RelationRoleMetaData> roleMetaData)
/*     */   {
/* 211 */     throw new UnsupportedOperationException("this list shouldn't be set");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.RelationMetaData
 * JD-Core Version:    0.6.0
 */