/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.spec.EmptyMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RunAsMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptions;
/*     */ import org.jboss.metadata.javaee.support.MergeableMetaData;
/*     */ 
/*     */ @XmlType(name="security-identityType")
/*     */ public class SecurityIdentityMetaData extends IdMetaDataImplWithDescriptions
/*     */   implements MergeableMetaData<SecurityIdentityMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = -6336033602938028216L;
/*     */   private EmptyMetaData useCallerIdentity;
/*     */   private RunAsMetaData runAs;
/*     */   private String runAsPrincipal;
/*     */ 
/*     */   public boolean isUseCallerId()
/*     */   {
/*  69 */     return this.useCallerIdentity != null;
/*     */   }
/*     */ 
/*     */   public EmptyMetaData getUseCallerIdentity()
/*     */   {
/*  79 */     return this.useCallerIdentity;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setUseCallerIdentity(EmptyMetaData useCallerIdentity)
/*     */   {
/*  90 */     this.useCallerIdentity = useCallerIdentity;
/*     */   }
/*     */ 
/*     */   public RunAsMetaData getRunAs()
/*     */   {
/* 100 */     return this.runAs;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setRunAs(RunAsMetaData runAs)
/*     */   {
/* 113 */     if (runAs == null)
/* 114 */       throw new IllegalArgumentException("Null runAs");
/* 115 */     this.runAs = runAs;
/*     */   }
/*     */ 
/*     */   public String getRunAsPrincipal()
/*     */   {
/* 125 */     return this.runAsPrincipal;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setRunAsPrincipal(String runAsPrincipal)
/*     */   {
/* 137 */     if (runAsPrincipal == null)
/* 138 */       throw new IllegalArgumentException("Null runAsPrincipal");
/* 139 */     this.runAsPrincipal = runAsPrincipal;
/*     */   }
/*     */ 
/*     */   public SecurityIdentityMetaData merge(SecurityIdentityMetaData original)
/*     */   {
/* 144 */     SecurityIdentityMetaData merged = new SecurityIdentityMetaData();
/* 145 */     merge(merged, original);
/* 146 */     return merged;
/*     */   }
/*     */ 
/*     */   public void merge(SecurityIdentityMetaData override, SecurityIdentityMetaData original)
/*     */   {
/* 156 */     super.merge(override, original);
/* 157 */     if ((override != null) && (override.getUseCallerIdentity() != null))
/* 158 */       setUseCallerIdentity(override.getUseCallerIdentity());
/* 159 */     else if ((original != null) && (original.getUseCallerIdentity() != null))
/* 160 */       setUseCallerIdentity(original.getUseCallerIdentity());
/* 161 */     if ((override != null) && (override.getRunAs() != null))
/* 162 */       setRunAs(override.getRunAs());
/* 163 */     else if ((original != null) && (original.getRunAs() != null))
/* 164 */       setRunAs(original.getRunAs());
/* 165 */     if ((override != null) && (override.getRunAsPrincipal() != null))
/* 166 */       setRunAsPrincipal(getRunAsPrincipal());
/* 167 */     else if ((original != null) && (original.getRunAsPrincipal() != null))
/* 168 */       setRunAsPrincipal(original.getRunAsPrincipal());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.SecurityIdentityMetaData
 * JD-Core Version:    0.6.0
 */