/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;
/*     */ 
/*     */ public abstract class AbstractEJBReferenceMetaData extends ResourceInjectionMetaDataWithDescriptions
/*     */ {
/*     */   private static final long serialVersionUID = 6067128692691909155L;
/*     */   private EJBReferenceType type;
/*     */   private String link;
/*     */ 
/*     */   public String getEjbRefName()
/*     */   {
/*  60 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setEjbRefName(String ejbRefName)
/*     */   {
/*  71 */     setName(ejbRefName);
/*     */   }
/*     */ 
/*     */   public EJBReferenceType getEjbRefType()
/*     */   {
/*  81 */     return this.type;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="ejb-ref-type")
/*     */   public void setEjbRefType(EJBReferenceType type)
/*     */   {
/*  93 */     if (type == null)
/*  94 */       throw new IllegalArgumentException("Null type");
/*  95 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 105 */     if (this.type == null)
/* 106 */       throw new IllegalStateException("Type has not been set: " + this);
/* 107 */     return this.type.name();
/*     */   }
/*     */ 
/*     */   public String getLink()
/*     */   {
/* 117 */     return this.link;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="ejb-link")
/*     */   public void setLink(String link)
/*     */   {
/* 129 */     if (link == null)
/* 130 */       throw new IllegalArgumentException("Null link");
/* 131 */     this.link = link;
/*     */   }
/*     */ 
/*     */   public void merge(AbstractEJBReferenceMetaData override, AbstractEJBReferenceMetaData original)
/*     */   {
/* 142 */     super.merge(override, original);
/* 143 */     if ((override != null) && (override.getEjbRefName() != null))
/* 144 */       setEjbRefName(override.getEjbRefName());
/* 145 */     else if ((original != null) && (original.getEjbRefName() != null))
/* 146 */       setEjbRefName(original.getEjbRefName());
/* 147 */     if ((override != null) && (override.type != null))
/* 148 */       setEjbRefType(override.type);
/* 149 */     else if ((original != null) && (original.type != null))
/* 150 */       setEjbRefType(original.type);
/* 151 */     if ((override != null) && (override.link != null))
/* 152 */       setLink(override.link);
/* 153 */     else if ((original != null) && (original.link != null))
/* 154 */       setLink(original.link);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.AbstractEJBReferenceMetaData
 * JD-Core Version:    0.6.0
 */