/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import java.util.Set;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.javaee.support.NamedMetaData;
/*     */ 
/*     */ public abstract class ResourceInjectionMetaData extends NamedMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 6333738851813890701L;
/*     */   private String mappedName;
/*     */   private String resolvedJndiName;
/*     */   private Set<ResourceInjectionTargetMetaData> injectionTargets;
/*     */   private EmptyMetaData ignoreDependency;
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/*  69 */     return getMappedName();
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setJndiName(String jndiName)
/*     */   {
/*  82 */     setMappedName(jndiName);
/*     */   }
/*     */ 
/*     */   public String getMappedName()
/*     */   {
/*  92 */     return this.mappedName;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setMappedName(String mappedName)
/*     */   {
/* 106 */     if (mappedName == null)
/* 107 */       throw new IllegalArgumentException("Null mappedName");
/* 108 */     this.mappedName = mappedName;
/*     */   }
/*     */ 
/*     */   public String getResolvedJndiName()
/*     */   {
/* 119 */     return this.resolvedJndiName;
/*     */   }
/*     */   @XmlTransient
/*     */   public void setResolvedJndiName(String resolvedJndiName) {
/* 124 */     this.resolvedJndiName = resolvedJndiName;
/*     */   }
/*     */ 
/*     */   public Set<ResourceInjectionTargetMetaData> getInjectionTargets()
/*     */   {
/* 134 */     return this.injectionTargets;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="injection-target", required=false)
/*     */   public void setInjectionTargets(Set<ResourceInjectionTargetMetaData> injectionTargets)
/*     */   {
/* 148 */     if (injectionTargets == null)
/* 149 */       throw new IllegalArgumentException("Null injectionTargets");
/* 150 */     this.injectionTargets = injectionTargets;
/*     */   }
/*     */ 
/*     */   public EmptyMetaData getIgnoreDependency()
/*     */   {
/* 160 */     return this.ignoreDependency;
/*     */   }
/*     */ 
/*     */   @XmlElement(required=false)
/*     */   public void setIgnoreDependency(EmptyMetaData ignoreDependency)
/*     */   {
/* 173 */     if (ignoreDependency == null)
/* 174 */       throw new IllegalArgumentException("Null ignoreDependency");
/* 175 */     this.ignoreDependency = ignoreDependency;
/*     */   }
/*     */ 
/*     */   public boolean isDependencyIgnored()
/*     */   {
/* 185 */     return this.ignoreDependency != null;
/*     */   }
/*     */ 
/*     */   public void merge(ResourceInjectionMetaData override, ResourceInjectionMetaData original)
/*     */   {
/* 196 */     super.merge(override, original);
/* 197 */     if ((override != null) && (override.mappedName != null))
/* 198 */       setMappedName(override.mappedName);
/* 199 */     else if (original.mappedName != null)
/* 200 */       setMappedName(original.mappedName);
/* 201 */     if ((override != null) && (override.ignoreDependency != null))
/* 202 */       setIgnoreDependency(override.ignoreDependency);
/* 203 */     else if (original.ignoreDependency != null) {
/* 204 */       setIgnoreDependency(original.ignoreDependency);
/*     */     }
/*     */ 
/* 207 */     if ((override != null) && (override.injectionTargets != null))
/* 208 */       setInjectionTargets(override.injectionTargets);
/* 209 */     else if (original.injectionTargets != null)
/* 210 */       setInjectionTargets(original.injectionTargets);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.ResourceInjectionMetaData
 * JD-Core Version:    0.6.0
 */