/*     */ package org.jboss.metadata.javaee.spec;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.support.MergeableMappedMetaData;
/*     */ import org.jboss.metadata.javaee.support.NamedMetaDataWithDescriptions;
/*     */ 
/*     */ @XmlType(name="security-roleType")
/*     */ public class SecurityRoleMetaData extends NamedMetaDataWithDescriptions
/*     */   implements MergeableMappedMetaData<SecurityRoleMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = -4349954695900237831L;
/*     */   private Set<String> principals;
/*     */ 
/*     */   public String getRoleName()
/*     */   {
/*  66 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setRoleName(String roleName)
/*     */   {
/*  77 */     setName(roleName);
/*     */   }
/*     */ 
/*     */   public Set<String> getPrincipals()
/*     */   {
/*  88 */     return this.principals;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="principal-name", required=false)
/*     */   public void setPrincipals(Set<String> principals)
/*     */   {
/* 100 */     if (principals == null)
/* 101 */       throw new IllegalArgumentException("Null principals");
/* 102 */     this.principals = principals;
/*     */   }
/*     */ 
/*     */   public boolean hasPrincipal(String userName)
/*     */   {
/* 114 */     if (userName == null)
/* 115 */       throw new IllegalArgumentException("Null userName");
/* 116 */     if (this.principals == null)
/* 117 */       return false;
/* 118 */     return this.principals.contains(userName);
/*     */   }
/*     */ 
/*     */   public SecurityRoleMetaData merge(SecurityRoleMetaData original)
/*     */   {
/* 123 */     SecurityRoleMetaData merged = new SecurityRoleMetaData();
/* 124 */     merged.merge(this, original);
/* 125 */     return merged;
/*     */   }
/*     */ 
/*     */   public void merge(SecurityRoleMetaData override, SecurityRoleMetaData original) {
/* 129 */     super.merge(override, original);
/* 130 */     if ((override != null) && (override.principals != null))
/*     */     {
/* 132 */       if (this.principals == null)
/* 133 */         this.principals = new HashSet();
/* 134 */       this.principals.addAll(override.principals);
/*     */     }
/* 136 */     if ((original != null) && (original.principals != null))
/*     */     {
/* 138 */       if (this.principals == null)
/* 139 */         this.principals = new HashSet();
/* 140 */       this.principals.addAll(original.principals);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.spec.SecurityRoleMetaData
 * JD-Core Version:    0.6.0
 */