/*     */ package org.jboss.metadata.javaee.support;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ public abstract class AbstractMappedMetaData<T extends MappableMetaData> extends IdMetaDataImpl
/*     */   implements MappedMetaData<T>
/*     */ {
/*     */   private static final long serialVersionUID = 5696461894017065337L;
/*     */   private String keyName;
/*     */   private Map<String, T> map;
/*     */ 
/*     */   public static <T extends MappableMetaData> T getByName(String name, MappedMetaData<T> map)
/*     */   {
/*  58 */     if (name == null)
/*  59 */       throw new IllegalArgumentException("Null name");
/*  60 */     if (map == null)
/*  61 */       return null;
/*  62 */     return map.get(name);
/*     */   }
/*     */ 
/*     */   protected AbstractMappedMetaData(String keyName)
/*     */   {
/*  72 */     if (keyName == null)
/*  73 */       throw new IllegalArgumentException("Null keyName");
/*  74 */     this.keyName = keyName;
/*     */   }
/*     */ 
/*     */   public boolean containsKey(String key)
/*     */   {
/*  79 */     boolean containsKey = false;
/*  80 */     if (this.map != null)
/*  81 */       containsKey = this.map.containsKey(key);
/*  82 */     return containsKey;
/*     */   }
/*     */ 
/*     */   public Set<String> keySet()
/*     */   {
/*  92 */     if (this.map == null)
/*  93 */       return Collections.emptySet();
/*  94 */     return Collections.unmodifiableSet(this.map.keySet());
/*     */   }
/*     */ 
/*     */   public T get(String key)
/*     */   {
/* 106 */     if (key == null)
/* 107 */       throw new IllegalArgumentException("No " + this.keyName);
/* 108 */     if (this.map == null)
/* 109 */       return null;
/* 110 */     return (MappableMetaData)this.map.get(key);
/*     */   }
/*     */ 
/*     */   public boolean add(T o)
/*     */   {
/* 115 */     if (o == null)
/* 116 */       throw new IllegalArgumentException("Null object");
/* 117 */     String key = o.getKey();
/* 118 */     if (key == null) {
/* 119 */       throw new IllegalArgumentException("No " + this.keyName);
/*     */     }
/* 121 */     if (this.map == null)
/* 122 */       this.map = new NonNullLinkedHashMap();
/* 123 */     MappableMetaData result = (MappableMetaData)this.map.put(key, o);
/* 124 */     if (result != null)
/* 125 */       removeNotification(result);
/* 126 */     addNotification(o);
/* 127 */     return true;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 132 */     if (this.map != null)
/* 133 */       for (MappableMetaData t : this.map.values())
/* 134 */         removeNotification(t);
/* 135 */     this.map = null;
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/* 140 */     if (o == null)
/* 141 */       throw new IllegalArgumentException("Null object");
/* 142 */     if (this.map == null)
/* 143 */       return false;
/* 144 */     return this.map.containsValue(o);
/*     */   }
/*     */ 
/*     */   public Iterator<T> iterator()
/*     */   {
/* 149 */     if (this.map == null)
/*     */     {
/* 151 */       Collection result = Collections.emptyList();
/* 152 */       return result.iterator();
/*     */     }
/* 154 */     return Collections.unmodifiableCollection(this.map.values()).iterator();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 159 */     if (o == null)
/* 160 */       throw new IllegalArgumentException("Null object");
/* 161 */     if ((o instanceof MappableMetaData)) {
/* 162 */       return false;
/*     */     }
/* 164 */     if (this.map == null) {
/* 165 */       return false;
/*     */     }
/* 167 */     MappableMetaData m = (MappableMetaData)o;
/* 168 */     String key = m.getKey();
/* 169 */     MappableMetaData v = (MappableMetaData)this.map.get(key);
/* 170 */     if (m.equals(v))
/*     */     {
/* 172 */       MappableMetaData result = (MappableMetaData)this.map.remove(key);
/* 173 */       if (result != null)
/*     */       {
/* 175 */         removeNotification(result);
/* 176 */         return true;
/*     */       }
/*     */     }
/* 179 */     return false;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 184 */     if (this.map == null)
/* 185 */       return 0;
/* 186 */     return this.map.size();
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection<? extends T> c)
/*     */   {
/* 191 */     boolean result = false;
/* 192 */     for (MappableMetaData object : c)
/*     */     {
/* 194 */       if (add(object))
/* 195 */         result = true;
/*     */     }
/* 197 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection<?> c)
/*     */   {
/* 202 */     if (this.map == null) {
/* 203 */       return c.isEmpty();
/*     */     }
/* 205 */     for (Iterator i$ = c.iterator(); i$.hasNext(); ) { Object object = i$.next();
/*     */ 
/* 207 */       if (!contains(object))
/* 208 */         return false;
/*     */     }
/* 210 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 215 */     if (this.map == null)
/* 216 */       return true;
/* 217 */     return size() == 0;
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection<?> c)
/*     */   {
/* 222 */     if (this.map == null) {
/* 223 */       return false;
/*     */     }
/* 225 */     boolean result = false;
/* 226 */     for (Iterator i$ = c.iterator(); i$.hasNext(); ) { Object object = i$.next();
/*     */ 
/* 228 */       if (remove(object))
/* 229 */         result = true;
/*     */     }
/* 231 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection<?> c)
/*     */   {
/* 236 */     if (this.map == null) {
/* 237 */       return false;
/*     */     }
/* 239 */     boolean result = false;
/* 240 */     for (Object o : this.map.values())
/*     */     {
/* 242 */       if (c.contains(o))
/*     */       {
/* 244 */         if (remove(o))
/* 245 */           result = true;
/*     */       }
/*     */     }
/* 248 */     return result;
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 253 */     if (this.map == null)
/* 254 */       return new Object[0];
/* 255 */     return this.map.values().toArray();
/*     */   }
/*     */ 
/*     */   public <X> X[] toArray(X[] a)
/*     */   {
/* 261 */     if (this.map == null)
/* 262 */       return (Object[])new Object[0];
/* 263 */     return this.map.values().toArray(a);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 269 */     if (obj == this)
/* 270 */       return true;
/* 271 */     if ((obj == null) || (!(obj instanceof Collection)))
/* 272 */       return false;
/* 273 */     Collection other = (Collection)obj;
/*     */ 
/* 275 */     if (size() != other.size()) {
/* 276 */       return false;
/*     */     }
/* 278 */     if (this.map == null) {
/* 279 */       return true;
/*     */     }
/* 281 */     return other.containsAll(this.map.values());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 287 */     if (this.map == null)
/* 288 */       return 0;
/* 289 */     return this.map.values().hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 295 */     if (this.map == null)
/* 296 */       return "[]";
/* 297 */     return this.map.values().toString();
/*     */   }
/*     */ 
/*     */   protected void addNotification(T added)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void removeNotification(T removed)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.support.AbstractMappedMetaData
 * JD-Core Version:    0.6.0
 */