/*     */ package org.jboss.metadata.javaee.support;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.metadata.annotation.AbstractAnnotationImpl;
/*     */ 
/*     */ public abstract class MappedAnnotationMetaData<T extends MappableMetaData> extends AbstractAnnotationImpl
/*     */   implements Collection<T>, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -3359670727781266839L;
/*  45 */   private Map<String, T> map = new NonNullLinkedHashMap();
/*     */ 
/*     */   public MappedAnnotationMetaData(Class<? extends Annotation> annotationType)
/*     */   {
/*  54 */     super(annotationType);
/*     */   }
/*     */ 
/*     */   public T get(String key)
/*     */   {
/*  66 */     if (key == null)
/*  67 */       throw new IllegalArgumentException("Null key");
/*  68 */     return (MappableMetaData)this.map.get(key);
/*     */   }
/*     */ 
/*     */   public boolean add(T o)
/*     */   {
/*  73 */     if (o == null)
/*  74 */       throw new IllegalArgumentException("Null object");
/*  75 */     String key = o.getKey();
/*  76 */     if (key == null) {
/*  77 */       throw new IllegalArgumentException("Null key");
/*     */     }
/*  79 */     return this.map.put(key, o) == null;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  84 */     this.map.clear();
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/*  89 */     if (o == null)
/*  90 */       throw new IllegalArgumentException("Null object");
/*  91 */     return this.map.containsValue(o);
/*     */   }
/*     */ 
/*     */   public Iterator<T> iterator()
/*     */   {
/*  96 */     return this.map.values().iterator();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 101 */     if (o == null)
/* 102 */       throw new IllegalArgumentException("Null object");
/* 103 */     if ((o instanceof MappableMetaData))
/* 104 */       return false;
/* 105 */     MappableMetaData m = (MappableMetaData)o;
/* 106 */     String key = m.getKey();
/* 107 */     MappableMetaData v = (MappableMetaData)this.map.get(key);
/* 108 */     if (m.equals(v))
/* 109 */       return this.map.remove(key) != null;
/* 110 */     return false;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 115 */     return this.map.size();
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection<? extends T> c)
/*     */   {
/* 120 */     boolean result = false;
/* 121 */     for (MappableMetaData object : c)
/*     */     {
/* 123 */       if (add(object))
/* 124 */         result = true;
/*     */     }
/* 126 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection<?> c)
/*     */   {
/* 131 */     for (Iterator i$ = c.iterator(); i$.hasNext(); ) { Object object = i$.next();
/*     */ 
/* 133 */       if (!contains(object))
/* 134 */         return false;
/*     */     }
/* 136 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 141 */     return size() == 0;
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection<?> c)
/*     */   {
/* 146 */     boolean result = false;
/* 147 */     for (Iterator i$ = c.iterator(); i$.hasNext(); ) { Object object = i$.next();
/*     */ 
/* 149 */       if (remove(object))
/* 150 */         result = true;
/*     */     }
/* 152 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection<?> c)
/*     */   {
/* 157 */     boolean result = false;
/* 158 */     for (Object o : this.map.values())
/*     */     {
/* 160 */       if (c.contains(o))
/*     */       {
/* 162 */         if (remove(o))
/* 163 */           result = true;
/*     */       }
/*     */     }
/* 166 */     return result;
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 171 */     return this.map.values().toArray();
/*     */   }
/*     */ 
/*     */   public <T> T[] toArray(T[] a)
/*     */   {
/* 176 */     return this.map.values().toArray(a);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 182 */     return this.map.values().equals(obj);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 188 */     return this.map.values().hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 194 */     return this.map.values().toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.javaee.support.MappedAnnotationMetaData
 * JD-Core Version:    0.6.0
 */