/*     */ package org.jboss.metadata.merge;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EjbJarMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ 
/*     */ public class MergeUtil
/*     */ {
/*     */   public static JBossMetaData merge(JBossMetaData jboss, EjbJarMetaData spec)
/*     */   {
/*  47 */     JBossMetaData merged = new JBossMetaData();
/*  48 */     merged.merge(jboss, spec);
/*  49 */     return merged;
/*     */   }
/*     */ 
/*     */   public static RemoteEnvironmentRefsGroupMetaData merge(RemoteEnvironmentRefsGroupMetaData jbossEnvironmentRefsGroup, RemoteEnvironment environmentRefsGroup, String overridenFile, String overrideFile, boolean mustOverride)
/*     */   {
/*  55 */     RemoteEnvironmentRefsGroupMetaData merged = new RemoteEnvironmentRefsGroupMetaData();
/*     */ 
/*  57 */     if ((jbossEnvironmentRefsGroup == null) && (environmentRefsGroup == null)) {
/*  58 */       return merged;
/*     */     }
/*  60 */     EnvironmentEntriesMetaData envEntries = null;
/*  61 */     EJBReferencesMetaData ejbRefs = null;
/*  62 */     EJBReferencesMetaData jbossEjbRefs = null;
/*  63 */     ServiceReferencesMetaData serviceRefs = null;
/*  64 */     ServiceReferencesMetaData jbossServiceRefs = null;
/*  65 */     ResourceReferencesMetaData resRefs = null;
/*  66 */     ResourceReferencesMetaData jbossResRefs = null;
/*  67 */     ResourceEnvironmentReferencesMetaData resEnvRefs = null;
/*  68 */     ResourceEnvironmentReferencesMetaData jbossResEnvRefs = null;
/*  69 */     MessageDestinationReferencesMetaData messageDestinationRefs = null;
/*  70 */     MessageDestinationReferencesMetaData jbossMessageDestinationRefs = null;
/*  71 */     PersistenceUnitReferencesMetaData persistenceUnitRefs = null;
/*  72 */     LifecycleCallbacksMetaData postConstructs = null;
/*  73 */     LifecycleCallbacksMetaData preDestroys = null;
/*     */ 
/*  75 */     if (environmentRefsGroup != null)
/*     */     {
/*  77 */       envEntries = environmentRefsGroup.getEnvironmentEntries();
/*  78 */       ejbRefs = environmentRefsGroup.getEjbReferences();
/*  79 */       serviceRefs = environmentRefsGroup.getServiceReferences();
/*  80 */       resRefs = environmentRefsGroup.getResourceReferences();
/*  81 */       resEnvRefs = environmentRefsGroup.getResourceEnvironmentReferences();
/*  82 */       messageDestinationRefs = environmentRefsGroup.getMessageDestinationReferences();
/*  83 */       persistenceUnitRefs = environmentRefsGroup.getPersistenceUnitRefs();
/*  84 */       postConstructs = environmentRefsGroup.getPostConstructs();
/*  85 */       preDestroys = environmentRefsGroup.getPreDestroys();
/*     */     }
/*     */ 
/*  88 */     if (jbossEnvironmentRefsGroup != null)
/*     */     {
/*  90 */       jbossEjbRefs = jbossEnvironmentRefsGroup.getEjbReferences();
/*  91 */       jbossServiceRefs = jbossEnvironmentRefsGroup.getServiceReferences();
/*  92 */       jbossResRefs = jbossEnvironmentRefsGroup.getResourceReferences();
/*  93 */       jbossResEnvRefs = jbossEnvironmentRefsGroup.getResourceEnvironmentReferences();
/*  94 */       jbossMessageDestinationRefs = jbossEnvironmentRefsGroup.getMessageDestinationReferences();
/*     */     }
/*     */ 
/*  97 */     EJBReferencesMetaData mergedEjbRefs = EJBReferencesMetaData.merge(jbossEjbRefs, ejbRefs, overridenFile, overrideFile, mustOverride);
/*  98 */     if (mergedEjbRefs != null) {
/*  99 */       merged.setEjbReferences(mergedEjbRefs);
/*     */     }
/* 101 */     ServiceReferencesMetaData mergedServiceRefs = ServiceReferencesMetaData.merge(jbossServiceRefs, serviceRefs, overridenFile, overrideFile);
/* 102 */     if (mergedServiceRefs != null) {
/* 103 */       merged.setServiceReferences(mergedServiceRefs);
/*     */     }
/* 105 */     ResourceReferencesMetaData mergedResRefs = ResourceReferencesMetaData.merge(jbossResRefs, resRefs, overridenFile, overrideFile, mustOverride);
/* 106 */     if (mergedResRefs != null) {
/* 107 */       merged.setResourceReferences(mergedResRefs);
/*     */     }
/* 109 */     ResourceEnvironmentReferencesMetaData mergedResEnvRefs = ResourceEnvironmentReferencesMetaData.merge(jbossResEnvRefs, resEnvRefs, overridenFile, overrideFile);
/* 110 */     if (mergedResEnvRefs != null) {
/* 111 */       merged.setResourceEnvironmentReferences(mergedResEnvRefs);
/*     */     }
/* 113 */     MessageDestinationReferencesMetaData mergedMessageDestinationRefs = MessageDestinationReferencesMetaData.merge(jbossMessageDestinationRefs, messageDestinationRefs, overridenFile, overrideFile, mustOverride);
/* 114 */     if (mergedMessageDestinationRefs != null) {
/* 115 */       merged.setMessageDestinationReferences(mergedMessageDestinationRefs);
/*     */     }
/* 117 */     if (envEntries != null) {
/* 118 */       merged.setEnvironmentEntries(envEntries);
/*     */     }
/* 120 */     if (persistenceUnitRefs != null) {
/* 121 */       merged.setPersistenceUnitRefs(persistenceUnitRefs);
/*     */     }
/* 123 */     if (postConstructs != null) {
/* 124 */       merged.setPostConstructs(postConstructs);
/*     */     }
/* 126 */     if (preDestroys != null) {
/* 127 */       merged.setPreDestroys(preDestroys);
/*     */     }
/* 129 */     return merged;
/*     */   }
/*     */ 
/*     */   public static <T> void merge(Collection<T> merged, Collection<T> override, Collection<T> original)
/*     */   {
/* 134 */     if (original != null)
/* 135 */       merged.addAll(original);
/* 136 */     if (override != null)
/* 137 */       merged.addAll(override);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.merge.MergeUtil
 * JD-Core Version:    0.6.0
 */