/*     */ package org.jboss.metadata.plugins.context;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import org.jboss.metadata.spi.context.MetaDataContext;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDatasItem;
/*     */ import org.jboss.metadata.spi.retrieval.ValidTime;
/*     */ import org.jboss.metadata.spi.retrieval.cummulative.CummulativeAnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.cummulative.CummulativeMetaDatasItem;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.scope.ScopeLevel;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ 
/*     */ public class AbstractMetaDataContext
/*     */   implements MetaDataContext
/*     */ {
/*     */   private List<MetaDataRetrieval> retrievals;
/*     */   private MetaDataContext parent;
/*     */   private volatile ScopeKey scopeKey;
/*     */ 
/*     */   public AbstractMetaDataContext(MetaDataRetrieval retrieval)
/*     */   {
/*  69 */     this(null, retrieval);
/*     */   }
/*     */ 
/*     */   public AbstractMetaDataContext(MetaDataContext parent, MetaDataRetrieval retrieval)
/*     */   {
/*  80 */     this(parent, Collections.singletonList(retrieval));
/*     */   }
/*     */ 
/*     */   public AbstractMetaDataContext(MetaDataContext parent, List<MetaDataRetrieval> retrievals)
/*     */   {
/*  91 */     if (retrievals == null)
/*  92 */       throw new IllegalArgumentException("Null retrievals");
/*  93 */     if (retrievals.isEmpty())
/*  94 */       throw new IllegalArgumentException("Must have at least one retrieval");
/*  95 */     for (MetaDataRetrieval retrieval : retrievals)
/*     */     {
/*  97 */       if (retrieval == null) {
/*  98 */         throw new IllegalArgumentException("Null retrieval");
/*     */       }
/*     */     }
/* 101 */     this.parent = parent;
/* 102 */     this.retrievals = retrievals;
/*     */   }
/*     */ 
/*     */   public ScopeKey getScope()
/*     */   {
/* 107 */     if (this.scopeKey == null)
/*     */     {
/* 109 */       ScopeKey key = new ScopeKey();
/* 110 */       for (MetaDataRetrieval retrieval : getRetrievals())
/*     */       {
/* 112 */         ScopeKey retrievalKey = retrieval.getScope();
/* 113 */         Collection scopes = retrievalKey.getScopes();
/* 114 */         for (Scope scope : scopes)
/* 115 */           key.addScope(scope);
/*     */       }
/* 117 */       this.scopeKey = key;
/*     */     }
/* 119 */     return this.scopeKey;
/*     */   }
/*     */ 
/*     */   public ValidTime getValidTime()
/*     */   {
/* 124 */     ValidTime result = null;
/* 125 */     long resultLong = -9223372036854775808L;
/*     */ 
/* 127 */     if (this.parent != null)
/*     */     {
/* 129 */       result = this.parent.getValidTime();
/* 130 */       resultLong = result.getValidTime();
/*     */     }
/*     */ 
/* 133 */     for (MetaDataRetrieval retrieval : this.retrievals)
/*     */     {
/* 135 */       ValidTime temp = retrieval.getValidTime();
/* 136 */       long tempLong = temp.getValidTime();
/* 137 */       if ((tempLong > resultLong) || (result == null))
/*     */       {
/* 139 */         result = temp;
/* 140 */         resultLong = tempLong;
/*     */       }
/*     */     }
/*     */ 
/* 144 */     return result;
/*     */   }
/*     */ 
/*     */   public MetaDataContext getParent()
/*     */   {
/* 149 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public List<MetaDataRetrieval> getRetrievals()
/*     */   {
/* 154 */     if (this.parent == null) {
/* 155 */       return this.retrievals;
/*     */     }
/* 157 */     List result = new ArrayList(this.retrievals);
/* 158 */     result.add(this.parent);
/* 159 */     return result;
/*     */   }
/*     */ 
/*     */   public List<MetaDataRetrieval> getLocalRetrievals()
/*     */   {
/* 164 */     return this.retrievals;
/*     */   }
/*     */ 
/*     */   public void append(MetaDataRetrieval retrieval)
/*     */   {
/* 169 */     if (retrieval == null) {
/* 170 */       throw new IllegalArgumentException("Null retrieval");
/*     */     }
/* 172 */     if (!(this.retrievals instanceof CopyOnWriteArrayList)) {
/* 173 */       this.retrievals = new CopyOnWriteArrayList(this.retrievals);
/*     */     }
/* 175 */     this.retrievals.add(retrieval);
/* 176 */     this.scopeKey = null;
/*     */   }
/*     */ 
/*     */   public void prepend(MetaDataRetrieval retrieval)
/*     */   {
/* 181 */     if (retrieval == null) {
/* 182 */       throw new IllegalArgumentException("Null retrieval");
/*     */     }
/* 184 */     if (!(this.retrievals instanceof CopyOnWriteArrayList)) {
/* 185 */       this.retrievals = new CopyOnWriteArrayList(this.retrievals);
/*     */     }
/* 187 */     this.retrievals.add(0, retrieval);
/* 188 */     this.scopeKey = null;
/*     */   }
/*     */ 
/*     */   public void remove(MetaDataRetrieval retrieval)
/*     */   {
/* 193 */     if (retrieval == null) {
/* 194 */       throw new IllegalArgumentException("Null retrieval");
/*     */     }
/* 196 */     if (this.retrievals.size() == 1) {
/* 197 */       throw new IllegalStateException("Must have at least one retrieval");
/*     */     }
/* 199 */     this.retrievals.remove(retrieval);
/* 200 */     this.scopeKey = null;
/*     */   }
/*     */ 
/*     */   public AnnotationsItem retrieveAnnotations()
/*     */   {
/* 205 */     return new CummulativeAnnotationsItem(this, true);
/*     */   }
/*     */ 
/*     */   public AnnotationsItem retrieveLocalAnnotations()
/*     */   {
/* 210 */     return new CummulativeAnnotationsItem(this, false);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType)
/*     */   {
/* 215 */     for (MetaDataRetrieval retrieval : this.retrievals)
/*     */     {
/* 217 */       AnnotationItem item = retrieval.retrieveAnnotation(annotationType);
/* 218 */       if (item != null) {
/* 219 */         return item;
/*     */       }
/*     */     }
/* 222 */     if (this.parent != null) {
/* 223 */       return this.parent.retrieveAnnotation(annotationType);
/*     */     }
/* 225 */     return null;
/*     */   }
/*     */ 
/*     */   public MetaDatasItem retrieveMetaData()
/*     */   {
/* 230 */     return new CummulativeMetaDatasItem(this, true);
/*     */   }
/*     */ 
/*     */   public MetaDatasItem retrieveLocalMetaData()
/*     */   {
/* 235 */     return new CummulativeMetaDatasItem(this, false);
/*     */   }
/*     */ 
/*     */   public <T> MetaDataItem<T> retrieveMetaData(Class<T> type)
/*     */   {
/* 240 */     for (MetaDataRetrieval retrieval : this.retrievals)
/*     */     {
/* 242 */       MetaDataItem item = retrieval.retrieveMetaData(type);
/* 243 */       if (item != null) {
/* 244 */         return item;
/*     */       }
/*     */     }
/* 247 */     if (this.parent != null) {
/* 248 */       return this.parent.retrieveMetaData(type);
/*     */     }
/* 250 */     return null;
/*     */   }
/*     */ 
/*     */   public MetaDataItem retrieveMetaData(String name)
/*     */   {
/* 255 */     for (MetaDataRetrieval retrieval : this.retrievals)
/*     */     {
/* 257 */       MetaDataItem item = retrieval.retrieveMetaData(name);
/* 258 */       if (item != null) {
/* 259 */         return item;
/*     */       }
/*     */     }
/* 262 */     if (this.parent != null) {
/* 263 */       return this.parent.retrieveMetaData(name);
/*     */     }
/* 265 */     return null;
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature)
/*     */   {
/* 270 */     if (signature == null) {
/* 271 */       return null;
/*     */     }
/* 273 */     List componentRetrievals = null;
/* 274 */     for (MetaDataRetrieval retrieval : this.retrievals)
/*     */     {
/* 276 */       retrieval = retrieval.getComponentMetaDataRetrieval(signature);
/* 277 */       if (retrieval != null)
/*     */       {
/* 279 */         if (componentRetrievals == null)
/* 280 */           componentRetrievals = new ArrayList();
/* 281 */         componentRetrievals.add(retrieval);
/*     */       }
/*     */     }
/*     */ 
/* 285 */     MetaDataContext parentComponent = null;
/* 286 */     if (this.parent != null) {
/* 287 */       parentComponent = (MetaDataContext)this.parent.getComponentMetaDataRetrieval(signature);
/*     */     }
/* 289 */     if (componentRetrievals == null) {
/* 290 */       return parentComponent;
/*     */     }
/* 292 */     return new AbstractMetaDataContext(parentComponent, componentRetrievals);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 297 */     for (MetaDataRetrieval retrieval : this.retrievals)
/*     */     {
/* 299 */       if (!retrieval.isEmpty())
/* 300 */         return false;
/*     */     }
/* 302 */     return (this.parent == null) || (this.parent.isEmpty());
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval getScopedRetrieval(ScopeLevel level)
/*     */   {
/* 307 */     List matchingRetrievals = new ArrayList();
/* 308 */     List localRetrievals = getLocalRetrievals();
/* 309 */     for (MetaDataRetrieval localRetrieval : localRetrievals)
/*     */     {
/* 311 */       ScopeKey scopeKey = localRetrieval.getScope();
/* 312 */       if (scopeKey.getScopeLevel(level) != null) {
/* 313 */         matchingRetrievals.add(localRetrieval);
/*     */       }
/*     */     }
/* 316 */     if (!matchingRetrievals.isEmpty())
/*     */     {
/* 318 */       if (matchingRetrievals.size() > 1) {
/* 319 */         return new AbstractMetaDataContext(null, matchingRetrievals);
/*     */       }
/* 321 */       return (MetaDataRetrieval)matchingRetrievals.get(0);
/*     */     }
/*     */ 
/* 324 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.context.AbstractMetaDataContext
 * JD-Core Version:    0.6.0
 */