/*     */ package org.jboss.metadata.plugins.loader;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.Member;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.metadata.spi.ComponentMutableMetaData;
/*     */ import org.jboss.metadata.spi.MutableMetaData;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ import org.jboss.reflect.spi.MemberInfo;
/*     */ 
/*     */ public abstract class AbstractMutableComponentMetaDataLoader extends AbstractMutableMetaDataLoader
/*     */   implements ComponentMutableMetaData
/*     */ {
/*     */   private volatile Map<Signature, MetaDataRetrieval> components;
/*     */ 
/*     */   public AbstractMutableComponentMetaDataLoader()
/*     */   {
/*  52 */     this(false);
/*     */   }
/*     */ 
/*     */   public AbstractMutableComponentMetaDataLoader(boolean restricted)
/*     */   {
/*  62 */     super(restricted);
/*     */   }
/*     */ 
/*     */   public AbstractMutableComponentMetaDataLoader(ScopeKey key)
/*     */   {
/*  72 */     this(key, false);
/*     */   }
/*     */ 
/*     */   public AbstractMutableComponentMetaDataLoader(ScopeKey key, boolean restricted)
/*     */   {
/*  83 */     super(key, restricted);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/*  88 */     return isNullOrEmpty(this.components);
/*     */   }
/*     */ 
/*     */   protected static boolean isNullOrEmpty(Map map)
/*     */   {
/* 100 */     return (map == null) || (map.isEmpty());
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval addComponentMetaDataRetrieval(Signature signature, MetaDataRetrieval component)
/*     */   {
/* 105 */     if (signature == null) {
/* 106 */       throw new IllegalArgumentException("Null signature");
/*     */     }
/* 108 */     if (this.components == null) {
/* 109 */       this.components = new ConcurrentHashMap();
/*     */     }
/* 111 */     return (MetaDataRetrieval)this.components.put(signature, component);
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval removeComponentMetaDataRetrieval(Signature signature)
/*     */   {
/* 116 */     if (signature == null) {
/* 117 */       throw new IllegalArgumentException("Null signature");
/*     */     }
/* 119 */     if (this.components == null) {
/* 120 */       return null;
/*     */     }
/* 122 */     return (MetaDataRetrieval)this.components.remove(signature);
/*     */   }
/*     */ 
/*     */   public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature)
/*     */   {
/* 127 */     if (this.components == null) {
/* 128 */       return null;
/*     */     }
/* 130 */     return (MetaDataRetrieval)this.components.get(signature);
/*     */   }
/*     */ 
/*     */   protected MutableMetaData initRetrieval(Signature signature)
/*     */   {
/* 141 */     MetaDataRetrieval result = getComponentMetaDataRetrieval(signature);
/* 142 */     if (result == null)
/*     */     {
/* 144 */       result = initComponentRetrieval(signature);
/* 145 */       addComponentMetaDataRetrieval(signature, result);
/*     */     }
/* 147 */     if (!(result instanceof MutableMetaData))
/* 148 */       throw new IllegalStateException("Component is not mutable: " + signature);
/* 149 */     return (MutableMetaData)result;
/*     */   }
/*     */ 
/*     */   protected abstract MetaDataRetrieval initComponentRetrieval(Signature paramSignature);
/*     */ 
/*     */   public <T extends Annotation> T addAnnotation(Signature signature, T annotation)
/*     */   {
/* 162 */     MutableMetaData component = initRetrieval(signature);
/* 163 */     return component.addAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(Signature signature, String name, T metaData, Class<T> type)
/*     */   {
/* 168 */     MutableMetaData component = initRetrieval(signature);
/* 169 */     return component.addMetaData(name, metaData, type);
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(Signature signature, T metaData, Class<T> type)
/*     */   {
/* 174 */     MutableMetaData component = initRetrieval(signature);
/* 175 */     return component.addMetaData(metaData, type);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T removeAnnotation(Signature signature, Class<T> annotationType)
/*     */   {
/* 180 */     MutableMetaData component = initRetrieval(signature);
/* 181 */     return component.removeAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(Signature signature, Class<T> type)
/*     */   {
/* 186 */     MutableMetaData component = initRetrieval(signature);
/* 187 */     return component.removeMetaData(type);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(Signature signature, String name, Class<T> type)
/*     */   {
/* 192 */     MutableMetaData component = initRetrieval(signature);
/* 193 */     return component.removeMetaData(name, type);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T addAnnotation(Member member, T annotation)
/*     */   {
/* 198 */     return addAnnotation(Signature.getSignature(member), annotation);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T addAnnotation(MemberInfo member, T annotation)
/*     */   {
/* 203 */     return addAnnotation(Signature.getSignature(member), annotation);
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(Member member, String name, T metaData, Class<T> type)
/*     */   {
/* 208 */     return addMetaData(Signature.getSignature(member), name, metaData, type);
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(Member member, T metaData, Class<T> type)
/*     */   {
/* 213 */     return addMetaData(Signature.getSignature(member), metaData, type);
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(MemberInfo member, String name, T metaData, Class<T> type)
/*     */   {
/* 218 */     return addMetaData(Signature.getSignature(member), name, metaData, type);
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(MemberInfo member, T metaData, Class<T> type)
/*     */   {
/* 223 */     return addMetaData(Signature.getSignature(member), metaData, type);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T removeAnnotation(Member member, Class<T> annotationType)
/*     */   {
/* 228 */     return removeAnnotation(Signature.getSignature(member), annotationType);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T removeAnnotation(MemberInfo member, Class<T> annotationType)
/*     */   {
/* 233 */     return removeAnnotation(Signature.getSignature(member), annotationType);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(Member member, Class<T> type)
/*     */   {
/* 238 */     return removeMetaData(Signature.getSignature(member), type);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(Member member, String name, Class<T> type)
/*     */   {
/* 243 */     return removeMetaData(Signature.getSignature(member), name, type);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(MemberInfo member, Class<T> type)
/*     */   {
/* 248 */     return removeMetaData(Signature.getSignature(member), type);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(MemberInfo member, String name, Class<T> type)
/*     */   {
/* 253 */     return removeMetaData(Signature.getSignature(member), name, type);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.loader.AbstractMutableComponentMetaDataLoader
 * JD-Core Version:    0.6.0
 */