/*     */ package org.jboss.metadata.plugins.loader;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import org.jboss.metadata.spi.Restricted;
/*     */ import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public abstract class AbstractMutableMetaDataLoader extends BasicMetaDataLoader
/*     */   implements MutableMetaDataLoader
/*     */ {
/*     */   private final boolean restricted;
/*     */ 
/*     */   public AbstractMutableMetaDataLoader()
/*     */   {
/*  50 */     this(false);
/*     */   }
/*     */ 
/*     */   public AbstractMutableMetaDataLoader(boolean restricted)
/*     */   {
/*  60 */     this.restricted = restricted;
/*     */   }
/*     */ 
/*     */   public AbstractMutableMetaDataLoader(ScopeKey key)
/*     */   {
/*  70 */     this(key, false);
/*     */   }
/*     */ 
/*     */   public AbstractMutableMetaDataLoader(ScopeKey key, boolean restricted)
/*     */   {
/*  81 */     super(key);
/*  82 */     this.restricted = restricted;
/*     */   }
/*     */ 
/*     */   public void checkRestricted(Annotation annotation)
/*     */   {
/*  92 */     if (this.restricted)
/*     */     {
/*  94 */       Class annotationType = annotation.annotationType();
/*  95 */       if (annotationType.isAnnotationPresent(Restricted.class))
/*  96 */         throw new SecurityException("Context is restricted, not allowed to add " + annotationType.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void checkRestricted(Class<?> type)
/*     */   {
/* 107 */     if ((this.restricted) && (type.isAnnotationPresent(Restricted.class)))
/* 108 */       throw new SecurityException("Context is restricted, not allowed to add " + type.getName());
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(T metaData, Class<T> type)
/*     */   {
/* 114 */     if (metaData == null)
/* 115 */       throw new IllegalArgumentException("Null metaData");
/* 116 */     if (type == null)
/* 117 */       throw new IllegalArgumentException("Null type");
/* 118 */     if (!type.isAnnotation()) {
/* 119 */       throw new IllegalArgumentException("Only annotation types are supported: " + type.getClass().getName());
/*     */     }
/* 121 */     Annotation annotation = (Annotation)metaData;
/* 122 */     return addAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(Class<T> type)
/*     */   {
/* 128 */     if (type == null)
/* 129 */       throw new IllegalArgumentException("Null type");
/* 130 */     if (!type.isAnnotation()) {
/* 131 */       throw new IllegalArgumentException("Only annotation types are supported: " + type.getName());
/*     */     }
/* 133 */     return removeAnnotation(type);
/*     */   }
/*     */ 
/*     */   public <T> T addMetaData(String name, T metaData, Class<T> type)
/*     */   {
/* 138 */     return addMetaData(metaData, type);
/*     */   }
/*     */ 
/*     */   public <T> T removeMetaData(String name, Class<T> type)
/*     */   {
/* 143 */     return removeMetaData(type);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.plugins.loader.AbstractMutableMetaDataLoader
 * JD-Core Version:    0.6.0
 */