/*     */ package org.jboss.metadata.spi.retrieval.cummulative;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.metadata.spi.context.MetaDataContext;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationItem;
/*     */ import org.jboss.metadata.spi.retrieval.AnnotationsItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.ValidTime;
/*     */ import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;
/*     */ 
/*     */ public class CummulativeAnnotationsItem extends SimpleAnnotationsItem
/*     */ {
/*     */   private MetaDataContext context;
/*     */   private boolean includeParent;
/*     */   private long validTime;
/*     */ 
/*     */   public CummulativeAnnotationsItem(MetaDataContext context, boolean includeParent)
/*     */   {
/*  60 */     if (context == null) {
/*  61 */       throw new IllegalArgumentException("Null context");
/*     */     }
/*  63 */     this.context = context;
/*  64 */     this.includeParent = includeParent;
/*  65 */     init(context.getValidTime().getValidTime());
/*     */   }
/*     */ 
/*     */   public Annotation[] getValue()
/*     */   {
/*  70 */     checkValid();
/*  71 */     return super.getValue();
/*     */   }
/*     */ 
/*     */   public AnnotationItem[] getAnnotations()
/*     */   {
/*  76 */     checkValid();
/*  77 */     return super.getAnnotations();
/*     */   }
/*     */ 
/*     */   public boolean isCachable()
/*     */   {
/*  82 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isValid()
/*     */   {
/*  87 */     return true;
/*     */   }
/*     */ 
/*     */   protected void checkValid()
/*     */   {
/*  95 */     AnnotationItem[] items = super.getAnnotations();
/*  96 */     boolean valid = items != null;
/*     */ 
/*  98 */     long newValidTime = this.context.getValidTime().getValidTime();
/*  99 */     if (this.validTime < newValidTime) {
/* 100 */       valid = false;
/*     */     }
/* 102 */     if ((valid) && (items != null))
/*     */     {
/* 104 */       for (AnnotationItem item : items)
/*     */       {
/* 106 */         if (!item.isValid()) {
/* 107 */           valid = false;
/*     */         }
/*     */       }
/*     */     }
/* 111 */     if (!valid)
/* 112 */       init(newValidTime);
/*     */   }
/*     */ 
/*     */   protected void init(long validTime)
/*     */   {
/* 122 */     Set temp = null;
/*     */     List retrievals;
/*     */     List retrievals;
/* 126 */     if (this.includeParent)
/* 127 */       retrievals = this.context.getRetrievals();
/*     */     else {
/* 129 */       retrievals = this.context.getLocalRetrievals();
/*     */     }
/* 131 */     for (MetaDataRetrieval retrieval : retrievals)
/*     */     {
/* 133 */       AnnotationsItem item = retrieval.retrieveAnnotations();
/* 134 */       if (item != null)
/*     */       {
/* 136 */         AnnotationItem[] items = item.getAnnotations();
/* 137 */         for (AnnotationItem it : items)
/*     */         {
/* 139 */           if (temp == null)
/* 140 */             temp = new HashSet();
/* 141 */           temp.add(it);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 146 */     AnnotationItem[] items = NO_ANNOTATION_ITEMS;
/* 147 */     if (temp != null)
/* 148 */       items = (AnnotationItem[])temp.toArray(new AnnotationItem[temp.size()]);
/* 149 */     setAnnotationItems(items);
/* 150 */     this.validTime = validTime;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.retrieval.cummulative.CummulativeAnnotationsItem
 * JD-Core Version:    0.6.0
 */