/*    */ package org.jboss.metadata.spi.scope;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ 
/*    */ public class Scope
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 5255750644324593361L;
/*    */   private final ScopeLevel level;
/*    */   private final Object qualifier;
/*    */ 
/*    */   public Scope(ScopeLevel level, Object qualifier)
/*    */   {
/* 45 */     if (level == null)
/* 46 */       throw new IllegalArgumentException("Null level");
/* 47 */     if (qualifier == null) {
/* 48 */       throw new IllegalArgumentException("Null qualifier");
/*    */     }
/* 50 */     this.level = level;
/* 51 */     this.qualifier = qualifier;
/*    */   }
/*    */ 
/*    */   public ScopeLevel getScopeLevel()
/*    */   {
/* 56 */     return this.level;
/*    */   }
/*    */ 
/*    */   public Object getQualifier()
/*    */   {
/* 61 */     return this.qualifier;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 66 */     return this.level.getName() + "=" + this.qualifier;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object object)
/*    */   {
/* 71 */     if (object == this)
/* 72 */       return true;
/* 73 */     if ((object == null) || (!(object instanceof Scope))) {
/* 74 */       return false;
/*    */     }
/* 76 */     Scope other = (Scope)object;
/* 77 */     if (this.level.compareTo(other.getScopeLevel()) != 0) {
/* 78 */       return false;
/*    */     }
/* 80 */     return this.qualifier.equals(other.qualifier);
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 85 */     return this.level.hashCode();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.scope.Scope
 * JD-Core Version:    0.6.0
 */