/*     */ package org.jboss.metadata.spi.scope;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.SortedMap;
/*     */ import java.util.TreeMap;
/*     */ 
/*     */ public class ScopeKey
/*     */   implements Serializable, Cloneable
/*     */ {
/*     */   private static final long serialVersionUID = -496238095349593371L;
/*  43 */   public static ScopeKey DEFAULT_SCOPE = new ScopeKey(new Scope(CommonLevels.JVM, "THIS"));
/*     */ 
/*  46 */   private SortedMap<ScopeLevel, Scope> scopes = Collections.synchronizedSortedMap(new TreeMap());
/*     */   private ScopeLevel maxScopeLevel;
/*     */   private volatile boolean frozen;
/*     */ 
/*     */   public ScopeKey()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ScopeKey(Scope scope)
/*     */   {
/*  73 */     addScope(scope);
/*     */   }
/*     */ 
/*     */   public ScopeKey(ScopeLevel level, Object qualifier)
/*     */   {
/*  84 */     addScope(level, qualifier);
/*     */   }
/*     */ 
/*     */   public ScopeKey(Collection<Scope> scopes)
/*     */   {
/*  94 */     if (scopes == null)
/*  95 */       throw new IllegalArgumentException("Null scopes");
/*  96 */     for (Scope scope : scopes)
/*  97 */       addScope(scope);
/*     */   }
/*     */ 
/*     */   public ScopeKey(Scope[] scopes)
/*     */   {
/* 107 */     if (scopes == null)
/* 108 */       throw new IllegalArgumentException("Null scopes");
/* 109 */     for (Scope scope : scopes)
/* 110 */       addScope(scope);
/*     */   }
/*     */ 
/*     */   public boolean isFrozen()
/*     */   {
/* 120 */     return this.frozen;
/*     */   }
/*     */ 
/*     */   public void freeze()
/*     */   {
/* 128 */     if (this.scopes.isEmpty())
/* 129 */       throw new IllegalStateException("Attempt to freeze an empty key");
/* 130 */     this.frozen = true;
/*     */   }
/*     */ 
/*     */   public Collection<Scope> getScopes()
/*     */   {
/* 140 */     return Collections.unmodifiableCollection(this.scopes.values());
/*     */   }
/*     */ 
/*     */   public Scope getScope(ScopeLevel level)
/*     */   {
/* 151 */     if (level == null)
/* 152 */       throw new IllegalArgumentException("Null level");
/* 153 */     return (Scope)this.scopes.get(level);
/*     */   }
/*     */ 
/*     */   public ScopeLevel getMaxScopeLevel()
/*     */   {
/* 163 */     return this.maxScopeLevel;
/*     */   }
/*     */ 
/*     */   public ScopeKey getParent()
/*     */   {
/* 173 */     if (this.scopes.size() < 2) {
/* 174 */       return null;
/*     */     }
/* 176 */     ScopeKey result = new ScopeKey();
/* 177 */     for (Iterator i = this.scopes.values().iterator(); i.hasNext(); )
/*     */     {
/* 179 */       Scope scope = (Scope)i.next();
/* 180 */       if (i.hasNext())
/* 181 */         result.addScope(scope);
/*     */     }
/* 183 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean isParent(ScopeKey key)
/*     */   {
/* 189 */     if (key.scopes.size() < 2) {
/* 190 */       return false;
/*     */     }
/*     */ 
/* 193 */     if (this.scopes.size() != key.scopes.size() - 1) {
/* 194 */       return false;
/*     */     }
/* 196 */     Iterator thisScopes = this.scopes.values().iterator();
/* 197 */     Iterator keyScopes = key.scopes.values().iterator();
/*     */ 
/* 199 */     while (thisScopes.hasNext())
/*     */     {
/* 201 */       Scope thisScope = (Scope)thisScopes.next();
/* 202 */       Scope keyScope = (Scope)keyScopes.next();
/* 203 */       if (!thisScope.equals(keyScope)) {
/* 204 */         return false;
/*     */       }
/*     */     }
/* 207 */     return true;
/*     */   }
/*     */ 
/*     */   public Scope addScope(Scope scope)
/*     */   {
/* 218 */     if (scope == null)
/* 219 */       throw new IllegalArgumentException("Null scope");
/* 220 */     if (this.frozen) {
/* 221 */       throw new IllegalStateException("The scope key is frozen");
/*     */     }
/* 223 */     ScopeLevel level = scope.getScopeLevel();
/* 224 */     Scope result = (Scope)this.scopes.put(level, scope);
/* 225 */     if ((this.maxScopeLevel == null) || (level.compareTo(this.maxScopeLevel) >= 0))
/* 226 */       this.maxScopeLevel = level;
/* 227 */     return result;
/*     */   }
/*     */ 
/*     */   public Scope addScope(ScopeLevel level, Object qualifier)
/*     */   {
/* 239 */     Scope scope = new Scope(level, qualifier);
/* 240 */     return addScope(scope);
/*     */   }
/*     */ 
/*     */   public Scope removeScope(Scope scope)
/*     */   {
/* 251 */     if (scope == null) {
/* 252 */       throw new IllegalArgumentException("Null scope");
/*     */     }
/* 254 */     return removeScopeLevel(scope.getScopeLevel());
/*     */   }
/*     */ 
/*     */   public Scope getScopeLevel(ScopeLevel scopeLevel)
/*     */   {
/* 265 */     if (scopeLevel == null) {
/* 266 */       throw new IllegalArgumentException("Null scope level");
/*     */     }
/* 268 */     return (Scope)this.scopes.get(scopeLevel);
/*     */   }
/*     */ 
/*     */   public Scope removeScopeLevel(ScopeLevel scopeLevel)
/*     */   {
/* 279 */     if (scopeLevel == null)
/* 280 */       throw new IllegalArgumentException("Null scope level");
/* 281 */     if (this.frozen) {
/* 282 */       throw new IllegalStateException("The scope key is frozen");
/*     */     }
/* 284 */     Scope result = (Scope)this.scopes.remove(scopeLevel);
/* 285 */     if (scopeLevel.equals(this.maxScopeLevel))
/*     */     {
/* 287 */       this.maxScopeLevel = null;
/* 288 */       for (ScopeLevel level : this.scopes.keySet())
/* 289 */         this.maxScopeLevel = level;
/*     */     }
/* 291 */     return result;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 296 */     return this.scopes.values().toString();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 301 */     if (object == this)
/* 302 */       return true;
/* 303 */     if ((object == null) || (!(object instanceof ScopeKey))) {
/* 304 */       return false;
/*     */     }
/* 306 */     ScopeKey other = (ScopeKey)object;
/* 307 */     return this.scopes.equals(other.scopes);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 312 */     return this.scopes.hashCode();
/*     */   }
/*     */ 
/*     */   public ScopeKey clone()
/*     */   {
/*     */     try
/*     */     {
/* 319 */       ScopeKey result = (ScopeKey)super.clone();
/* 320 */       result.scopes = Collections.synchronizedSortedMap(new TreeMap(this.scopes));
/* 321 */       result.frozen = false;
/* 322 */       return result;
/*     */     }
/*     */     catch (CloneNotSupportedException e) {
/*     */     }
/* 326 */     throw new Error(e);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  56 */     DEFAULT_SCOPE.freeze();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.scope.ScopeKey
 * JD-Core Version:    0.6.0
 */