/*     */ package org.jboss.metadata.spi.signature;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ 
/*     */ public class MethodParametersSignature extends Signature
/*     */ {
/*     */   private int param;
/*     */ 
/*     */   public MethodParametersSignature(String name, String[] parameters, int param)
/*     */   {
/*  46 */     super(name, parameters);
/*  47 */     this.param = param;
/*  48 */     checkParam();
/*     */   }
/*     */ 
/*     */   public MethodParametersSignature(String name, int param, Class<?>[] parameters)
/*     */   {
/*  60 */     super(name, parameters);
/*  61 */     this.param = param;
/*  62 */     checkParam();
/*     */   }
/*     */ 
/*     */   public MethodParametersSignature(Method method, int param)
/*     */   {
/*  73 */     super(method.getName(), method.getParameterTypes());
/*  74 */     this.param = param;
/*  75 */     checkParam();
/*     */   }
/*     */ 
/*     */   public int getParam()
/*     */   {
/*  85 */     return this.param;
/*     */   }
/*     */ 
/*     */   protected void checkParam()
/*     */   {
/*  93 */     if ((this.param < 0) || (this.param >= getParameters().length))
/*  94 */       throw new IllegalArgumentException("param must be between 0 and " + getParameters().length);
/*     */   }
/*     */ 
/*     */   protected void internalToString(StringBuilder builder)
/*     */   {
/*  99 */     super.internalToString(builder);
/* 100 */     builder.append("#").append(this.param);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.spi.signature.MethodParametersSignature
 * JD-Core Version:    0.6.0
 */