/*      */ package org.jboss.metadata.web.jboss;
/*      */ 
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javax.xml.bind.annotation.XmlElement;
/*      */ import javax.xml.bind.annotation.XmlTransient;
/*      */ import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossEnvironmentRefsGroupMetaData;
/*      */ import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EmptyMetaData;
/*      */ import org.jboss.metadata.javaee.spec.Environment;
/*      */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*      */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ParamValueMetaData;
/*      */ import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.RunAsMetaData;
/*      */ import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
/*      */ import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
/*      */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
/*      */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;
/*      */ import org.jboss.metadata.web.spec.ErrorPageMetaData;
/*      */ import org.jboss.metadata.web.spec.FilterMappingMetaData;
/*      */ import org.jboss.metadata.web.spec.FiltersMetaData;
/*      */ import org.jboss.metadata.web.spec.JspConfigMetaData;
/*      */ import org.jboss.metadata.web.spec.ListenerMetaData;
/*      */ import org.jboss.metadata.web.spec.LocaleEncodingsMetaData;
/*      */ import org.jboss.metadata.web.spec.LoginConfigMetaData;
/*      */ import org.jboss.metadata.web.spec.MimeMappingMetaData;
/*      */ import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
/*      */ import org.jboss.metadata.web.spec.ServletMappingMetaData;
/*      */ import org.jboss.metadata.web.spec.ServletMetaData;
/*      */ import org.jboss.metadata.web.spec.ServletsMetaData;
/*      */ import org.jboss.metadata.web.spec.SessionConfigMetaData;
/*      */ import org.jboss.metadata.web.spec.Web25MetaData;
/*      */ import org.jboss.metadata.web.spec.WebMetaData;
/*      */ import org.jboss.metadata.web.spec.WelcomeFileListMetaData;
/*      */ 
/*      */ public class JBossWebMetaData extends IdMetaDataImplWithDescriptionGroup
/*      */ {
/*      */   private static final long serialVersionUID = 1L;
/*      */   private String servletVersion;
/*      */   private EmptyMetaData distributable;
/*      */   private boolean metadataComplete;
/*      */   private List<ParamValueMetaData> contextParams;
/*      */   private SessionConfigMetaData sessionConfig;
/*      */   private FiltersMetaData filters;
/*      */   private List<FilterMappingMetaData> filterMappings;
/*      */   private List<ErrorPageMetaData> errorPages;
/*      */   private JspConfigMetaData jspConfig;
/*      */   private List<ListenerMetaData> listeners;
/*      */   private LoginConfigMetaData loginConfig;
/*      */   private List<MimeMappingMetaData> mimeMappings;
/*      */   private List<ServletMappingMetaData> servletMappings;
/*      */   private List<SecurityConstraintMetaData> securityContraints;
/*      */   private WelcomeFileListMetaData welcomeFileList;
/*      */   private LocaleEncodingsMetaData localEncodings;
/*      */   private String dtdPublicId;
/*      */   private String dtdSystemId;
/*      */   private String version;
/*      */   private String contextRoot;
/*      */   private String alternativeDD;
/*      */   private String securityDomain;
/*      */   private String jaccContextID;
/*      */   private ClassLoadingMetaData classLoading;
/*      */   private List<String> depends;
/*  124 */   private Map<String, RunAsIdentityMetaData> runAsIdentity = new HashMap();
/*  125 */   private SecurityRolesMetaData securityRoles = new SecurityRolesMetaData();
/*      */ 
/*  127 */   private JBossServletsMetaData servlets = new JBossServletsMetaData();
/*      */ 
/*  129 */   private MessageDestinationsMetaData messageDestinations = new MessageDestinationsMetaData();
/*      */   private JBossEnvironmentRefsGroupMetaData jndiEnvironmentRefsGroup;
/*      */   private List<String> virtualHosts;
/*      */   private boolean flushOnSessionInvalidation;
/*      */   private boolean useSessionCookies;
/*      */   private ReplicationConfig replicationConfig;
/*      */   private PassivationConfig passivationConfig;
/*  138 */   private WebserviceDescriptionsMetaData webserviceDescriptions = new WebserviceDescriptionsMetaData();
/*      */ 
/*      */   @Deprecated
/*      */   private transient ClassLoader encLoader;
/*      */ 
/*      */   @Deprecated
/*      */   private transient ClassLoader cxtLoader;
/*  150 */   private HashMap arbitraryMetadata = new HashMap();
/*      */ 
/*  155 */   private Integer maxActiveSessions = null;
/*      */ 
/*  158 */   private int sessionCookies = 0;
/*      */   public static final int SESSION_COOKIES_DEFAULT = 0;
/*      */   public static final int SESSION_COOKIES_ENABLED = 1;
/*      */   public static final int SESSION_COOKIES_DISABLED = 2;
/*      */ 
/*      */   @XmlTransient
/*      */   public void setDTD(String root, String publicId, String systemId)
/*      */   {
/*  173 */     this.dtdPublicId = publicId;
/*  174 */     this.dtdSystemId = systemId;
/*      */ 
/*  176 */     if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("3.0")))
/*  177 */       setVersion("3.0");
/*  178 */     else if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("3.2")))
/*  179 */       setVersion("3.2");
/*  180 */     else if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("2.4")))
/*  181 */       setVersion("4.0");
/*  182 */     else if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("4.2")))
/*  183 */       setVersion("4.2");
/*  184 */     else if ((this.dtdPublicId != null) && (this.dtdPublicId.contains("5.0")))
/*  185 */       setVersion("5.0");
/*  186 */     else if ((this.dtdSystemId != null) && (this.dtdSystemId.contains("3_0")))
/*  187 */       setVersion("3.0");
/*  188 */     else if ((this.dtdSystemId != null) && (this.dtdSystemId.contains("3_2")))
/*  189 */       setVersion("3.2");
/*  190 */     else if ((this.dtdSystemId != null) && (this.dtdSystemId.contains("4_0")))
/*  191 */       setVersion("4.0");
/*  192 */     else if ((this.dtdSystemId != null) && (this.dtdSystemId.contains("4_2")))
/*  193 */       setVersion("4.2");
/*  194 */     else if ((this.dtdSystemId != null) && (this.dtdSystemId.contains("5_0")))
/*  195 */       setVersion("5.0");
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public String getDtdPublicId()
/*      */   {
/*  204 */     return this.dtdPublicId;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public String getDtdSystemId()
/*      */   {
/*  213 */     return this.dtdSystemId;
/*      */   }
/*      */ 
/*      */   public String getVersion()
/*      */   {
/*  218 */     return this.version;
/*      */   }
/*      */ 
/*      */   public void setVersion(String version) {
/*  222 */     this.version = version;
/*      */   }
/*      */ 
/*      */   public String getServletVersion() {
/*  226 */     return this.servletVersion;
/*      */   }
/*      */ 
/*      */   public void setServletVersion(String servletVersion) {
/*  230 */     this.servletVersion = servletVersion;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public boolean is23()
/*      */   {
/*  241 */     return (this.servletVersion != null) && (this.servletVersion.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN"));
/*      */   }
/*      */   @XmlTransient
/*      */   public boolean is24() {
/*  246 */     return (this.servletVersion != null) && (this.servletVersion.equals("2.4"));
/*      */   }
/*      */   @XmlTransient
/*      */   public boolean is25() {
/*  251 */     return (this.servletVersion != null) && (this.servletVersion.equals("2.5"));
/*      */   }
/*      */ 
/*      */   public boolean isMetadataComplete()
/*      */   {
/*  257 */     return this.metadataComplete;
/*      */   }
/*      */ 
/*      */   public void setMetadataComplete(boolean metadataComplete) {
/*  261 */     this.metadataComplete = metadataComplete;
/*      */   }
/*      */ 
/*      */   public EmptyMetaData getDistributable()
/*      */   {
/*  266 */     return this.distributable;
/*      */   }
/*      */ 
/*      */   public void setDistributable(EmptyMetaData distributable) {
/*  270 */     this.distributable = distributable;
/*      */   }
/*      */ 
/*      */   public SessionConfigMetaData getSessionConfig() {
/*  274 */     return this.sessionConfig;
/*      */   }
/*      */ 
/*      */   public void setSessionConfig(SessionConfigMetaData sessionConfig) {
/*  278 */     this.sessionConfig = sessionConfig;
/*      */   }
/*      */ 
/*      */   public List<ParamValueMetaData> getContextParams() {
/*  282 */     return this.contextParams;
/*      */   }
/*      */   @XmlElement(name="context-param")
/*      */   public void setContextParams(List<ParamValueMetaData> params) {
/*  287 */     this.contextParams = params;
/*      */   }
/*      */ 
/*      */   public FiltersMetaData getFilters()
/*      */   {
/*  292 */     return this.filters;
/*      */   }
/*      */   @XmlElement(name="filter")
/*      */   public void setFilters(FiltersMetaData filters) {
/*  297 */     this.filters = filters;
/*      */   }
/*      */ 
/*      */   public List<FilterMappingMetaData> getFilterMappings()
/*      */   {
/*  302 */     return this.filterMappings;
/*      */   }
/*      */   @XmlElement(name="filter-mapping")
/*      */   public void setFilterMappings(List<FilterMappingMetaData> filterMappings) {
/*  307 */     this.filterMappings = filterMappings;
/*      */   }
/*      */ 
/*      */   public List<ErrorPageMetaData> getErrorPages()
/*      */   {
/*  312 */     return this.errorPages;
/*      */   }
/*      */   @XmlElement(name="error-page")
/*      */   public void setErrorPages(List<ErrorPageMetaData> errorPages) {
/*  317 */     this.errorPages = errorPages;
/*      */   }
/*      */ 
/*      */   public JspConfigMetaData getJspConfig()
/*      */   {
/*  322 */     return this.jspConfig;
/*      */   }
/*      */ 
/*      */   public void setJspConfig(JspConfigMetaData jspConfig) {
/*  326 */     this.jspConfig = jspConfig;
/*      */   }
/*      */ 
/*      */   public List<ListenerMetaData> getListeners()
/*      */   {
/*  331 */     return this.listeners;
/*      */   }
/*      */   @XmlElement(name="listener")
/*      */   public void setListeners(List<ListenerMetaData> listeners) {
/*  336 */     this.listeners = listeners;
/*      */   }
/*      */ 
/*      */   public LocaleEncodingsMetaData getLocalEncodings()
/*      */   {
/*  341 */     return this.localEncodings;
/*      */   }
/*      */   @XmlElement(name="locale-encoding-mapping-list")
/*      */   public void setLocalEncodings(LocaleEncodingsMetaData localEncodings) {
/*  346 */     this.localEncodings = localEncodings;
/*      */   }
/*      */ 
/*      */   public LoginConfigMetaData getLoginConfig()
/*      */   {
/*  351 */     return this.loginConfig;
/*      */   }
/*      */ 
/*      */   public void setLoginConfig(LoginConfigMetaData loginConfig) {
/*  355 */     this.loginConfig = loginConfig;
/*      */   }
/*      */ 
/*      */   public List<MimeMappingMetaData> getMimeMappings()
/*      */   {
/*  360 */     return this.mimeMappings;
/*      */   }
/*      */   @XmlElement(name="mime-mapping")
/*      */   public void setMimeMappings(List<MimeMappingMetaData> mimeMappings) {
/*  365 */     this.mimeMappings = mimeMappings;
/*      */   }
/*      */ 
/*      */   public JBossServletMetaData getServletByName(String name)
/*      */   {
/*  370 */     JBossServletMetaData servlet = null;
/*  371 */     if (this.servlets != null)
/*  372 */       servlet = (JBossServletMetaData)this.servlets.get(name);
/*  373 */     return servlet;
/*      */   }
/*      */ 
/*      */   public JBossServletsMetaData getServlets() {
/*  377 */     return this.servlets;
/*      */   }
/*      */   @XmlElement(name="servlet")
/*      */   public void setServlets(JBossServletsMetaData servlets) {
/*  382 */     this.servlets = servlets;
/*      */   }
/*      */ 
/*      */   public List<ServletMappingMetaData> getServletMappings()
/*      */   {
/*  387 */     return this.servletMappings;
/*      */   }
/*      */   @XmlElement(name="servlet-mapping")
/*      */   public void setServletMappings(List<ServletMappingMetaData> servletMappings) {
/*  392 */     this.servletMappings = servletMappings;
/*      */   }
/*      */ 
/*      */   public List<SecurityConstraintMetaData> getSecurityContraints()
/*      */   {
/*  397 */     return this.securityContraints;
/*      */   }
/*      */   @XmlElement(name="security-constraint")
/*      */   public void setSecurityContraints(List<SecurityConstraintMetaData> securityContraints) {
/*  402 */     this.securityContraints = securityContraints;
/*      */   }
/*      */ 
/*      */   public SecurityRolesMetaData getSecurityRoles()
/*      */   {
/*  407 */     return this.securityRoles;
/*      */   }
/*      */   @XmlElement(name="security-role")
/*      */   public void setSecurityRoles(SecurityRolesMetaData securityRoles) {
/*  412 */     this.securityRoles = securityRoles;
/*      */   }
/*      */ 
/*      */   public WelcomeFileListMetaData getWelcomeFileList()
/*      */   {
/*  417 */     return this.welcomeFileList;
/*      */   }
/*      */ 
/*      */   public void setWelcomeFileList(WelcomeFileListMetaData welcomeFileList) {
/*  421 */     this.welcomeFileList = welcomeFileList;
/*      */   }
/*      */ 
/*      */   public EJBLocalReferenceMetaData getEjbLocalReferenceByName(String name)
/*      */   {
/*  426 */     return (EJBLocalReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbLocalReferences());
/*      */   }
/*      */ 
/*      */   public EJBLocalReferencesMetaData getEjbLocalReferences()
/*      */   {
/*  431 */     if (this.jndiEnvironmentRefsGroup != null)
/*  432 */       return this.jndiEnvironmentRefsGroup.getEjbLocalReferences();
/*  433 */     return null;
/*      */   }
/*      */ 
/*      */   public EJBReferenceMetaData getEjbReferenceByName(String name)
/*      */   {
/*  438 */     return (EJBReferenceMetaData)AbstractMappedMetaData.getByName(name, getEjbReferences());
/*      */   }
/*      */ 
/*      */   public EJBReferencesMetaData getEjbReferences()
/*      */   {
/*  443 */     if (this.jndiEnvironmentRefsGroup != null)
/*  444 */       return this.jndiEnvironmentRefsGroup.getEjbReferences();
/*  445 */     return null;
/*      */   }
/*      */ 
/*      */   public EnvironmentEntriesMetaData getEnvironmentEntries()
/*      */   {
/*  450 */     if (this.jndiEnvironmentRefsGroup != null)
/*  451 */       return this.jndiEnvironmentRefsGroup.getEnvironmentEntries();
/*  452 */     return null;
/*      */   }
/*      */ 
/*      */   public EnvironmentEntryMetaData getEnvironmentEntryByName(String name)
/*      */   {
/*  457 */     return (EnvironmentEntryMetaData)AbstractMappedMetaData.getByName(name, getEnvironmentEntries());
/*      */   }
/*      */ 
/*      */   public MessageDestinationReferenceMetaData getMessageDestinationReferenceByName(String name)
/*      */   {
/*  462 */     return (MessageDestinationReferenceMetaData)AbstractMappedMetaData.getByName(name, getMessageDestinationReferences());
/*      */   }
/*      */ 
/*      */   public MessageDestinationReferencesMetaData getMessageDestinationReferences()
/*      */   {
/*  467 */     if (this.jndiEnvironmentRefsGroup != null)
/*  468 */       return this.jndiEnvironmentRefsGroup.getMessageDestinationReferences();
/*  469 */     return null;
/*      */   }
/*      */ 
/*      */   public PersistenceContextReferenceMetaData getPersistenceContextReferenceByName(String name)
/*      */   {
/*  474 */     return (PersistenceContextReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceContextRefs());
/*      */   }
/*      */ 
/*      */   public PersistenceContextReferencesMetaData getPersistenceContextRefs()
/*      */   {
/*  479 */     if (this.jndiEnvironmentRefsGroup != null)
/*  480 */       return this.jndiEnvironmentRefsGroup.getPersistenceContextRefs();
/*  481 */     return null;
/*      */   }
/*      */ 
/*      */   public PersistenceUnitReferenceMetaData getPersistenceUnitReferenceByName(String name)
/*      */   {
/*  486 */     return (PersistenceUnitReferenceMetaData)AbstractMappedMetaData.getByName(name, getPersistenceUnitRefs());
/*      */   }
/*      */ 
/*      */   public PersistenceUnitReferencesMetaData getPersistenceUnitRefs()
/*      */   {
/*  491 */     if (this.jndiEnvironmentRefsGroup != null)
/*  492 */       return this.jndiEnvironmentRefsGroup.getPersistenceUnitRefs();
/*  493 */     return null;
/*      */   }
/*      */ 
/*      */   public LifecycleCallbacksMetaData getPostConstructs()
/*      */   {
/*  498 */     if (this.jndiEnvironmentRefsGroup != null)
/*  499 */       return this.jndiEnvironmentRefsGroup.getPostConstructs();
/*  500 */     return null;
/*      */   }
/*      */ 
/*      */   public LifecycleCallbacksMetaData getPreDestroys()
/*      */   {
/*  505 */     if (this.jndiEnvironmentRefsGroup != null)
/*  506 */       return this.jndiEnvironmentRefsGroup.getPreDestroys();
/*  507 */     return null;
/*      */   }
/*      */ 
/*      */   public ResourceEnvironmentReferenceMetaData getResourceEnvironmentReferenceByName(String name)
/*      */   {
/*  512 */     return (ResourceEnvironmentReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceEnvironmentReferences());
/*      */   }
/*      */ 
/*      */   public ResourceEnvironmentReferencesMetaData getResourceEnvironmentReferences()
/*      */   {
/*  517 */     if (this.jndiEnvironmentRefsGroup != null)
/*  518 */       return this.jndiEnvironmentRefsGroup.getResourceEnvironmentReferences();
/*  519 */     return null;
/*      */   }
/*      */ 
/*      */   public ResourceReferenceMetaData getResourceReferenceByName(String name)
/*      */   {
/*  524 */     return (ResourceReferenceMetaData)AbstractMappedMetaData.getByName(name, getResourceReferences());
/*      */   }
/*      */ 
/*      */   public ResourceReferencesMetaData getResourceReferences()
/*      */   {
/*  529 */     if (this.jndiEnvironmentRefsGroup != null)
/*  530 */       return this.jndiEnvironmentRefsGroup.getResourceReferences();
/*  531 */     return null;
/*      */   }
/*      */ 
/*      */   public ServiceReferenceMetaData getServiceReferenceByName(String name)
/*      */   {
/*  536 */     return (ServiceReferenceMetaData)AbstractMappedMetaData.getByName(name, getServiceReferences());
/*      */   }
/*      */ 
/*      */   public ServiceReferencesMetaData getServiceReferences()
/*      */   {
/*  541 */     if (this.jndiEnvironmentRefsGroup != null)
/*  542 */       return this.jndiEnvironmentRefsGroup.getServiceReferences();
/*  543 */     return null;
/*      */   }
/*      */ 
/*      */   public MessageDestinationsMetaData getMessageDestinations()
/*      */   {
/*  548 */     return this.messageDestinations;
/*      */   }
/*      */   @XmlElement(name="message-destination")
/*      */   public void setMessageDestinations(MessageDestinationsMetaData messageDestinations) {
/*  553 */     this.messageDestinations = messageDestinations;
/*      */   }
/*      */ 
/*      */   public String getAlternativeDD()
/*      */   {
/*  558 */     return this.alternativeDD;
/*      */   }
/*      */ 
/*      */   public void setAlternativeDD(String alternativeDD) {
/*  562 */     this.alternativeDD = alternativeDD;
/*      */   }
/*      */ 
/*      */   public String getContextRoot() {
/*  566 */     return this.contextRoot;
/*      */   }
/*      */ 
/*      */   public void setContextRoot(String contextRoot) {
/*  570 */     this.contextRoot = contextRoot;
/*      */   }
/*      */ 
/*      */   public List<String> getDepends()
/*      */   {
/*  575 */     return this.depends;
/*      */   }
/*      */ 
/*      */   public ClassLoader getENCLoader() {
/*  579 */     return this.encLoader;
/*      */   }
/*      */   @XmlTransient
/*      */   public void setENCLoader(ClassLoader encLoader) {
/*  584 */     this.encLoader = encLoader;
/*      */   }
/*      */ 
/*      */   public ClassLoader getContextLoader()
/*      */   {
/*  589 */     return this.cxtLoader;
/*      */   }
/*      */   @XmlTransient
/*      */   public void setContextLoader(ClassLoader cxtLoader) {
/*  594 */     this.cxtLoader = cxtLoader;
/*      */   }
/*      */ 
/*      */   public void setDepends(List<String> depends)
/*      */   {
/*  599 */     this.depends = depends;
/*      */   }
/*      */ 
/*      */   public ClassLoadingMetaData getClassLoading()
/*      */   {
/*  604 */     return this.classLoading;
/*      */   }
/*      */ 
/*      */   public void setClassLoading(ClassLoadingMetaData classLoading)
/*      */   {
/*  609 */     this.classLoading = classLoading;
/*      */   }
/*      */ 
/*      */   public String getJaccContextID()
/*      */   {
/*  614 */     return this.jaccContextID;
/*      */   }
/*      */ 
/*      */   public void setJaccContextID(String jaccContextID) {
/*  618 */     this.jaccContextID = jaccContextID;
/*      */   }
/*      */   @XmlTransient
/*      */   public String getPublicID() {
/*  623 */     return getDtdPublicId();
/*      */   }
/*      */ 
/*      */   public String getSecurityDomain() {
/*  627 */     return this.securityDomain;
/*      */   }
/*      */ 
/*      */   public void setSecurityDomain(String securityDomain) {
/*  631 */     if (securityDomain == null)
/*  632 */       throw new IllegalArgumentException("securityDomain is null");
/*  633 */     this.securityDomain = securityDomain.trim();
/*      */   }
/*      */ 
/*      */   public HashMap getArbitraryMetadata()
/*      */   {
/*  638 */     return this.arbitraryMetadata;
/*      */   }
/*      */ 
/*      */   public void setArbitraryMetadata(HashMap arbitraryMetadata) {
/*  642 */     this.arbitraryMetadata = arbitraryMetadata;
/*      */   }
/*      */ 
/*      */   public boolean isFlushOnSessionInvalidation() {
/*  646 */     return this.flushOnSessionInvalidation;
/*      */   }
/*      */ 
/*      */   public void setFlushOnSessionInvalidation(boolean flushOnSessionInvalidation) {
/*  650 */     this.flushOnSessionInvalidation = flushOnSessionInvalidation;
/*      */   }
/*      */ 
/*      */   public Integer getMaxActiveSessions() {
/*  654 */     return this.maxActiveSessions;
/*      */   }
/*      */ 
/*      */   public void setMaxActiveSessions(Integer maxActiveSessions) {
/*  658 */     this.maxActiveSessions = maxActiveSessions;
/*      */   }
/*      */ 
/*      */   public PassivationConfig getPassivationConfig() {
/*  662 */     return this.passivationConfig;
/*      */   }
/*      */ 
/*      */   public void setPassivationConfig(PassivationConfig passivationConfig) {
/*  666 */     this.passivationConfig = passivationConfig;
/*      */   }
/*      */ 
/*      */   public ReplicationConfig getReplicationConfig() {
/*  670 */     return this.replicationConfig;
/*      */   }
/*      */ 
/*      */   public void setReplicationConfig(ReplicationConfig replicationConfig) {
/*  674 */     this.replicationConfig = replicationConfig;
/*      */   }
/*      */ 
/*      */   public boolean isUseSessionCookies()
/*      */   {
/*  679 */     return this.useSessionCookies;
/*      */   }
/*      */ 
/*      */   public void setUseSessionCookies(boolean useSessionCookies) {
/*  683 */     this.useSessionCookies = useSessionCookies;
/*      */   }
/*      */ 
/*      */   public int getSessionCookies()
/*      */   {
/*  688 */     return this.sessionCookies;
/*      */   }
/*      */ 
/*      */   public void setSessionCookies(int sessionCookies) {
/*  692 */     this.sessionCookies = sessionCookies;
/*      */   }
/*      */ 
/*      */   public List<String> getVirtualHosts()
/*      */   {
/*  697 */     return this.virtualHosts;
/*      */   }
/*      */   @XmlElement(name="virtual-host")
/*      */   public void setVirtualHosts(List<String> virtualHosts) {
/*  702 */     this.virtualHosts = virtualHosts;
/*      */   }
/*      */ 
/*      */   public WebserviceDescriptionsMetaData getWebserviceDescriptions()
/*      */   {
/*  707 */     return this.webserviceDescriptions;
/*      */   }
/*      */ 
/*      */   @XmlElement(name="webservice-description")
/*      */   public void setWebserviceDescriptions(WebserviceDescriptionsMetaData webserviceDescriptions) {
/*  713 */     this.webserviceDescriptions = webserviceDescriptions;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public Set<String> getSecurityRoleNames()
/*      */   {
/*  723 */     return new HashSet(this.securityRoles.keySet());
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public SecurityRoleRefsMetaData getSecurityRoleRefs(String servletName)
/*      */   {
/*  733 */     SecurityRoleRefsMetaData refs = null;
/*  734 */     if (getServlets() != null)
/*      */     {
/*  736 */       ServletMetaData servlet = (ServletMetaData)getServlets().get(servletName);
/*  737 */       if (servlet != null)
/*      */       {
/*  739 */         refs = servlet.getSecurityRoleRefs();
/*      */       }
/*      */     }
/*  742 */     return refs;
/*      */   }
/*      */ 
/*      */   public Map<String, Set<String>> getPrincipalVersusRolesMap()
/*      */   {
/*  747 */     Map principalRolesMap = null;
/*      */ 
/*  749 */     for (SecurityRoleMetaData srm : this.securityRoles)
/*      */     {
/*  751 */       rolename = srm.getRoleName();
/*  752 */       if (principalRolesMap == null)
/*  753 */         principalRolesMap = new HashMap();
/*  754 */       if (srm.getPrincipals() != null)
/*  755 */         for (String pr : srm.getPrincipals())
/*      */         {
/*  757 */           Set roleset = (Set)principalRolesMap.get(pr);
/*  758 */           if (roleset == null)
/*  759 */             roleset = new HashSet();
/*  760 */           if (!roleset.contains(rolename))
/*  761 */             roleset.add(rolename);
/*  762 */           principalRolesMap.put(pr, roleset);
/*      */         }
/*      */     }
/*      */     String rolename;
/*  765 */     return principalRolesMap;
/*      */   }
/*      */ 
/*      */   public Environment getJndiEnvironmentRefsGroup()
/*      */   {
/*  775 */     return this.jndiEnvironmentRefsGroup;
/*      */   }
/*      */ 
/*      */   @XmlElement(type=JBossEnvironmentRefsGroupMetaData.class)
/*      */   public void setJndiEnvironmentRefsGroup(Environment env)
/*      */   {
/*  787 */     if (env == null)
/*  788 */       throw new IllegalArgumentException("Null jndiEnvironmentRefsGroup");
/*  789 */     JBossEnvironmentRefsGroupMetaData jenv = (JBossEnvironmentRefsGroupMetaData)env;
/*  790 */     if (this.jndiEnvironmentRefsGroup != null)
/*  791 */       this.jndiEnvironmentRefsGroup.merge(jenv, null, null, "jboss-web.xml", "web.xml", false);
/*      */     else
/*  793 */       this.jndiEnvironmentRefsGroup = jenv;
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public MessageDestinationMetaData getMessageDestination(String name) {
/*  799 */     return (MessageDestinationMetaData)this.messageDestinations.get(name);
/*      */   }
/*      */ 
/*      */   @XmlTransient
/*      */   public RunAsIdentityMetaData getRunAsIdentity(String servletName)
/*      */   {
/*  810 */     RunAsIdentityMetaData identity = (RunAsIdentityMetaData)this.runAsIdentity.get(servletName);
/*  811 */     if (identity == null)
/*      */     {
/*  813 */       JBossServletsMetaData servlets = getServlets();
/*  814 */       if (servlets != null)
/*      */       {
/*  816 */         ServletMetaData servlet = (ServletMetaData)servlets.get(servletName);
/*  817 */         if (servlet != null)
/*      */         {
/*  820 */           synchronized (this.runAsIdentity)
/*      */           {
/*  822 */             RunAsMetaData runAs = servlet.getRunAs();
/*  823 */             if (runAs != null)
/*      */             {
/*  825 */               String roleName = runAs.getRoleName();
/*  826 */               identity = new RunAsIdentityMetaData(roleName, null);
/*  827 */               this.runAsIdentity.put(servletName, identity);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  833 */     return identity;
/*      */   }
/*      */ 
/*      */   public Map<String, RunAsIdentityMetaData> getRunAsIdentity()
/*      */   {
/*  842 */     return this.runAsIdentity;
/*      */   }
/*      */ 
/*      */   public void setRunAsIdentity(Map<String, RunAsIdentityMetaData> runAsIdentity)
/*      */   {
/*  849 */     this.runAsIdentity.clear();
/*  850 */     this.runAsIdentity.putAll(runAsIdentity);
/*      */   }
/*      */ 
/*      */   public void mergeSecurityRoles(SecurityRolesMetaData roles)
/*      */   {
/*  856 */     if (this.securityRoles == null)
/*  857 */       this.securityRoles = roles;
/*      */     else
/*  859 */       this.securityRoles.merge(roles, null);
/*      */   }
/*      */ 
/*      */   public void merge(JBossWebMetaData override, WebMetaData original) {
/*  863 */     merge(override, original, "jboss-web.xml", "web.xml", false);
/*      */   }
/*      */ 
/*      */   public void merge(JBossWebMetaData override, WebMetaData original, String overrideFile, String overridenFile, boolean mustOverride)
/*      */   {
/*  868 */     super.merge(override, original);
/*      */ 
/*  870 */     if ((override != null) && (override.servletVersion != null))
/*  871 */       setServletVersion(override.servletVersion);
/*  872 */     else if ((original != null) && (original.getVersion() != null)) {
/*  873 */       setServletVersion(original.getVersion());
/*      */     }
/*  875 */     if ((override != null) && (override.distributable != null))
/*  876 */       setDistributable(override.distributable);
/*  877 */     else if ((original != null) && (original.getDistributable() != null)) {
/*  878 */       setDistributable(original.getDistributable());
/*      */     }
/*  880 */     if ((override != null) && (override.metadataComplete)) {
/*  881 */       setMetadataComplete(override.metadataComplete);
/*  882 */     } else if ((original != null) && ((original instanceof Web25MetaData)))
/*      */     {
/*  884 */       Web25MetaData web25MD = (Web25MetaData)original;
/*  885 */       setMetadataComplete(web25MD.isMetadataComplete());
/*      */     }
/*      */ 
/*  888 */     if ((override != null) && (override.contextParams != null))
/*  889 */       setContextParams(override.contextParams);
/*  890 */     else if ((original != null) && (original.getContextParams() != null)) {
/*  891 */       setContextParams(original.getContextParams());
/*      */     }
/*  893 */     if ((override != null) && (override.sessionConfig != null))
/*  894 */       setSessionConfig(override.sessionConfig);
/*  895 */     else if ((original != null) && (original.getSessionConfig() != null)) {
/*  896 */       setSessionConfig(original.getSessionConfig());
/*      */     }
/*  898 */     if ((override != null) && (override.filters != null))
/*  899 */       setFilters(override.filters);
/*  900 */     else if ((original != null) && (original.getFilters() != null)) {
/*  901 */       setFilters(original.getFilters());
/*      */     }
/*  903 */     if ((override != null) && (override.filterMappings != null))
/*  904 */       setFilterMappings(override.filterMappings);
/*  905 */     else if ((original != null) && (original.getFilterMappings() != null)) {
/*  906 */       setFilterMappings(original.getFilterMappings());
/*      */     }
/*  908 */     if ((override != null) && (override.errorPages != null))
/*  909 */       setErrorPages(override.errorPages);
/*  910 */     else if ((original != null) && (original.getErrorPages() != null)) {
/*  911 */       setErrorPages(original.getErrorPages());
/*      */     }
/*  913 */     if ((override != null) && (override.jspConfig != null))
/*  914 */       setJspConfig(override.jspConfig);
/*  915 */     else if ((original != null) && (original.getJspConfig() != null)) {
/*  916 */       setJspConfig(original.getJspConfig());
/*      */     }
/*  918 */     if ((override != null) && (override.listeners != null))
/*  919 */       setListeners(override.listeners);
/*  920 */     else if ((original != null) && (original.getListeners() != null)) {
/*  921 */       setListeners(original.getListeners());
/*      */     }
/*  923 */     if ((override != null) && (override.loginConfig != null))
/*  924 */       setLoginConfig(override.loginConfig);
/*  925 */     else if ((original != null) && (original.getLoginConfig() != null)) {
/*  926 */       setLoginConfig(original.getLoginConfig());
/*      */     }
/*  928 */     if ((override != null) && (override.mimeMappings != null))
/*  929 */       setMimeMappings(override.mimeMappings);
/*  930 */     else if ((original != null) && (original.getMimeMappings() != null)) {
/*  931 */       setMimeMappings(original.getMimeMappings());
/*      */     }
/*  933 */     if ((override != null) && (override.servletMappings != null))
/*  934 */       setServletMappings(override.servletMappings);
/*  935 */     else if ((original != null) && (original.getServletMappings() != null)) {
/*  936 */       setServletMappings(original.getServletMappings());
/*      */     }
/*  938 */     if ((override != null) && (override.securityContraints != null))
/*  939 */       setSecurityContraints(override.securityContraints);
/*  940 */     else if ((original != null) && (original.getSecurityContraints() != null)) {
/*  941 */       setSecurityContraints(original.getSecurityContraints());
/*      */     }
/*  943 */     if ((override != null) && (override.welcomeFileList != null))
/*  944 */       setWelcomeFileList(override.welcomeFileList);
/*  945 */     else if ((original != null) && (original.getWelcomeFileList() != null)) {
/*  946 */       setWelcomeFileList(original.getWelcomeFileList());
/*      */     }
/*  948 */     if ((override != null) && (override.localEncodings != null))
/*  949 */       setLocalEncodings(override.localEncodings);
/*  950 */     else if ((original != null) && (original.getLocalEncodings() != null)) {
/*  951 */       setLocalEncodings(original.getLocalEncodings());
/*      */     }
/*  953 */     if ((override != null) && (override.dtdPublicId != null)) {
/*  954 */       this.dtdPublicId = override.dtdPublicId;
/*      */     }
/*  956 */     if ((override != null) && (override.dtdSystemId != null)) {
/*  957 */       this.dtdSystemId = override.dtdSystemId;
/*      */     }
/*  959 */     if ((override != null) && (override.version != null))
/*  960 */       setVersion(override.version);
/*  961 */     else if ((original != null) && (original.getVersion() != null)) {
/*  962 */       setVersion(original.getVersion());
/*      */     }
/*  964 */     if ((override != null) && (override.contextRoot != null)) {
/*  965 */       setContextRoot(override.contextRoot);
/*      */     }
/*  967 */     if ((override != null) && (override.alternativeDD != null)) {
/*  968 */       setAlternativeDD(override.alternativeDD);
/*      */     }
/*  970 */     if ((override != null) && (override.securityDomain != null)) {
/*  971 */       setSecurityDomain(override.securityDomain);
/*      */     }
/*  973 */     if ((override != null) && (override.jaccContextID != null)) {
/*  974 */       setJaccContextID(override.jaccContextID);
/*      */     }
/*  976 */     if ((override != null) && (override.classLoading != null)) {
/*  977 */       setClassLoading(override.classLoading);
/*      */     }
/*  979 */     if ((override != null) && (override.depends != null)) {
/*  980 */       setDepends(override.depends);
/*      */     }
/*  982 */     if ((override != null) && (override.runAsIdentity != null)) {
/*  983 */       setRunAsIdentity(override.runAsIdentity);
/*      */     }
/*  985 */     if (this.securityRoles == null)
/*  986 */       this.securityRoles = new SecurityRolesMetaData();
/*  987 */     SecurityRolesMetaData overrideRoles = null;
/*  988 */     SecurityRolesMetaData originalRoles = null;
/*  989 */     if (override != null)
/*  990 */       overrideRoles = override.getSecurityRoles();
/*  991 */     if (original != null)
/*  992 */       originalRoles = original.getSecurityRoles();
/*  993 */     this.securityRoles.merge(overrideRoles, originalRoles);
/*      */ 
/*  995 */     JBossServletsMetaData soverride = null;
/*  996 */     ServletsMetaData soriginal = null;
/*  997 */     if (override != null)
/*  998 */       soverride = override.getServlets();
/*  999 */     if (original != null)
/* 1000 */       soriginal = original.getServlets();
/* 1001 */     this.servlets = JBossServletsMetaData.merge(soverride, soriginal);
/*      */ 
/* 1003 */     MessageDestinationsMetaData overrideMsgDests = null;
/* 1004 */     MessageDestinationsMetaData originalMsgDests = null;
/* 1005 */     if ((override != null) && (override.messageDestinations != null))
/* 1006 */       overrideMsgDests = override.messageDestinations;
/* 1007 */     if ((original != null) && (original.getMessageDestinations() != null))
/* 1008 */       originalMsgDests = original.getMessageDestinations();
/* 1009 */     this.messageDestinations = MessageDestinationsMetaData.merge(overrideMsgDests, originalMsgDests, overridenFile, overrideFile);
/*      */ 
/* 1012 */     if (this.jndiEnvironmentRefsGroup == null)
/* 1013 */       this.jndiEnvironmentRefsGroup = new JBossEnvironmentRefsGroupMetaData();
/* 1014 */     Environment env = null;
/* 1015 */     JBossEnvironmentRefsGroupMetaData jenv = null;
/* 1016 */     if (override != null)
/* 1017 */       jenv = override.jndiEnvironmentRefsGroup;
/* 1018 */     if (original != null)
/* 1019 */       env = original.getJndiEnvironmentRefsGroup();
/* 1020 */     this.jndiEnvironmentRefsGroup.merge(jenv, env, null, overrideFile, overridenFile, mustOverride);
/*      */ 
/* 1022 */     if ((override != null) && (override.virtualHosts != null)) {
/* 1023 */       setVirtualHosts(override.virtualHosts);
/*      */     }
/* 1025 */     if ((override != null) && (override.flushOnSessionInvalidation)) {
/* 1026 */       setFlushOnSessionInvalidation(override.flushOnSessionInvalidation);
/*      */     }
/* 1028 */     if ((override != null) && (override.useSessionCookies)) {
/* 1029 */       setUseSessionCookies(override.useSessionCookies);
/*      */     }
/* 1031 */     if ((override != null) && (override.replicationConfig != null)) {
/* 1032 */       setReplicationConfig(override.replicationConfig);
/*      */     }
/* 1034 */     if ((override != null) && (override.passivationConfig != null)) {
/* 1035 */       setPassivationConfig(override.passivationConfig);
/*      */     }
/* 1037 */     if ((override != null) && (override.webserviceDescriptions != null)) {
/* 1038 */       setWebserviceDescriptions(override.webserviceDescriptions);
/*      */     }
/* 1040 */     if ((override != null) && (override.arbitraryMetadata != null)) {
/* 1041 */       setArbitraryMetadata(override.arbitraryMetadata);
/*      */     }
/* 1043 */     if ((override != null) && (override.maxActiveSessions != null)) {
/* 1044 */       setMaxActiveSessions(override.maxActiveSessions);
/*      */     }
/* 1046 */     if ((override != null) && (override.sessionCookies != -1)) {
/* 1047 */       setSessionCookies(override.sessionCookies);
/*      */     }
/*      */ 
/* 1050 */     if (this.servlets != null)
/*      */     {
/* 1052 */       for (JBossServletMetaData servlet : this.servlets)
/*      */       {
/* 1054 */         String servletName = servlet.getServletName();
/* 1055 */         String principalName = servlet.getRunAsPrincipal();
/*      */ 
/* 1057 */         String webXmlRunAs = null;
/* 1058 */         if (servlet.getRunAs() != null)
/* 1059 */           webXmlRunAs = servlet.getRunAs().getRoleName();
/* 1060 */         if (principalName != null)
/*      */         {
/* 1063 */           if (webXmlRunAs == null)
/*      */           {
/* 1065 */             throw new IllegalStateException("run-as-principal: " + principalName + " found in jboss-web.xml but there was no run-as in web.xml");
/*      */           }
/*      */ 
/* 1068 */           Set extraRoles = this.securityRoles.getSecurityRoleNamesByPrincipal(principalName);
/* 1069 */           RunAsIdentityMetaData runAsId = new RunAsIdentityMetaData(webXmlRunAs, principalName, extraRoles);
/* 1070 */           this.runAsIdentity.put(servletName, runAsId);
/*      */         }
/* 1072 */         else if (webXmlRunAs != null)
/*      */         {
/* 1074 */           RunAsIdentityMetaData runAsId = new RunAsIdentityMetaData(webXmlRunAs, null);
/* 1075 */           this.runAsIdentity.put(servletName, runAsId);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.web.jboss.JBossWebMetaData
 * JD-Core Version:    0.6.0
 */