/*     */ package org.jboss.metamodel.descriptor;
/*     */ 
/*     */ import javax.persistence.PersistenceContextType;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public abstract class DDObjectFactory extends ServiceRefObjectFactory
/*     */   implements ObjectModelFactory
/*     */ {
/*     */   public Object newChild(PersistenceUnitRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  39 */     return newRefChild(ref, localName);
/*     */   }
/*     */ 
/*     */   public Object newChild(PersistenceContextRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  44 */     return newRefChild(ref, localName);
/*     */   }
/*     */ 
/*     */   public Object newChild(EnvEntry ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  49 */     navigator.setTrimTextContent(false);
/*  50 */     return newRefChild(ref, localName);
/*     */   }
/*     */ 
/*     */   public Object newChild(EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  55 */     return newRefChild(ref, localName);
/*     */   }
/*     */ 
/*     */   public Object newChild(EjbLocalRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  60 */     return newRefChild(ref, localName);
/*     */   }
/*     */ 
/*     */   public Object newChild(ResourceRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  65 */     return newRefChild(ref, localName);
/*     */   }
/*     */ 
/*     */   public Object newChild(ResourceEnvRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  70 */     return newRefChild(ref, localName);
/*     */   }
/*     */ 
/*     */   public Object newChild(MessageDestinationRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  75 */     return newRefChild(ref, localName);
/*     */   }
/*     */ 
/*     */   public Object newChild(JndiRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  80 */     return newRefChild(ref, localName);
/*     */   }
/*     */ 
/*     */   public void addChild(PersistenceUnitRef parent, InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  85 */     parent.setInjectionTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(PersistenceContextRef parent, InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  90 */     parent.setInjectionTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(EnvEntry parent, InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  95 */     parent.setInjectionTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(EjbRef parent, InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 100 */     parent.setInjectionTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(EjbLocalRef parent, InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 105 */     parent.setInjectionTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(ResourceRef parent, InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 110 */     parent.setInjectionTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(ResourceEnvRef parent, InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 115 */     parent.setInjectionTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(MessageDestinationRef parent, InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 120 */     parent.setInjectionTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(JndiRef parent, InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 125 */     parent.setInjectionTarget(target);
/*     */   }
/*     */ 
/*     */   public void setValue(EjbLocalRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 130 */     if (localName.equals("ejb-ref-name"))
/*     */     {
/* 132 */       ref.setEjbRefName(getValue(localName, value));
/*     */     }
/* 134 */     else if (localName.equals("ejb-ref-type"))
/*     */     {
/* 136 */       ref.setEjbRefType(getValue(localName, value));
/*     */     }
/* 138 */     else if (localName.equals("local-home"))
/*     */     {
/* 140 */       ref.setLocalHome(getValue(localName, value));
/*     */     }
/* 142 */     else if (localName.equals("local"))
/*     */     {
/* 144 */       ref.setLocal(getValue(localName, value));
/*     */     }
/* 146 */     else if (localName.equals("ejb-link"))
/*     */     {
/* 148 */       ref.setEjbLink(getValue(localName, value));
/*     */     }
/* 150 */     else if ((localName.equals("mapped-name")) || (localName.equals("local-jndi-name")) || (localName.equals("jndi-name")))
/*     */     {
/* 152 */       ref.setMappedName(getValue(localName, value));
/*     */     }
/* 154 */     else if (localName.equals("ignore-dependency"))
/*     */     {
/* 156 */       ref.setIgnoreDependency(true);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 162 */     if (localName.equals("ejb-ref-name"))
/*     */     {
/* 164 */       ref.setEjbRefName(getValue(localName, value));
/*     */     }
/* 166 */     else if (localName.equals("ejb-ref-type"))
/*     */     {
/* 168 */       ref.setEjbRefType(getValue(localName, value));
/*     */     }
/* 170 */     else if (localName.equals("home"))
/*     */     {
/* 172 */       ref.setHome(getValue(localName, value));
/*     */     }
/* 174 */     else if (localName.equals("remote"))
/*     */     {
/* 176 */       ref.setRemote(getValue(localName, value));
/*     */     }
/* 178 */     else if (localName.equals("ejb-link"))
/*     */     {
/* 180 */       ref.setEjbLink(getValue(localName, value));
/*     */     }
/* 182 */     else if ((localName.equals("mapped-name")) || (localName.equals("jndi-name")))
/*     */     {
/* 184 */       ref.setMappedName(getValue(localName, value));
/*     */     }
/* 186 */     else if (localName.equals("ignore-dependency"))
/*     */     {
/* 188 */       ref.setIgnoreDependency(true);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(InjectionTarget target, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 197 */     if (localName.equals("injection-target-class"))
/*     */     {
/* 199 */       target.setTargetClass(getValue(localName, value));
/*     */     }
/* 201 */     else if (localName.equals("injection-target-name"))
/*     */     {
/* 203 */       target.setTargetName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(MessageDestinationRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 212 */     if (localName.equals("description"))
/*     */     {
/* 214 */       ref.setDescription(getValue(localName, value));
/*     */     }
/* 216 */     else if (localName.equals("message-destination-ref-name"))
/*     */     {
/* 218 */       ref.setMessageDestinationRefName(getValue(localName, value));
/*     */     }
/* 220 */     else if (localName.equals("message-destination-type"))
/*     */     {
/* 222 */       ref.setMessageDestinationType(getValue(localName, value));
/*     */     }
/* 224 */     else if (localName.equals("message-destination-usage"))
/*     */     {
/* 226 */       ref.setMessageDestinationUsage(getValue(localName, value));
/*     */     }
/* 228 */     else if (localName.equals("message-destination-link"))
/*     */     {
/* 230 */       ref.setMessageDestinationLink(getValue(localName, value));
/*     */     }
/* 232 */     else if ((localName.equals("mapped-name")) || (localName.equals("jndi-name")))
/*     */     {
/* 234 */       ref.setMappedName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(EnvEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 240 */     if (localName.equals("description"))
/*     */     {
/* 242 */       entry.setDescription(getValue(localName, value));
/*     */     }
/* 244 */     else if (localName.equals("env-entry-name"))
/*     */     {
/* 246 */       entry.setEnvEntryName(getValue(localName, value));
/*     */     }
/* 248 */     else if (localName.equals("env-entry-type"))
/*     */     {
/* 250 */       entry.setEnvEntryType(getValue(localName, value));
/*     */     }
/* 252 */     else if (localName.equals("env-entry-value"))
/*     */     {
/* 254 */       entry.setEnvEntryValue(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(ResourceEnvRef envRef, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 260 */     if ((localName.equals("res-ref-name")) || (localName.equals("resource-env-ref-name")))
/*     */     {
/* 262 */       envRef.setResRefName(getValue(localName, value));
/*     */     }
/* 264 */     else if ((localName.equals("res-type")) || (localName.equals("resource-env-ref-type")))
/*     */     {
/* 266 */       envRef.setResType(getValue(localName, value));
/*     */     }
/* 268 */     else if (localName.equals("res-auth"))
/*     */     {
/* 270 */       envRef.setResAuth(getValue(localName, value));
/*     */     }
/* 272 */     else if (localName.equals("res-sharing-scope"))
/*     */     {
/* 274 */       envRef.setResSharingScope(getValue(localName, value));
/*     */     }
/* 276 */     else if ((localName.equals("mapped-name")) || (localName.equals("jndi-name")))
/*     */     {
/* 278 */       envRef.setMappedName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(ResourceRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 284 */     if ((localName.equals("res-ref-name")) || (localName.equals("resource-env-ref-name")))
/*     */     {
/* 286 */       ref.setResRefName(getValue(localName, value));
/*     */     }
/* 288 */     else if ((localName.equals("res-type")) || (localName.equals("resource-env-ref-type")))
/*     */     {
/* 290 */       ref.setResType(getValue(localName, value));
/*     */     }
/* 292 */     else if (localName.equals("res-auth"))
/*     */     {
/* 294 */       ref.setResAuth(getValue(localName, value));
/*     */     }
/* 296 */     else if (localName.equals("res-sharing-scope"))
/*     */     {
/* 298 */       ref.setResSharingScope(getValue(localName, value));
/*     */     }
/* 300 */     else if ((localName.equals("mapped-name")) || (localName.equals("jndi-name")))
/*     */     {
/* 302 */       ref.setMappedName(getValue(localName, value));
/* 303 */       ref.setJndiName(getValue(localName, value));
/*     */     }
/* 305 */     else if (localName.equals("res-url"))
/*     */     {
/* 307 */       ref.setResUrl(getValue(localName, value));
/*     */     }
/* 309 */     else if (localName.equals("resource-name"))
/*     */     {
/* 311 */       ref.setResourceName(getValue(localName, value));
/* 312 */       ref.setMappedName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(NameValuePair nvPair, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 318 */     if (localName.equals("name"))
/*     */     {
/* 320 */       nvPair.setName(value);
/*     */     }
/* 322 */     else if (localName.equals("value"))
/*     */     {
/* 324 */       nvPair.setValue(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(SecurityRole role, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 330 */     if (localName.equals("role-name"))
/*     */     {
/* 332 */       role.setRoleName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(JndiRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 338 */     if (localName.equals("mapped-name"))
/*     */     {
/* 340 */       ref.setMappedName(getValue(localName, value));
/*     */     }
/* 342 */     else if (localName.equals("jndi-ref-name"))
/*     */     {
/* 344 */       ref.setJndiRefName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(RunAs runAs, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 350 */     if (localName.equals("role-name"))
/*     */     {
/* 352 */       runAs.setRoleName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(SecurityRoleRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 358 */     if (localName.equals("role-name"))
/*     */     {
/* 360 */       ref.setRoleName(getValue(localName, value));
/*     */     }
/* 362 */     else if (localName.equals("role-link"))
/*     */     {
/* 364 */       ref.setRoleLink(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(Listener listener, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 370 */     if (localName.equals("listener-class"))
/*     */     {
/* 372 */       listener.setListenerClass(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(MessageDestination destination, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 378 */     if (localName.equals("message-destination-name"))
/*     */     {
/* 380 */       destination.setMessageDestinationName(getValue(localName, value));
/*     */     }
/* 382 */     else if ((localName.equals("mapped-name")) || (localName.equals("jndi-name")))
/*     */     {
/* 384 */       destination.setMappedName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(PersistenceUnitRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 390 */     if (localName.equals("persistence-unit-ref-name"))
/*     */     {
/* 392 */       ref.setRefName(getValue(localName, value));
/*     */     }
/* 394 */     else if (localName.equals("persistence-unit-name"))
/*     */     {
/* 396 */       ref.setUnitName(getValue(localName, value));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object newEnvRefGroupChild(String localName)
/*     */   {
/* 402 */     Object child = null;
/*     */ 
/* 404 */     if (localName.equals("ejb-local-ref"))
/*     */     {
/* 406 */       child = new EjbLocalRef();
/*     */     }
/* 408 */     else if (localName.equals("ejb-ref"))
/*     */     {
/* 410 */       child = new EjbRef();
/*     */     }
/* 412 */     else if (localName.equals("resource-ref"))
/*     */     {
/* 414 */       child = new ResourceRef();
/*     */     }
/* 416 */     else if (localName.equals("resource-env-ref"))
/*     */     {
/* 418 */       child = new ResourceEnvRef();
/*     */     }
/* 420 */     else if (localName.equals("env-entry"))
/*     */     {
/* 422 */       child = new EnvEntry();
/*     */     }
/* 424 */     else if (localName.equals("message-destination-ref"))
/*     */     {
/* 426 */       child = new MessageDestinationRef();
/*     */     }
/* 428 */     else if (localName.equals("service-ref"))
/*     */     {
/* 430 */       child = new ServiceRefDelegate().newServiceRefMetaData();
/*     */     }
/* 432 */     else if (localName.equals("jndi-ref"))
/*     */     {
/* 434 */       child = new JndiRef();
/*     */     }
/* 436 */     else if (localName.equals("persistence-unit-ref"))
/*     */     {
/* 438 */       child = new PersistenceUnitRef();
/*     */     }
/* 440 */     else if (localName.equals("persistence-context-ref"))
/*     */     {
/* 442 */       child = new PersistenceContextRef();
/*     */     }
/*     */ 
/* 445 */     return child;
/*     */   }
/*     */ 
/*     */   protected Object newRefChild(Ref ref, String localName)
/*     */   {
/* 450 */     Object child = null;
/*     */ 
/* 452 */     if (localName.equals("ignore-dependency"))
/*     */     {
/* 454 */       ref.setIgnoreDependency(true);
/*     */     }
/* 456 */     else if (localName.equals("injection-target"))
/*     */     {
/* 458 */       InjectionTarget target = new InjectionTarget();
/* 459 */       child = target;
/*     */     }
/*     */ 
/* 462 */     return child;
/*     */   }
/*     */ 
/*     */   public void setValue(PersistenceContextRef ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 467 */     if (localName.equals("persistence-context-ref-name"))
/*     */     {
/* 469 */       ref.setRefName(getValue(localName, value));
/*     */     }
/* 471 */     else if (localName.equals("persistence-unit-name"))
/*     */     {
/* 473 */       ref.setUnitName(getValue(localName, value));
/*     */     }
/* 475 */     else if (localName.equals("persistence-context-type"))
/*     */     {
/* 477 */       if (value.toLowerCase().equals("transaction"))
/*     */       {
/* 479 */         ref.setPersistenceContextType(PersistenceContextType.TRANSACTION);
/*     */       }
/*     */       else
/*     */       {
/* 483 */         ref.setPersistenceContextType(PersistenceContextType.EXTENDED);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getValue(String name, String value)
/*     */   {
/* 490 */     return value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metamodel.descriptor.DDObjectFactory
 * JD-Core Version:    0.6.0
 */