/*     */ package org.jboss.metamodel.descriptor;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
/*     */ 
/*     */ public abstract class EnvironmentRefGroup
/*     */ {
/*  39 */   private static final Logger log = Logger.getLogger(EnvironmentRefGroup.class);
/*     */ 
/*  41 */   protected HashMap<String, EjbLocalRef> ejbLocalRefs = new HashMap();
/*  42 */   protected HashMap<String, EjbRef> ejbRefs = new HashMap();
/*  43 */   protected HashMap<String, EnvEntry> envEntries = new HashMap();
/*  44 */   protected HashMap<String, ResourceEnvRef> resourceEnvRefs = new HashMap();
/*  45 */   protected HashMap<String, ResourceRef> resourceRefs = new HashMap();
/*  46 */   protected HashMap<String, MessageDestinationRef> messageDestinationRefs = new HashMap();
/*     */ 
/*  48 */   protected HashMap<String, MessageDestinationRef> messageDestinationRefsByLink = new HashMap();
/*  49 */   protected HashMap<String, ServiceRefMetaData> serviceRefs = new LinkedHashMap();
/*  50 */   protected HashMap<String, JndiRef> jndiRefs = new HashMap();
/*  51 */   protected List<PersistenceContextRef> persistenceContextRefs = new ArrayList();
/*  52 */   protected List<PersistenceUnitRef> persistenceUnitRefs = new ArrayList();
/*     */ 
/*     */   public Collection<MessageDestinationRef> getMessageDestinationRefs()
/*     */   {
/*  56 */     return this.messageDestinationRefs.values();
/*     */   }
/*     */ 
/*     */   public void addMessageDestinationRef(MessageDestinationRef ref)
/*     */   {
/*  61 */     log.debug("addMessageDestinationRef, " + ref);
/*  62 */     this.messageDestinationRefs.put(ref.getMessageDestinationRefName(), ref);
/*  63 */     String link = ref.getMessageDestinationLink();
/*  64 */     if (link != null)
/*     */     {
/*  66 */       this.messageDestinationRefsByLink.put(link, ref);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Collection<EjbLocalRef> getEjbLocalRefs()
/*     */   {
/*  72 */     return this.ejbLocalRefs.values();
/*     */   }
/*     */ 
/*     */   public void addEjbLocalRef(EjbLocalRef ref)
/*     */   {
/*  77 */     this.ejbLocalRefs.put(ref.getEjbRefName(), ref);
/*     */   }
/*     */ 
/*     */   public Collection<EjbRef> getEjbRefs()
/*     */   {
/*  82 */     return this.ejbRefs.values();
/*     */   }
/*     */ 
/*     */   public void addEjbRef(EjbRef ref)
/*     */   {
/*  87 */     this.ejbRefs.put(ref.getEjbRefName(), ref);
/*     */   }
/*     */ 
/*     */   public Collection<EnvEntry> getEnvEntries()
/*     */   {
/*  92 */     return this.envEntries.values();
/*     */   }
/*     */ 
/*     */   public void addEnvEntry(EnvEntry entry)
/*     */   {
/*  97 */     this.envEntries.put(entry.getEnvEntryName(), entry);
/*     */   }
/*     */ 
/*     */   public Collection<ResourceEnvRef> getResourceEnvRefs()
/*     */   {
/* 102 */     return this.resourceEnvRefs.values();
/*     */   }
/*     */ 
/*     */   public void addResourceEnvRef(ResourceEnvRef envRef)
/*     */   {
/* 107 */     this.resourceEnvRefs.put(envRef.getResRefName(), envRef);
/*     */   }
/*     */ 
/*     */   public Collection<ResourceRef> getResourceRefs()
/*     */   {
/* 112 */     return this.resourceRefs.values();
/*     */   }
/*     */ 
/*     */   public void addResourceRef(ResourceRef ref)
/*     */   {
/* 117 */     this.resourceRefs.put(ref.getResRefName(), ref);
/*     */   }
/*     */ 
/*     */   public Collection<JndiRef> getJndiRefs()
/*     */   {
/* 122 */     return this.jndiRefs.values();
/*     */   }
/*     */ 
/*     */   public void addJndiRef(JndiRef ref)
/*     */   {
/* 127 */     this.jndiRefs.put(ref.getJndiRefName(), ref);
/*     */   }
/*     */ 
/*     */   public Collection<ServiceRefMetaData> getServiceRefs()
/*     */   {
/* 132 */     return this.serviceRefs.values();
/*     */   }
/*     */ 
/*     */   public void addServiceRef(ServiceRefMetaData ref)
/*     */   {
/* 137 */     this.serviceRefs.put(ref.getServiceRefName(), ref);
/*     */   }
/*     */ 
/*     */   public ServiceRefMetaData getServiceRef(String name)
/*     */   {
/* 142 */     return (ServiceRefMetaData)this.serviceRefs.get(name);
/*     */   }
/*     */ 
/*     */   public void updateEjbRef(EjbRef updatedRef)
/*     */   {
/* 147 */     EjbRef ref = (EjbRef)this.ejbRefs.get(updatedRef.getEjbRefName());
/* 148 */     if (ref != null)
/*     */     {
/* 150 */       ref.setMappedName(updatedRef.getMappedName());
/* 151 */       ref.setIgnoreDependency(updatedRef.isIgnoreDependency());
/*     */     }
/*     */     else
/*     */     {
/* 155 */       this.ejbRefs.put(updatedRef.getEjbRefName(), updatedRef);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateEjbLocalRef(EjbLocalRef updatedRef)
/*     */   {
/* 161 */     EjbLocalRef ref = (EjbLocalRef)this.ejbLocalRefs.get(updatedRef.getEjbRefName());
/* 162 */     if (ref != null)
/*     */     {
/* 164 */       ref.setMappedName(updatedRef.getMappedName());
/* 165 */       ref.setIgnoreDependency(updatedRef.isIgnoreDependency());
/*     */     }
/*     */     else
/*     */     {
/* 169 */       this.ejbLocalRefs.put(updatedRef.getEjbRefName(), updatedRef);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateResourceRef(ResourceRef updatedRef)
/*     */   {
/* 175 */     ResourceRef ref = (ResourceRef)this.resourceRefs.get(updatedRef.getResRefName());
/* 176 */     if (ref != null)
/*     */     {
/* 178 */       ref.setMappedName(updatedRef.getMappedName());
/* 179 */       ref.setResUrl(updatedRef.getResUrl());
/* 180 */       ref.setResourceName(updatedRef.getResourceName());
/*     */     }
/*     */     else
/*     */     {
/* 184 */       this.resourceRefs.put(updatedRef.getResRefName(), updatedRef);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateResourceEnvRef(ResourceEnvRef updatedRef)
/*     */   {
/* 190 */     ResourceEnvRef ref = (ResourceEnvRef)this.resourceEnvRefs.get(updatedRef.getResRefName());
/* 191 */     if (ref != null)
/*     */     {
/* 193 */       ref.setMappedName(updatedRef.getMappedName());
/*     */     }
/*     */     else
/*     */     {
/* 197 */       this.resourceEnvRefs.put(updatedRef.getResRefName(), updatedRef);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateMessageDestinationRef(MessageDestinationRef updatedRef)
/*     */   {
/* 203 */     log.debug("updateMessageDestinationRef, " + updatedRef);
/* 204 */     MessageDestinationRef ref = (MessageDestinationRef)this.messageDestinationRefs.get(updatedRef.getMessageDestinationRefName());
/* 205 */     if (ref != null)
/*     */     {
/* 207 */       ref.setMappedName(updatedRef.getMappedName());
/*     */     }
/*     */     else
/*     */     {
/* 211 */       this.messageDestinationRefs.put(updatedRef.getMessageDestinationRefName(), updatedRef);
/* 212 */       ref = updatedRef;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 218 */     StringBuffer sb = new StringBuffer(100);
/* 219 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public List<PersistenceContextRef> getPersistenceContextRefs()
/*     */   {
/* 224 */     return this.persistenceContextRefs;
/*     */   }
/*     */ 
/*     */   public List<PersistenceUnitRef> getPersistenceUnitRefs()
/*     */   {
/* 229 */     return this.persistenceUnitRefs;
/*     */   }
/*     */ 
/*     */   public void addPersistenceContextRef(PersistenceContextRef ref)
/*     */   {
/* 234 */     this.persistenceContextRefs.add(ref);
/*     */   }
/*     */ 
/*     */   public void addPersistenceUnitRef(PersistenceUnitRef ref)
/*     */   {
/* 239 */     this.persistenceUnitRefs.add(ref);
/*     */   }
/*     */ 
/*     */   public MessageDestinationRef getMessageDestinationRefForLink(String link)
/*     */   {
/* 244 */     MessageDestinationRef ref = (MessageDestinationRef)this.messageDestinationRefsByLink.get(link);
/* 245 */     return ref;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metamodel.descriptor.EnvironmentRefGroup
 * JD-Core Version:    0.6.0
 */