/*     */ package org.jboss.metatype.api.types;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.metatype.api.values.ArrayValue;
/*     */ 
/*     */ public class ArrayMetaType<T extends Serializable> extends AbstractMetaType
/*     */ {
/*     */   private static final long serialVersionUID = -2062790692152055156L;
/*  41 */   private int dimension = 0;
/*     */   private MetaType elementType;
/*     */   private boolean primitiveArray;
/*  50 */   private transient int cachedHashCode = -2147483648;
/*     */ 
/*  53 */   private transient String cachedToString = null;
/*     */   private static final int PRIMITIVE_WRAPPER_NAME_INDEX = 0;
/*     */   private static final int PRIMITIVE_TYPE_NAME_INDEX = 1;
/*     */   private static final int PRIMITIVE_TYPE_ENCODING_INDEX = 2;
/*     */   private static final int PRIMITIVE_OPEN_TYPE_INDEX = 3;
/*  60 */   private static final Object[][] PRIMITIVE_ARRAY_TYPES = { { Boolean.class.getName(), Boolean.TYPE.getName(), "Z", SimpleMetaType.BOOLEAN }, { Character.class.getName(), Character.TYPE.getName(), "C", SimpleMetaType.CHARACTER }, { Byte.class.getName(), Byte.TYPE.getName(), "B", SimpleMetaType.BYTE }, { Short.class.getName(), Short.TYPE.getName(), "S", SimpleMetaType.SHORT }, { Integer.class.getName(), Integer.TYPE.getName(), "I", SimpleMetaType.INTEGER }, { Long.class.getName(), Long.TYPE.getName(), "J", SimpleMetaType.LONG }, { Float.class.getName(), Float.TYPE.getName(), "F", SimpleMetaType.FLOAT }, { Double.class.getName(), Double.TYPE.getName(), "D", SimpleMetaType.DOUBLE } };
/*     */ 
/*     */   public static boolean isPrimitiveEncoding(String primitiveKey)
/*     */   {
/*  79 */     for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES)
/*     */     {
/*  81 */       if (typeDescr[2].equals(primitiveKey))
/*     */       {
/*  83 */         return true;
/*     */       }
/*     */     }
/*  86 */     return false;
/*     */   }
/*     */ 
/*     */   public static SimpleMetaType<?> getPrimitiveMetaType(String primitiveTypeName)
/*     */   {
/*  97 */     for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES)
/*     */     {
/*  99 */       if (primitiveTypeName.equals(typeDescr[1]))
/* 100 */         return (SimpleMetaType)typeDescr[3];
/*     */     }
/* 102 */     return null;
/*     */   }
/*     */ 
/*     */   public static String getPrimitiveEncoding(String typeName)
/*     */   {
/* 113 */     for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES)
/*     */     {
/* 115 */       if (typeName.equals(typeDescr[0]))
/* 116 */         return (String)typeDescr[2];
/*     */     }
/* 118 */     return null;
/*     */   }
/*     */ 
/*     */   public static String getPrimitiveName(String typeName)
/*     */   {
/* 129 */     for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES)
/*     */     {
/* 131 */       if (typeName.equals(typeDescr[0]))
/* 132 */         return (String)typeDescr[1];
/*     */     }
/* 134 */     return null;
/*     */   }
/*     */ 
/*     */   public static <E extends Serializable> ArrayMetaType<E[]> getArrayType(MetaType<E> elementType)
/*     */   {
/* 145 */     return new ArrayMetaType(1, elementType);
/*     */   }
/*     */ 
/*     */   public static <T extends Serializable> ArrayMetaType<T> getPrimitiveArrayType(Class<T> arrayClass)
/*     */   {
/* 156 */     if (!arrayClass.isArray())
/*     */     {
/* 158 */       throw new IllegalArgumentException("arrayClass must be an array");
/*     */     }
/*     */ 
/* 161 */     int n = 1;
/* 162 */     Class componentType = arrayClass.getComponentType();
/* 163 */     while (componentType.isArray())
/*     */     {
/* 165 */       n++;
/* 166 */       componentType = componentType.getComponentType();
/*     */     }
/* 168 */     String componentTypeName = componentType.getName();
/*     */ 
/* 170 */     if (!componentType.isPrimitive())
/*     */     {
/* 172 */       throw new IllegalArgumentException("component type of the array must be a primitive type");
/*     */     }
/*     */ 
/* 176 */     SimpleMetaType simpleType = getPrimitiveMetaType(componentTypeName);
/*     */ 
/* 180 */     ArrayMetaType at = new ArrayMetaType(simpleType, true);
/* 181 */     if (n > 1)
/* 182 */       at = new ArrayMetaType(n - 1, at);
/* 183 */     return at;
/*     */   }
/*     */ 
/*     */   private static String genName(int dimension, MetaType elementType, boolean isPrimitive)
/*     */   {
/* 196 */     if (dimension < 1)
/* 197 */       throw new IllegalArgumentException("negative dimension");
/* 198 */     if (elementType == null)
/* 199 */       throw new IllegalArgumentException("null element type");
/* 200 */     if ((elementType instanceof ArrayMetaType))
/* 201 */       throw new IllegalArgumentException("array type cannot be an element of an array type");
/* 202 */     StringBuilder buffer = new StringBuilder();
/* 203 */     for (int i = 0; i < dimension; i++)
/* 204 */       buffer.append('[');
/* 205 */     if (isPrimitive)
/*     */     {
/* 207 */       buffer.append(getPrimitiveEncoding(elementType.getClassName()));
/*     */     }
/*     */     else
/*     */     {
/* 211 */       buffer.append('L');
/* 212 */       buffer.append(elementType.getClassName());
/* 213 */       buffer.append(';');
/*     */     }
/* 215 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private static String genType(int dimension, MetaType elementType, boolean isPrimitive)
/*     */   {
/* 228 */     if (dimension < 1)
/* 229 */       throw new IllegalArgumentException("negative dimension");
/* 230 */     if (elementType == null)
/* 231 */       throw new IllegalArgumentException("null element type");
/* 232 */     if ((elementType instanceof ArrayMetaType))
/* 233 */       throw new IllegalArgumentException("array type cannot be an element of an array type");
/* 234 */     StringBuilder buffer = new StringBuilder();
/* 235 */     for (int i = 0; i < dimension; i++)
/* 236 */       buffer.append('[');
/* 237 */     if (isPrimitive)
/*     */     {
/* 239 */       buffer.append(getPrimitiveEncoding(elementType.getClassName()));
/*     */     }
/*     */     else
/*     */     {
/* 243 */       buffer.append('L');
/* 244 */       buffer.append(elementType.getClassName());
/* 245 */       buffer.append(';');
/*     */     }
/* 247 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private static String genDesc(int dimension, MetaType elementType, boolean isPrimitive)
/*     */   {
/* 260 */     StringBuilder buffer = new StringBuilder();
/* 261 */     buffer.append(new Integer(dimension));
/* 262 */     buffer.append("-dimension array of ");
/* 263 */     if (isPrimitive)
/* 264 */       buffer.append(getPrimitiveName(elementType.getTypeName()));
/*     */     else
/* 266 */       buffer.append(elementType.getTypeName());
/* 267 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public ArrayMetaType(int dimension, MetaType elementType)
/*     */   {
/* 279 */     super(genName(dimension, elementType, false), genType(dimension, elementType, false), genDesc(dimension, elementType, false));
/*     */ 
/* 282 */     this.dimension = dimension;
/* 283 */     this.elementType = elementType;
/* 284 */     this.primitiveArray = false;
/*     */   }
/*     */ 
/*     */   public ArrayMetaType(SimpleMetaType<?> elementType, boolean primitiveArray)
/*     */   {
/* 295 */     this(1, elementType, primitiveArray);
/*     */   }
/*     */ 
/*     */   public ArrayMetaType(int dimension, MetaType<?> elementType, boolean primitiveArray)
/*     */   {
/* 308 */     super(genName(dimension, elementType, primitiveArray), genType(dimension, elementType, primitiveArray), genDesc(dimension, elementType, primitiveArray));
/*     */ 
/* 311 */     this.dimension = dimension;
/* 312 */     this.elementType = elementType;
/* 313 */     this.primitiveArray = primitiveArray;
/*     */   }
/*     */ 
/*     */   public int getDimension()
/*     */   {
/* 323 */     return this.dimension;
/*     */   }
/*     */ 
/*     */   public MetaType getElementType()
/*     */   {
/* 333 */     return this.elementType;
/*     */   }
/*     */ 
/*     */   public boolean isPrimitiveArray()
/*     */   {
/* 343 */     return this.primitiveArray;
/*     */   }
/*     */ 
/*     */   public boolean isValue(Object obj)
/*     */   {
/* 350 */     if (obj == null) {
/* 351 */       return false;
/*     */     }
/* 353 */     Class clazz = obj.getClass();
/* 354 */     if ((!clazz.isArray()) && (!(obj instanceof ArrayValue))) {
/* 355 */       return false;
/*     */     }
/* 357 */     if ((this.elementType instanceof SimpleMetaType)) {
/* 358 */       return recursiveCheck((Object[])(Object[])obj, this.dimension);
/*     */     }
/* 360 */     if (((this.elementType instanceof TableMetaType)) || ((this.elementType instanceof CompositeMetaType)))
/*     */     {
/* 363 */       if ((obj instanceof ArrayValue))
/*     */       {
/* 365 */         ArrayValue av = (ArrayValue)obj;
/* 366 */         return equals(av.getMetaType());
/*     */       }
/*     */ 
/* 369 */       Class thisClass = null;
/*     */       try
/*     */       {
/* 372 */         thisClass = Thread.currentThread().getContextClassLoader().loadClass(getClassName());
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 376 */         return false;
/*     */       }
/* 378 */       if (!thisClass.isAssignableFrom(clazz))
/* 379 */         return false;
/* 380 */       return recursiveCheck((Object[])(Object[])obj, this.dimension);
/*     */     }
/* 382 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 388 */     if (this == obj)
/* 389 */       return true;
/* 390 */     if ((obj == null) || (!(obj instanceof ArrayMetaType)))
/* 391 */       return false;
/* 392 */     ArrayMetaType other = (ArrayMetaType)obj;
/* 393 */     return (getDimension() == other.getDimension()) && (getElementType().equals(other.getElementType()));
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 399 */     if (this.cachedHashCode != -2147483648)
/* 400 */       return this.cachedHashCode;
/* 401 */     this.cachedHashCode = (getDimension() + getElementType().hashCode());
/* 402 */     return this.cachedHashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 408 */     if (this.cachedToString != null)
/* 409 */       return this.cachedToString;
/* 410 */     StringBuilder buffer = new StringBuilder(ArrayMetaType.class.getSimpleName());
/* 411 */     buffer.append("{type=");
/* 412 */     buffer.append(getTypeName());
/* 413 */     buffer.append(" dims=");
/* 414 */     buffer.append(this.dimension);
/* 415 */     buffer.append(" elementType=");
/* 416 */     buffer.append(this.elementType);
/* 417 */     this.cachedToString = buffer.toString();
/* 418 */     return this.cachedToString;
/*     */   }
/*     */ 
/*     */   private boolean recursiveCheck(Object[] elements, int dimension)
/*     */   {
/* 431 */     if (dimension == 1)
/*     */     {
/* 434 */       for (int i = 0; i < elements.length; i++)
/*     */       {
/* 436 */         if ((elements[i] != null) && (!this.elementType.isValue(elements[i]))) {
/* 437 */           return false;
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 443 */       for (int i = 0; i < elements.length; i++)
/*     */       {
/* 445 */         if (!recursiveCheck((Object[])(Object[])elements[i], dimension - 1))
/* 446 */           return false;
/*     */       }
/*     */     }
/* 449 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.types.ArrayMetaType
 * JD-Core Version:    0.6.0
 */