/*     */ package org.jboss.metatype.api.types;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.metatype.api.values.CollectionValue;
/*     */ 
/*     */ public class CollectionMetaType<T extends Serializable> extends AbstractMetaType
/*     */ {
/*     */   private static final long serialVersionUID = -2062790692152055156L;
/*     */   private MetaType elementType;
/*  44 */   private transient int cachedHashCode = -2147483648;
/*     */ 
/*  47 */   private transient String cachedToString = null;
/*     */ 
/*     */   public CollectionMetaType(String className, MetaType<T> elementType)
/*     */   {
/*  51 */     super(className);
/*  52 */     if (elementType == null)
/*  53 */       throw new IllegalArgumentException("Null element type");
/*  54 */     this.elementType = elementType;
/*     */   }
/*     */ 
/*     */   public CollectionMetaType(String className, String description, MetaType<T> elementType)
/*     */   {
/*  59 */     super(className, description);
/*  60 */     if (elementType == null)
/*  61 */       throw new IllegalArgumentException("Null element type");
/*  62 */     this.elementType = elementType;
/*     */   }
/*     */ 
/*     */   public CollectionMetaType(String className, String typeName, String description, MetaType<T> elementType)
/*     */   {
/*  67 */     super(className, typeName, description);
/*  68 */     if (elementType == null)
/*  69 */       throw new IllegalArgumentException("Null element type");
/*  70 */     this.elementType = elementType;
/*     */   }
/*     */ 
/*     */   public boolean isCollection()
/*     */   {
/*  75 */     return true;
/*     */   }
/*     */ 
/*     */   public static <E extends Serializable> CollectionMetaType<E> getCollectionType(String collectionType, MetaType<E> elementType)
/*     */   {
/*  87 */     return new CollectionMetaType(collectionType, elementType);
/*     */   }
/*     */ 
/*     */   public MetaType getElementType()
/*     */   {
/*  97 */     return this.elementType;
/*     */   }
/*     */ 
/*     */   public boolean isValue(Object obj)
/*     */   {
/* 104 */     if (obj == null) {
/* 105 */       return false;
/*     */     }
/* 107 */     if ((!(obj instanceof Collection)) && (!(obj instanceof CollectionValue))) {
/* 108 */       return false;
/*     */     }
/* 110 */     if ((obj instanceof CollectionValue))
/*     */     {
/* 112 */       CollectionValue cv = (CollectionValue)obj;
/* 113 */       return equals(cv.getMetaType());
/*     */     }
/*     */ 
/* 116 */     Collection collection = (Collection)obj;
/* 117 */     for (Iterator i$ = collection.iterator(); i$.hasNext(); ) { Object element = i$.next();
/*     */ 
/* 119 */       if (!this.elementType.isValue(element)) {
/* 120 */         return false;
/*     */       }
/*     */     }
/* 123 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 129 */     if (this == obj)
/* 130 */       return true;
/* 131 */     if ((obj == null) || (!(obj instanceof CollectionMetaType)))
/* 132 */       return false;
/* 133 */     CollectionMetaType other = (CollectionMetaType)obj;
/* 134 */     return (getTypeName().equals(other.getTypeName())) && (getElementType().equals(other.getElementType()));
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 140 */     if (this.cachedHashCode != -2147483648)
/* 141 */       return this.cachedHashCode;
/* 142 */     this.cachedHashCode = (getTypeName().hashCode() + getElementType().hashCode());
/* 143 */     return this.cachedHashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 149 */     if (this.cachedToString != null)
/* 150 */       return this.cachedToString;
/* 151 */     StringBuilder buffer = new StringBuilder(CollectionMetaType.class.getSimpleName());
/* 152 */     buffer.append("{type=");
/* 153 */     buffer.append(getTypeName());
/* 154 */     buffer.append(" elementType=");
/* 155 */     buffer.append(this.elementType);
/* 156 */     this.cachedToString = buffer.toString();
/* 157 */     return this.cachedToString;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.types.CollectionMetaType
 * JD-Core Version:    0.6.0
 */