/*    */ package org.jboss.metatype.api.types;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.math.BigDecimal;
/*    */ import java.math.BigInteger;
/*    */ import java.util.Arrays;
/*    */ import java.util.Collections;
/*    */ import java.util.Date;
/*    */ import java.util.List;
/*    */ import org.jboss.metatype.api.values.ArrayValue;
/*    */ import org.jboss.metatype.api.values.CompositeValue;
/*    */ import org.jboss.metatype.api.values.EnumValue;
/*    */ import org.jboss.metatype.api.values.GenericValue;
/*    */ import org.jboss.metatype.api.values.SimpleValue;
/*    */ import org.jboss.metatype.api.values.TableValue;
/*    */ 
/*    */ public abstract interface MetaType<T extends Serializable> extends Serializable
/*    */ {
/* 73 */   public static final List<String> ALLOWED_CLASSNAMES = Collections.unmodifiableList(Arrays.asList(new String[] { Void.class.getName(), Boolean.class.getName(), Character.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), String.class.getName(), Date.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), Name.class.getName(), SimpleValue.class.getName(), EnumValue.class.getName(), GenericValue.class.getName(), ArrayValue.class.getName(), CompositeValue.class.getName(), TableValue.class.getName() }));
/*    */ 
/*    */   public abstract String getClassName();
/*    */ 
/*    */   public abstract String getTypeName();
/*    */ 
/*    */   public abstract String getDescription();
/*    */ 
/*    */   public abstract boolean isArray();
/*    */ 
/*    */   public abstract boolean isCollection();
/*    */ 
/*    */   public abstract boolean isEnum();
/*    */ 
/*    */   public abstract boolean isSimple();
/*    */ 
/*    */   public abstract boolean isGeneric();
/*    */ 
/*    */   public abstract boolean isComposite();
/*    */ 
/*    */   public abstract boolean isTable();
/*    */ 
/*    */   public abstract boolean isValue(Object paramObject);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.types.MetaType
 * JD-Core Version:    0.6.0
 */