/*    */ package org.jboss.metatype.api.types;
/*    */ 
/*    */ import java.lang.reflect.Type;
/*    */ import org.jboss.metatype.plugins.types.MetaTypeFactoryBuilder;
/*    */ import org.jboss.metatype.spi.types.MetaTypeBuilder;
/*    */ import org.jboss.reflect.spi.TypeInfo;
/*    */ 
/*    */ public abstract class MetaTypeFactory
/*    */ {
/* 39 */   private static final MetaTypeFactoryBuilder builder = new MetaTypeFactoryBuilder();
/*    */ 
/*    */   public static final MetaTypeFactory getInstance()
/*    */   {
/* 48 */     return MetaTypeFactoryBuilder.create();
/*    */   }
/*    */ 
/*    */   public abstract MetaType resolve(Type paramType);
/*    */ 
/*    */   public abstract MetaType resolve(TypeInfo paramTypeInfo);
/*    */ 
/*    */   public MetaType resolve(String className, ClassLoader classLoader)
/*    */     throws ClassNotFoundException
/*    */   {
/* 80 */     if (className == null)
/* 81 */       throw new IllegalArgumentException("Null className");
/* 82 */     if (classLoader == null)
/* 83 */       throw new IllegalArgumentException("Null classLoader");
/* 84 */     Class clazz = classLoader.loadClass(className);
/* 85 */     return resolve(clazz);
/*    */   }
/*    */ 
/*    */   public abstract void setBuilder(Class<?> paramClass, MetaTypeBuilder paramMetaTypeBuilder);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.types.MetaTypeFactory
 * JD-Core Version:    0.6.0
 */